/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.model.adapter.IContentAdapterProvider;
import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.IOutlineContribution;
import org.eclipse.handly.ui.outline.IOutlineInputChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public abstract class CommonOutlinePage
extends Page
implements ICommonOutlinePage {
    private TreeViewer treeViewer;
    private IEditorPart editor;
    private List<IOutlineContribution> contributionList = new ArrayList<IOutlineContribution>();
    private ListenerList<IOutlineInputChangeListener> inputChangeListeners = new ListenerList();
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private IPropertyListener editorInputListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 258) {
                CommonOutlinePage.this.editorInputChanged();
            }
        }
    };

    @Override
    public final TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    @Override
    public void init(IEditorPart editor) {
        if (editor == null) {
            throw new IllegalArgumentException();
        }
        this.editor = editor;
    }

    @Override
    public final IEditorPart getEditor() {
        return this.editor;
    }

    @Override
    public void addOutlineContribution(IOutlineContribution contribution) {
        if (this.contributionList.add(contribution) && this.getTreeViewer() != null && !this.getControl().isDisposed()) {
            contribution.init(this);
        }
    }

    @Override
    public void removeOutlineContribution(IOutlineContribution contribution) {
        if (this.contributionList.remove(contribution) && this.getTreeViewer() != null) {
            contribution.dispose();
        }
    }

    @Override
    public void addInputChangeListener(IOutlineInputChangeListener listener) {
        this.inputChangeListeners.add((Object)listener);
    }

    @Override
    public void removeInputChangeListener(IOutlineInputChangeListener listener) {
        this.inputChangeListeners.remove((Object)listener);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public final Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public void createControl(Composite parent) {
        if (this.editor == null) {
            throw new IllegalStateException("init(IEditorPart) must be called before the outline page's control is created");
        }
        this.treeViewer = this.createTreeViewer(parent);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommonOutlinePage.this.fireSelectionChanged(event.getSelection());
            }
        });
        this.treeViewer.setUseHashlookup(this.shouldUseHashlookup());
        this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        IBaseLabelProvider labelProvider = this.getLabelProvider();
        this.setUpDecorationContextFor(labelProvider);
        this.treeViewer.setLabelProvider(labelProvider);
        this.treeViewer.setInput(this.computeInput());
        this.editor.addPropertyListener(this.editorInputListener);
        this.registerGlobalActions();
        this.initContributions();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removePropertyListener(this.editorInputListener);
        }
        this.disposeContributions();
        super.dispose();
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void refresh() {
        Control control = this.treeViewer.getControl();
        try {
            control.setRedraw(false);
            BusyIndicator.showWhile((Display)control.getDisplay(), () -> {
                TreePath[] treePaths = this.treeViewer.getExpandedTreePaths();
                this.treeViewer.refresh();
                this.treeViewer.setExpandedTreePaths(treePaths);
            });
        }
        finally {
            control.setRedraw(true);
        }
    }

    protected boolean shouldUseHashlookup() {
        return true;
    }

    protected abstract ITreeContentProvider getContentProvider();

    protected abstract IBaseLabelProvider getLabelProvider();

    protected abstract Object computeInput();

    protected OutlineTreeViewer createTreeViewer(Composite parent) {
        return new OutlineTreeViewer(new Tree(parent, 770));
    }

    protected void editorInputChanged() {
        this.treeViewer.setInput(this.computeInput());
    }

    protected boolean isAutoExpandable(TreeItem item) {
        return item.getParentItem() == null;
    }

    protected void registerGlobalActions() {
        IActionBars actionBars = this.getSite().getActionBars();
        if (this.editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)this.editor;
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, textEditor.getAction(ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, textEditor.getAction(ITextEditorActionConstants.REDO));
            IAction action = textEditor.getAction(ITextEditorActionConstants.NEXT);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
            action = textEditor.getAction(ITextEditorActionConstants.PREVIOUS);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
        }
    }

    protected void initDecorationContext(DecorationContext context) {
        if (this instanceof IContentAdapterProvider) {
            context.putProperty(IContentAdapterProvider.class.getName(), (Object)this);
        }
    }

    private void initContributions() {
        ArrayList<IOutlineContribution> contributions = new ArrayList<IOutlineContribution>(this.contributionList);
        for (final IOutlineContribution contribution : contributions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    contribution.init(CommonOutlinePage.this);
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    private void disposeContributions() {
        ArrayList<IOutlineContribution> contributions = new ArrayList<IOutlineContribution>(this.contributionList);
        for (final IOutlineContribution contribution : contributions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    contribution.dispose();
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    private void fireInputChanged(final Object input, final Object oldInput) {
        Object[] listeners;
        Object[] objectArray = listeners = this.inputChangeListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() {
                    ((IOutlineInputChangeListener)listener).inputChanged(CommonOutlinePage.this, input, oldInput);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++n2;
        }
    }

    private void fireSelectionChanged(ISelection selection) {
        Object[] listeners;
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = listeners = this.selectionChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() {
                    ((ISelectionChangedListener)listener).selectionChanged(event);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++n2;
        }
    }

    private void setUpDecorationContextFor(IBaseLabelProvider labelProvider) {
        if (labelProvider instanceof DecoratingLabelProvider) {
            DecoratingLabelProvider dlp = (DecoratingLabelProvider)labelProvider;
            dlp.setDecorationContext(this.createDecorationContext(dlp.getDecorationContext()));
        } else if (labelProvider instanceof DecoratingStyledCellLabelProvider) {
            DecoratingStyledCellLabelProvider dsclp = (DecoratingStyledCellLabelProvider)labelProvider;
            dsclp.setDecorationContext(this.createDecorationContext(dsclp.getDecorationContext()));
        }
    }

    private IDecorationContext createDecorationContext(IDecorationContext existingContext) {
        DecorationContext newContext = new DecorationContext();
        this.initDecorationContext(newContext);
        if (existingContext != null) {
            String[] stringArray = existingContext.getProperties();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                newContext.putProperty(property, existingContext.getProperty(property));
                ++n2;
            }
        }
        return newContext;
    }

    protected class OutlineTreeViewer
    extends TreeViewer {
        public OutlineTreeViewer(Tree tree) {
            super(tree);
            this.setAutoExpandLevel(-1);
        }

        protected void inputChanged(Object input, Object oldInput) {
            super.inputChanged(input, oldInput);
            CommonOutlinePage.this.fireInputChanged(input, oldInput);
        }

        protected void internalExpandToLevel(Widget node, int level) {
            TreeItem item;
            if (node instanceof TreeItem && !this.canExpand(item = (TreeItem)node)) {
                this.setExpanded((Item)item, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        protected boolean canExpand(TreeItem item) {
            return CommonOutlinePage.this.isAutoExpandable(item);
        }
    }
}

