/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui;

import java.util.HashMap;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.snapshot.TextFileBufferSnapshot;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    protected EditorUtility() {
    }

    public IEditorInput getEditorInput(Object element) {
        IElement adapterElement;
        if (element instanceof IEditorInput) {
            return (IEditorInput)element;
        }
        IResource resource = element instanceof IResource ? (IResource)element : ((adapterElement = (IElement)Adapters.adapt((Object)element, IElement.class)) != null ? Elements.getResource((IElement)adapterElement) : ResourceUtil.getResource((Object)element));
        if (resource instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        return null;
    }

    public IEditorReference findEditor(IWorkbenchPage page, Object element) {
        IEditorReference found;
        IElement adapterElement;
        if (page == null) {
            throw new IllegalArgumentException();
        }
        if (element == null) {
            throw new IllegalArgumentException();
        }
        IEditorInput input = this.getEditorInput(element);
        if (input == null) {
            return null;
        }
        IEditorReference[] references = page.findEditors(input, null, 1);
        if (references.length == 0) {
            return null;
        }
        IEditorReference result = references[0];
        IEditorPart editor = result.getEditor(false);
        if (editor instanceof ITextEditor && (adapterElement = (IElement)Adapters.adapt((Object)element, IElement.class)) instanceof ISourceElement && (found = this.findSourceEditor(references, (ISourceElement)adapterElement)) != null) {
            result = found;
        }
        return result;
    }

    public void revealElement(IEditorPart editor, Object element) {
        ITextEditor textEditor;
        if (editor == null) {
            throw new IllegalArgumentException();
        }
        if (element == null) {
            throw new IllegalArgumentException();
        }
        IElement adapterElement = (IElement)Adapters.adapt((Object)element, IElement.class);
        if (adapterElement instanceof ISourceElement && (textEditor = (ITextEditor)Adapters.adapt((Object)editor, ITextEditor.class, (boolean)false)) != null && this.revealSourceElement(textEditor, (ISourceElement)adapterElement)) {
            return;
        }
        ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void revealTextRange(IEditorPart editor, int offset, int length, ISnapshot snapshot) {
        if (editor == null) {
            throw new IllegalArgumentException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        ITextEditor textEditor = (ITextEditor)Adapters.adapt((Object)editor, ITextEditor.class);
        if (textEditor != null) {
            IDocument document;
            if (snapshot != null && (document = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput())) instanceof IDocumentExtension4 && !snapshot.isEqualTo((ISnapshot)new DocumentSnapshot(document))) {
                throw new StaleSnapshotException();
            }
            textEditor.selectAndReveal(offset, length);
            return;
        }
        IGotoMarker gotoMarker = (IGotoMarker)Adapters.adapt((Object)editor, IGotoMarker.class);
        if (gotoMarker != null) {
            ITextFileBufferManager bufferManager;
            ITextFileBuffer buffer;
            IFile file = ResourceUtil.getFile((IEditorInput)editor.getEditorInput());
            if (file == null) return;
            if (snapshot != null && (buffer = (bufferManager = ITextFileBufferManager.DEFAULT).getTextFileBuffer(file.getFullPath(), LocationKind.IFILE)) != null && !snapshot.isEqualTo((ISnapshot)new TextFileBufferSnapshot(buffer, bufferManager))) {
                throw new StaleSnapshotException();
            }
            IMarker marker = null;
            try {
                try {
                    marker = file.createMarker("org.eclipse.core.resources.textmarker");
                    HashMap<String, Integer> attributes = new HashMap<String, Integer>();
                    attributes.put("charStart", offset);
                    attributes.put("charEnd", offset + length);
                    marker.setAttributes(attributes);
                    gotoMarker.gotoMarker(marker);
                    return;
                }
                catch (CoreException coreException) {
                    if (marker == null) return;
                    try {
                        marker.delete();
                        return;
                    }
                    catch (CoreException coreException2) {}
                }
                return;
            }
            finally {
                if (marker != null) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {}
                }
            }
        }
        ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
        if (selectionProvider == null) return;
        selectionProvider.setSelection((ISelection)new TextSelection(offset, length));
    }

    protected IBuffer getBuffer(ISourceElement element) {
        block3: {
            ISourceFile sourceFile = Elements.getSourceFile((IElement)element);
            if (sourceFile != null) {
                try {
                    return Elements.getBuffer((ISourceFile)sourceFile);
                }
                catch (CoreException e) {
                    if (!Elements.exists((IElement)element)) break block3;
                    Activator.logError(e);
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private IEditorReference findSourceEditor(IEditorReference[] references, ISourceElement element) {
        var3_3 = null;
        var4_5 = null;
        try {
            buffer = this.getBuffer(element);
            try {
                if (buffer != null) {
                    var9_8 = references;
                    var8_9 = references.length;
                    var7_10 = 0;
                    while (true) {
                        reference = var9_8[var7_10];
                        editor = reference.getEditor(true);
                        if (editor != null && (textEditor = (ITextEditor)Adapters.adapt((Object)editor, ITextEditor.class, (boolean)false)) != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null && document.equals(buffer.getDocument())) {
                            return reference;
                        }
                        ++var7_10;
                        return var7_10;
                    }
                }
            }
            finally {
                if (var7_10 < var8_9) ** continue;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean revealSourceElement(ITextEditor editor, ISourceElement element) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (IBuffer buffer = this.getBuffer(element);){
            if (buffer == null) return false;
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            if (document == null) return false;
            if (!document.equals(buffer.getDocument())) return false;
            Elements.ensureReconciled((ISourceElement)element, null);
            TextRange identifyingRange = Elements.getSourceElementInfo2((ISourceElement)element).getIdentifyingRange();
            if (identifyingRange == null) return false;
            editor.selectAndReveal(identifyingRange.getOffset(), identifyingRange.getLength());
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

