/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<K, V> {
    private Map<K, Entry<K, V>> map = new HashMap<K, Entry<K, V>>();
    private Entry<K, V> head;
    private Entry<K, V> tail;

    public final int size() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final V get(Object key) {
        Entry<K, V> entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        this.moveToMru(entry);
        return entry.value;
    }

    public final V peek(Object key) {
        Entry<K, V> entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    public final V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Entry<K, V> entry = this.map.get(key);
        if (entry != null) {
            Object oldValue = entry.value;
            this.update(entry, value);
            return oldValue;
        }
        this.add(this.newEntry(key, value));
        return null;
    }

    public final V remove(Object key) {
        Entry<K, V> entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        Object oldValue = entry.value;
        this.remove(entry);
        return oldValue;
    }

    public void clear() {
        this.map.clear();
        this.tail = null;
        this.head = null;
    }

    public final Map<K, V> snapshot() {
        LinkedHashMap snapshot = new LinkedHashMap(this.size());
        Entry<K, V> e = this.head;
        while (e != null) {
            snapshot.put(e.key, e.value);
            e = e.next;
        }
        return snapshot;
    }

    public String toString() {
        Entry<K, V> e = this.head;
        if (e == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            sb.append(e);
            e = e.next;
            if (e == null) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    protected final Entry<K, V> getMruEntry() {
        return this.head;
    }

    protected final Entry<K, V> getLruEntry() {
        return this.tail;
    }

    protected final Entry<K, V> entryByKey(Object key) {
        return this.map.get(key);
    }

    protected Entry<K, V> newEntry(K key, V value) {
        return new Entry<K, V>(key, value);
    }

    protected void add(Entry<K, V> entry) {
        this.doAdd(entry);
    }

    protected void update(Entry<K, V> entry, V value) {
        entry.value = value;
        this.moveToMru(entry);
    }

    protected void remove(Entry<K, V> entry) {
        this.doRemove(entry);
    }

    protected void doAdd(Entry<K, V> entry) {
        this.map.put(entry.key, entry);
        this.linkHead(entry);
    }

    protected void doRemove(Entry<K, V> entry) {
        this.map.remove(entry.key);
        this.unlink(entry);
    }

    protected void moveToMru(Entry<K, V> entry) {
        this.unlink(entry);
        this.linkHead(entry);
    }

    private void linkHead(Entry<K, V> entry) {
        entry.prev = null;
        entry.next = this.head;
        if (this.head == null) {
            this.tail = entry;
        } else {
            this.head.prev = entry;
        }
        this.head = entry;
    }

    private void unlink(Entry<K, V> entry) {
        Entry prev = entry.prev;
        Entry next = entry.next;
        if (prev != null) {
            prev.next = next;
        }
        if (next != null) {
            next.prev = prev;
        }
        if (this.head == entry) {
            this.head = next;
        }
        if (this.tail == entry) {
            this.tail = prev;
        }
    }

    protected static class Entry<K, V> {
        public final K key;
        public V value;
        Entry<K, V> prev;
        Entry<K, V> next;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public final Entry<K, V> prev() {
            return this.prev;
        }

        public final Entry<K, V> next() {
            return this.next;
        }

        public String toString() {
            return String.valueOf(this.key.toString()) + '=' + this.value;
        }
    }
}

