/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.callhierarchy;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyKind;
import org.eclipse.handly.ui.callhierarchy.ICallLocation;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

public interface ICallHierarchyNode
extends IAdaptable {
    public static final IWorkbenchAdapter DEFAULT_WORKBENCH_ADAPTER = new WorkbenchAdapter(){

        public Object getParent(Object o) {
            if (o instanceof ICallHierarchyNode) {
                return ((ICallHierarchyNode)o).getParent();
            }
            return null;
        }
    };

    default public <T> T getAdapter(Class<T> adapter) {
        Object element = this.getElement();
        if (adapter.isInstance(element)) {
            return (T)element;
        }
        if (adapter == IWorkbenchAdapter.class) {
            return (T)DEFAULT_WORKBENCH_ADAPTER;
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public CallHierarchyKind getKind();

    public Object getElement();

    public ICallHierarchyNode getParent();

    public ICallLocation[] getCallLocations();

    default public boolean isRecursive() {
        Object element = this.getElement();
        ICallHierarchyNode p = this.getParent();
        while (p != null) {
            if (element.equals(p.getElement())) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    default public boolean mayHaveChildren() {
        return !this.isRecursive();
    }

    public ICallHierarchyNode[] getChildren(IProgressMonitor var1);

    default public void refresh() {
    }
}

