/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class DelegatingSelectionProvider
implements IPostSelectionProvider {
    private final ListenerList<ISelectionChangedListener> selectionListeners = new ListenerList();
    private final ListenerList<ISelectionChangedListener> postSelectionListeners = new ListenerList();
    private final ISelectionChangedListener selectionListener = e -> this.fireSelectionChanged(e.getSelection());
    private final ISelectionChangedListener postSelectionListener = e -> this.firePostSelectionChanged(e.getSelection());
    private ISelectionProvider delegate;

    public void setDelegate(ISelectionProvider newDelegate) {
        if (newDelegate == this.delegate) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.selectionListener);
            if (this.delegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.delegate).removePostSelectionChangedListener(this.postSelectionListener);
            }
        }
        this.delegate = newDelegate;
        if (newDelegate != null) {
            newDelegate.addSelectionChangedListener(this.selectionListener);
            if (newDelegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)newDelegate).addPostSelectionChangedListener(this.postSelectionListener);
            }
            ISelection selection = newDelegate.getSelection();
            this.fireSelectionChanged(selection);
            this.firePostSelectionChanged(selection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.delegate == null ? null : this.delegate.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (this.delegate != null) {
            this.delegate.setSelection(selection);
        }
    }

    protected final ISelectionProvider getDelegate() {
        return this.delegate;
    }

    protected SelectionChangedEvent newSelectionChangedEvent(ISelection selection) {
        return new SelectionChangedEvent((ISelectionProvider)this, selection);
    }

    private void fireSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.selectionListeners, selection);
    }

    private void firePostSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.postSelectionListeners, selection);
    }

    private void fireSelectionChanged(ListenerList<ISelectionChangedListener> listeners, ISelection selection) {
        SelectionChangedEvent event = this.newSelectionChangedEvent(selection);
        for (ISelectionChangedListener listener : listeners) {
            listener.selectionChanged(event);
        }
    }
}

