/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.search;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.handly.ui.search.AbstractSearchContentProvider;
import org.eclipse.handly.ui.search.AbstractSearchResultPage;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public abstract class AbstractSearchTreeContentProvider
extends AbstractSearchContentProvider
implements ITreeContentProvider {
    private Map<Object, Set<Object>> childrenMap;

    public AbstractSearchTreeContentProvider(AbstractSearchResultPage page) {
        super(page);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.initialize((AbstractTextSearchResult)newInput);
    }

    public Object[] getElements(Object inputElement) {
        Object[] children = this.getChildren(inputElement);
        Integer limit = this.getPage().getElementLimit();
        if (limit != null && limit >= 0 && limit < children.length) {
            return Arrays.copyOf(children, (int)limit);
        }
        return children;
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.childrenMap.get(parentElement);
        if (children == null) {
            return NO_ELEMENTS;
        }
        return children.toArray(NO_ELEMENTS);
    }

    public boolean hasChildren(Object element) {
        Set<Object> children = this.childrenMap.get(element);
        return children != null && !children.isEmpty();
    }

    @Override
    public void elementsChanged(Object[] elements) {
        if (elements.length == 0) {
            return;
        }
        AbstractTextSearchResult inputElement = this.getPage().getInput();
        if (inputElement == null) {
            return;
        }
        HashMap<Object, Set<Object>> toAdd = new HashMap<Object, Set<Object>>();
        HashSet<Object> toRemove = new HashSet<Object>();
        HashSet<Object> toUpdate = new HashSet<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.getPage().getDisplayedMatchCount(element) > 0) {
                this.insert(element, toAdd, toUpdate);
            } else {
                this.remove(element, toRemove, toUpdate);
            }
            ++n2;
        }
        TreeViewer viewer = (TreeViewer)this.getPage().getViewer();
        if (!toRemove.isEmpty()) {
            viewer.remove(toRemove.toArray());
        }
        Integer limit = this.getPage().getElementLimit();
        for (Map.Entry entry : toAdd.entrySet()) {
            Object parent = entry.getKey();
            Object[] children = ((Set)entry.getValue()).toArray(NO_ELEMENTS);
            if (parent == inputElement && limit != null && limit >= 0 && children.length > 0) {
                int addLimit = limit - viewer.getTree().getItemCount();
                if (addLimit <= 0) {
                    children = NO_ELEMENTS;
                } else if (addLimit < children.length) {
                    children = Arrays.copyOf(children, addLimit);
                }
            }
            if (children.length <= 0) continue;
            viewer.add(parent, children);
        }
        for (Object e : toUpdate) {
            viewer.refresh(e);
        }
    }

    @Override
    public void clear() {
        this.initialize(this.getPage().getInput());
        this.getPage().getViewer().refresh();
    }

    private void initialize(AbstractTextSearchResult result) {
        this.childrenMap = new HashMap<Object, Set<Object>>();
        if (result == null) {
            return;
        }
        Object[] objectArray = result.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.getPage().getDisplayedMatchCount(element) > 0) {
                this.insert(element, null, null);
            }
            ++n2;
        }
    }

    private void insert(Object child, Map<Object, Set<Object>> toAdd, Set<Object> toUpdate) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (AbstractSearchTreeContentProvider.insert(this.childrenMap, parent, child)) {
                if (toAdd != null) {
                    AbstractSearchTreeContentProvider.insert(toAdd, parent, child);
                }
            } else {
                if (toUpdate != null) {
                    toUpdate.add(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (AbstractSearchTreeContentProvider.insert(this.childrenMap, this.getPage().getInput(), child) && toAdd != null) {
            AbstractSearchTreeContentProvider.insert(toAdd, this.getPage().getInput(), child);
        }
    }

    private static boolean insert(Map<Object, Set<Object>> map, Object parent, Object child) {
        Set<Object> children = map.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            map.put(parent, children);
        }
        return children.add(child);
    }

    private void remove(Object element, Set<Object> toRemove, Set<Object> toUpdate) {
        if (this.hasChildren(element) || this.getPage().getDisplayedMatchCount(element) > 0) {
            if (toUpdate != null) {
                toUpdate.add(element);
            }
        } else {
            this.childrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                if (this.removeChild(parent, element)) {
                    this.remove(parent, toRemove, toUpdate);
                }
            } else if (this.removeChild(this.getPage().getInput(), element) && toRemove != null) {
                toRemove.add(element);
            }
        }
    }

    private boolean removeChild(Object parent, Object child) {
        Set<Object> children = this.childrenMap.get(parent);
        if (children == null) {
            return false;
        }
        return children.remove(child);
    }
}

