/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.texteditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.IBufferListener;
import org.eclipse.handly.buffer.UiBufferChangeRunner;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.ui.texteditor.ElementStateListenerAdapter;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension3;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;

public final class TextEditorBuffer
implements IBuffer {
    private final UiSynchronizer uiSynchronizer;
    private final IEditorInput editorInput;
    private final IDocumentProvider documentProvider;
    private IDocument document;
    private IAnnotationModel annotationModel;
    private int refCount = 1;
    private ListenerList<IBufferListener> listeners;
    private IElementStateListener elementStateListener;

    public TextEditorBuffer(ITextEditor editor) throws CoreException {
        this(editor.getDocumentProvider(), editor.getEditorInput());
    }

    public TextEditorBuffer(IDocumentProvider provider, IEditorInput input) throws CoreException {
        this.editorInput = input;
        if (this.editorInput == null) {
            throw new IllegalArgumentException();
        }
        this.documentProvider = provider;
        if (this.documentProvider == null) {
            throw new IllegalArgumentException();
        }
        this.uiSynchronizer = UiSynchronizer.getDefault();
        if (this.uiSynchronizer == null) {
            throw new AssertionError();
        }
        this.checkThread();
        this.documentProvider.connect((Object)this.editorInput);
        boolean f = false;
        try {
            this.document = this.documentProvider.getDocument((Object)this.editorInput);
            if (this.document == null) {
                throw new AssertionError();
            }
            this.annotationModel = this.documentProvider.getAnnotationModel((Object)this.editorInput);
            f = true;
        }
        finally {
            if (!f) {
                this.documentProvider.disconnect((Object)this.editorInput);
            }
        }
    }

    public IDocument getDocument() {
        IDocument result = this.document;
        if (result == null) {
            throw new IllegalStateException("Attempt to access a disconnected TextEditorBuffer for " + this.editorInput.getToolTipText());
        }
        return result;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public ISnapshot getSnapshot() {
        return new DocumentSnapshot(this.getDocument());
    }

    public IBufferChange applyChange(IBufferChange change, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            UiBufferChangeRunner runner = new UiBufferChangeRunner(this.uiSynchronizer, new BufferChangeOperation((IBuffer)this, change));
            return runner.run(monitor);
        }
        catch (MalformedTreeException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    public void save(IContext context, IProgressMonitor monitor) throws CoreException {
        this.checkThread();
        this.documentProvider.saveDocument(monitor, (Object)this.editorInput, this.getDocument(), false);
    }

    public boolean isDirty() {
        this.checkThread();
        return this.documentProvider.canSaveDocument((Object)this.editorInput);
    }

    public int getSupportedListenerMethods() {
        return 1;
    }

    public void addListener(IBufferListener listener) {
        this.checkThread();
        if (this.listeners != null) {
            this.listeners.add((Object)listener);
        } else {
            this.getDocument();
            this.listeners = new ListenerList();
            this.listeners.add((Object)listener);
            this.elementStateListener = new ElementStateListener();
            this.documentProvider.addElementStateListener(this.elementStateListener);
        }
    }

    public void removeListener(IBufferListener listener) {
        this.checkThread();
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)listener);
        if (this.listeners.isEmpty()) {
            this.documentProvider.removeElementStateListener(this.elementStateListener);
            this.elementStateListener = null;
            this.listeners = null;
        }
    }

    public synchronized void addRef() {
        ++this.refCount;
    }

    public synchronized void release() {
        if (--this.refCount == 0 && this.document != null) {
            this.document = null;
            this.annotationModel = null;
            this.uiSynchronizer.asyncExec(() -> {
                try {
                    this.listeners = null;
                    if (this.elementStateListener != null) {
                        this.documentProvider.removeElementStateListener(this.elementStateListener);
                        this.elementStateListener = null;
                    }
                }
                finally {
                    this.documentProvider.disconnect((Object)this.editorInput);
                }
            });
        }
    }

    private void checkThread() {
        if (!Thread.currentThread().equals(this.uiSynchronizer.getThread())) {
            throw new IllegalStateException("Invalid thread access to TextEditorBuffer for " + this.editorInput.getToolTipText());
        }
    }

    private long getModificationStamp() {
        return this.documentProvider.getModificationStamp((Object)this.editorInput);
    }

    private boolean isSynchronized() {
        if (this.documentProvider instanceof IDocumentProviderExtension3) {
            return ((IDocumentProviderExtension3)this.documentProvider).isSynchronized((Object)this.editorInput);
        }
        return this.getModificationStamp() == this.documentProvider.getSynchronizationStamp((Object)this.editorInput);
    }

    private void fireBufferSaved() {
        for (IBufferListener listener : this.listeners) {
            SafeRunner.run(() -> listener.bufferSaved((IBuffer)this));
        }
    }

    private class ElementStateListener
    extends ElementStateListenerAdapter {
        private long modificationStamp;

        private ElementStateListener() {
            this.modificationStamp = TextEditorBuffer.this.getModificationStamp();
        }

        @Override
        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (TextEditorBuffer.this.editorInput.equals(element) && !isDirty) {
                TextEditorBuffer.this.checkThread();
                if (TextEditorBuffer.this.isSynchronized() && this.modificationStamp != TextEditorBuffer.this.getModificationStamp()) {
                    this.modificationStamp = TextEditorBuffer.this.getModificationStamp();
                    TextEditorBuffer.this.fireBufferSaved();
                }
            }
        }
    }
}

