/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.updater;

import java.io.File;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkModelResource;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.graph.TypeNode;
import org.eclipse.hawk.graph.updater.DeletionUtils;
import org.eclipse.hawk.graph.updater.TypeCache;
import org.eclipse.hawk.graph.updater.Utils;
import org.eclipse.hawk.graph.util.GraphUtil;
import org.eclipse.hawk.graph.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphModelBatchInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphModelBatchInjector.class);
    public static final String FRAGMENT_DICT_NAME = "fragmentdictionary";
    public static final String ROOT_DICT_FILE_KEY = "file";
    public static final String ROOT_DICT_NAME = "rootdictionary";
    public static final String PROXY_DICT_NAME = "proxydictionary";
    public static final String DERIVED_PROXY_DICT_NAME = "derivedproxydictionary";
    private int[] objectCount;
    private int unset;
    private String repoURL;
    private IGraphDatabase graph;
    private final Map<Pair<String, String>, IGraphNode> hash;
    IGraphNodeIndex fileDictionary;
    IGraphNodeIndex proxyDictionary;
    IGraphNodeIndex rootDictionary;
    IGraphNodeIndex fragmentIdx;
    IGraphNodeIndex derivedProxyDictionary;
    long startTime;
    private final IGraphChangeListener listener;
    private final VcsCommitItem commitItem;
    private final String tempDirURI;
    private IGraphDatabase.Mode previousMode;
    private final TypeCache typeCache;
    private boolean successState;

    private void refreshIndexes() throws Exception {
        block11: {
            IGraphDatabase.Mode currentMode = this.graph.currentMode();
            if (this.previousMode != currentMode) {
                this.previousMode = currentMode;
                if (this.graph.currentMode().equals((Object)IGraphDatabase.Mode.TX_MODE)) {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (IGraphTransaction t = this.graph.beginTransaction();){
                        this.refreshIx();
                        t.success();
                        break block11;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.refreshIx();
            }
        }
    }

    private void refreshIx() {
        this.fileDictionary = this.graph.getFileIndex();
        this.proxyDictionary = this.graph.getOrCreateNodeIndex(PROXY_DICT_NAME);
        this.rootDictionary = this.graph.getOrCreateNodeIndex(ROOT_DICT_NAME);
        this.fragmentIdx = this.graph.getOrCreateNodeIndex(FRAGMENT_DICT_NAME);
        this.derivedProxyDictionary = this.graph.getOrCreateNodeIndex(DERIVED_PROXY_DICT_NAME);
    }

    public GraphModelBatchInjector(IGraphDatabase g, TypeCache typeCache, VcsCommitItem s, IGraphChangeListener listener) throws Exception {
        this.objectCount = new int[4];
        this.hash = new HashMap<Pair<String, String>, IGraphNode>();
        this.previousMode = IGraphDatabase.Mode.UNKNOWN;
        this.successState = true;
        this.graph = g;
        this.typeCache = typeCache;
        this.commitItem = s;
        this.listener = listener;
        this.tempDirURI = new File(g.getTempDir()).toURI().toString();
        this.refreshIndexes();
    }

    public GraphModelBatchInjector(IModelIndexer hawk, Supplier<DeletionUtils> deletionUtils, TypeCache typeCache, VcsCommitItem s, IHawkModelResource r, IGraphChangeListener listener, boolean verbose) throws Exception {
        block27: {
            IGraphDatabase g;
            this.objectCount = new int[4];
            this.hash = new HashMap<Pair<String, String>, IGraphNode>();
            this.previousMode = IGraphDatabase.Mode.UNKNOWN;
            this.successState = true;
            this.graph = g = hawk.getGraph();
            this.typeCache = typeCache;
            this.commitItem = s;
            this.listener = listener;
            this.tempDirURI = new File(g.getTempDir()).toURI().toString();
            this.startTime = System.nanoTime();
            this.graph.enterBatchMode();
            try {
                listener.changeStart();
                this.refreshIndexes();
                boolean isNew = false;
                this.repoURL = s.getCommit().getDelta().getManager().getLocation();
                IGraphNode fileNode = null;
                long filerevision = 0L;
                try {
                    String idQuery = String.valueOf(this.repoURL) + "||||" + s.getPath();
                    fileNode = (IGraphNode)this.fileDictionary.get("id", (Object)idQuery).getSingle();
                    if (fileNode != null) {
                        filerevision = (Long)fileNode.getProperty("revision");
                    }
                }
                catch (Exception idQuery) {
                    // empty catch block
                }
                if (filerevision == 0L) {
                    isNew = true;
                }
                if (isNew) {
                    if (fileNode == null) {
                        fileNode = this.addFileNode(s, listener);
                    }
                    try {
                        Iterable children = r.getAllContents();
                        this.startTime = System.nanoTime();
                        if (verbose) {
                            LOGGER.debug("Adding elements of file {}", (Object)s.getPath());
                        }
                        int[] addedElements = this.parseResource(fileNode, ParseOptions.MODELELEMENTS, children, hawk, r.providesSingletonElements());
                        this.fragmentIdx.flush();
                        if (verbose) {
                            LOGGER.debug("{} NODES AND {} M->MM REFERENCES! (took ~{}sec)", new Object[]{addedElements[0], addedElements[1], addedElements[2], (System.nanoTime() - this.startTime) / 1000000000L});
                        }
                        this.startTime = System.nanoTime();
                        if (verbose) {
                            LOGGER.debug("Adding edges of file {}", (Object)s.getPath());
                        }
                        addedElements = this.parseResource(fileNode, ParseOptions.MODELREFERENCES, children, hawk, r.providesSingletonElements());
                        this.setUnset(this.getUnset() + addedElements[3]);
                        if (verbose) {
                            LOGGER.debug("{} REFERENCES! (took ~{} sec)", (Object)addedElements[0], (Object)((System.nanoTime() - this.startTime) / 1000000000L));
                        }
                        listener.changeSuccess();
                        this.successState = true;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        IGraphNode n = new Utils().getFileNodeFromVCSCommitItem(this.graph, s);
                        if (n != null) {
                            try {
                                Throwable throwable = null;
                                Object var16_21 = null;
                                try (IGraphTransaction t = g.beginTransaction();){
                                    deletionUtils.get().deleteAll(n, s, listener);
                                    t.success();
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Exception e2) {
                                LOGGER.error("error in reverting from erroneous batch insert", (Throwable)e2);
                            }
                        }
                        listener.changeFailure();
                        this.successState = false;
                    }
                    break block27;
                }
                LOGGER.warn("GraphModelBatchInjector used with a model already in Hawk.");
                listener.changeSuccess();
                this.successState = true;
            }
            catch (Exception ex) {
                this.successState = false;
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                listener.changeFailure();
            }
        }
    }

    private IGraphNode addFileNode(VcsCommitItem s, IGraphChangeListener listener) {
        HashMap<String, String> mapForFileNode = new HashMap<String, String>();
        mapForFileNode.put("_hawkid", s.getPath());
        mapForFileNode.put("revision", s.getCommit().getRevision());
        mapForFileNode.put("repository", this.repoURL);
        IGraphNode fileNode = this.graph.createNode(mapForFileNode, ROOT_DICT_FILE_KEY);
        HashMap<String, String> mapForDictionary = new HashMap<String, String>();
        mapForDictionary.put("id", String.valueOf(this.repoURL) + "||||" + s.getPath());
        this.fileDictionary.add(fileNode, mapForDictionary);
        listener.fileAddition(s, fileNode);
        return fileNode;
    }

    private int[] parseResource(IGraphNode originatingFile, ParseOptions parseOption, Iterable<IHawkObject> children, IModelIndexer hawk, boolean resourceCanProvideSingletons) throws Exception {
        this.graph.enterBatchMode();
        this.objectCount[0] = 0;
        this.objectCount[1] = 0;
        this.objectCount[2] = 0;
        this.objectCount[3] = 0;
        String fileID = "" + originatingFile.getProperty("_hawkid");
        long init = System.nanoTime();
        int lastprint = 0;
        for (IHawkObject child : children) {
            switch (parseOption) {
                case MODELELEMENTS: {
                    this.addEObject(originatingFile, child, resourceCanProvideSingletons);
                    break;
                }
                case MODELREFERENCES: {
                    this.addEReferences(child, resourceCanProvideSingletons);
                    break;
                }
                default: {
                    LOGGER.error("parse option {} not recognised!", (Object)parseOption);
                }
            }
            if (lastprint >= this.objectCount[0] - 50000) continue;
            lastprint = this.objectCount[0];
            String out = String.format("Adding %s: %d %d sec (%d sec total) to %s", parseOption == ParseOptions.MODELELEMENTS ? "nodes" : "references", this.objectCount[0], (System.nanoTime() - init) / 1000000000L, (System.nanoTime() - this.startTime) / 1000000000L, fileID);
            hawk.getCompositeStateListener().info(out);
            init = System.nanoTime();
        }
        return this.objectCount;
    }

    private String getEObjectId(IHawkObject eObject) {
        return eObject.getUriFragment();
    }

    private IGraphNode createEObjectNode(IHawkObject eObject, IGraphNode typenode) throws Exception {
        try {
            ArrayList<IHawkAttribute> normalAttributes = new ArrayList<IHawkAttribute>();
            ArrayList<IHawkAttribute> indexedAttributes = new ArrayList<IHawkAttribute>();
            IGraphNode node = this.createBasicEObjectNode(eObject, normalAttributes, indexedAttributes);
            IHawkClassifier classifier = eObject.getType();
            this.addDerivedFeatureNodes(node, typenode, classifier.getPackageNSURI(), this.typeCache.getEClassNodeSlots(this.graph, classifier));
            for (IHawkAttribute a : indexedAttributes) {
                IGraphNodeIndex i = this.graph.getOrCreateNodeIndex(String.format("%s##%s##%s", classifier.getPackageNSURI(), eObject.getType().getName(), a.getName()));
                Object rawValue = eObject.get(a);
                i.add(node, a.getName(), this.convertValue(a, rawValue));
            }
            return node;
        }
        catch (Exception e) {
            LOGGER.error("Error in inserting attributes", (Throwable)e);
            return null;
        }
    }

    private IGraphNode createBasicEObjectNode(IHawkObject eObject, List<IHawkAttribute> normalAttributes, List<IHawkAttribute> indexedAttributes) throws Exception {
        String eObjectId = this.getEObjectId(eObject);
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        nodeMap.put("_hawkid", eObjectId);
        nodeMap.put("_hawksignature", eObject.signature());
        this.classifyAttributes(eObject, normalAttributes, indexedAttributes);
        for (IHawkAttribute a1 : normalAttributes) {
            Object value1 = eObject.get(a1);
            nodeMap.put(a1.getName(), this.convertValue(a1, value1));
        }
        try {
            IGraphNode node = this.graph.createNode(nodeMap, "eobject");
            if (eObject.isFragmentUnique()) {
                this.fragmentIdx.add(node, "id", (Object)eObject.getUriFragment());
            }
            this.listener.modelElementAddition(this.commitItem, eObject, node, false);
            for (String s : nodeMap.keySet()) {
                Object value = nodeMap.get(s);
                this.listener.modelElementAttributeUpdate(this.commitItem, eObject, s, null, value, node, ModelElementNode.TRANSIENT_ATTRIBUTES.contains(s));
            }
            return node;
        }
        catch (Throwable ex) {
            LOGGER.error(ex.getMessage(), ex);
            return null;
        }
    }

    private Object convertValue(IHawkAttribute attribute, Object value) {
        if (!attribute.isMany()) {
            Class<?> valueClass = value.getClass();
            if (GraphUtil.isPrimitiveOrWrapperType(valueClass)) {
                return value;
            }
            if (value instanceof Date) {
                return this.formatDate((Date)value);
            }
            return value.toString();
        }
        AbstractCollection collection = attribute.isUnique() ? new LinkedHashSet() : new LinkedList();
        Collection srcCollection = (Collection)value;
        Class<?> elemClass = null;
        boolean primitiveOrWrapperClass = false;
        if (!srcCollection.isEmpty()) {
            Object first = srcCollection.iterator().next();
            elemClass = first.getClass();
            primitiveOrWrapperClass = GraphUtil.isPrimitiveOrWrapperType(elemClass);
            if (primitiveOrWrapperClass) {
                for (Object o : srcCollection) {
                    collection.add(o);
                }
            } else if (first instanceof Date) {
                for (Object o : srcCollection) {
                    collection.add(this.formatDate((Date)o));
                }
            } else {
                for (Object o : srcCollection) {
                    collection.add(o.toString());
                }
            }
        }
        Object r = null;
        r = primitiveOrWrapperClass && elemClass != null ? Array.newInstance(elemClass, collection.size()) : Array.newInstance(String.class, collection.size());
        Object[] ret = collection.toArray((Object[])r);
        return ret;
    }

    protected Object formatDate(Date value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return sdf.format(value);
    }

    private void classifyAttributes(IHawkObject eObject, List<IHawkAttribute> allAttributes, List<IHawkAttribute> indexedAttributes) throws Exception {
        IHawkClass iHawkClass = (IHawkClass)eObject.getType();
        for (IHawkAttribute eAttribute : iHawkClass.getAllAttributes()) {
            if (!eObject.isSet((IHawkStructuralFeature)eAttribute)) continue;
            Map<String, Slot> slots = this.typeCache.getEClassNodeSlots(this.graph, eObject.getType());
            Slot slot = slots.get(eAttribute.getName());
            if (slot == null) {
                LOGGER.error("Attribute {} is not within the properties of the node for type {}, skipping", (Object)eAttribute.getName(), (Object)iHawkClass.getName());
                continue;
            }
            allAttributes.add(eAttribute);
            if (!slot.isIndexed()) continue;
            indexedAttributes.add(eAttribute);
        }
    }

    private void addDerivedFeatureNodes(IGraphNode node, IGraphNode typenode, String metamodelURI, Map<String, Slot> slots) {
        TypeNode tn = new TypeNode(typenode);
        for (Slot slot : slots.values()) {
            if (!slot.isDerived()) continue;
            HashMap<String, Object> dfnAttributes = new HashMap<String, Object>();
            dfnAttributes.put("isMany", slot.isMany());
            dfnAttributes.put("isOrdered", slot.isOrdered());
            dfnAttributes.put("isUnique", slot.isUnique());
            dfnAttributes.put("attributetype", slot.getType());
            dfnAttributes.put("derivationlanguage", slot.getDerivationLanguage());
            dfnAttributes.put("derivationlogic", slot.getDerivationLogic());
            String idxName = String.format("%s##%s##%s", metamodelURI, tn.getTypeName(), slot.getName());
            dfnAttributes.put("indexName", idxName);
            dfnAttributes.put(slot.getName(), "_NYD##" + slot.getDerivationLogic());
            IGraphNode derivedattributenode = this.graph.createNode(dfnAttributes, "derivedattribute");
            this.graph.createRelationship(node, derivedattributenode, slot.getName(), Collections.singletonMap("isDerived", true));
            this.addToProxyAttributes(derivedattributenode);
        }
    }

    private void addToProxyAttributes(IGraphNode node) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("derived", "_");
        this.derivedProxyDictionary.add(node, m);
    }

    public IGraphNode addEObject(IGraphNode originatingFile, IHawkObject eObject, boolean resourceCanProvideSingletons) throws Exception {
        this.refreshIndexes();
        IGraphNode eClass = this.typeCache.getEClassNode(this.graph, eObject.getType());
        IGraphNode node = null;
        if (resourceCanProvideSingletons && eObject.isFragmentUnique() && (node = this.getFromFragmentIndex(eObject)) != null && originatingFile != null) {
            boolean found = false;
            for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                if (!e.getEndNode().equals((Object)originatingFile)) continue;
                found = true;
            }
            if (!found) {
                this.createReference("_hawkFile", node, originatingFile, new HashMap<String, Object>(), true);
            }
        }
        if (node == null) {
            node = this.createEObjectNode(eObject, eClass);
            if (node == null) {
                LOGGER.error("The node for {} is null", (Object)eObject);
            } else {
                this.hash.put(this.splitURI(eObject.getUri()), node);
                HashMap<String, Object> emptyMap = new HashMap<String, Object>();
                this.createReference("_hawkOfType", node, eClass, emptyMap, true);
                this.createReference("_hawkOfKind", node, eClass, emptyMap, true);
                if (originatingFile != null) {
                    this.createReference("_hawkFile", node, originatingFile, emptyMap, true);
                }
                this.objectCount[1] = this.objectCount[1] + 1;
                for (IHawkClass superType : ((IHawkClass)eObject.getType()).getAllSuperTypes()) {
                    eClass = this.typeCache.getEClassNode(this.graph, (IHawkClassifier)superType);
                    this.createReference("_hawkOfKind", node, eClass, emptyMap, true);
                    this.objectCount[2] = this.objectCount[2] + 1;
                }
                this.objectCount[0] = this.objectCount[0] + 1;
                if (eObject.isRoot()) {
                    this.rootDictionary.add(node, ROOT_DICT_FILE_KEY, (Object)originatingFile.getId().toString());
                }
            }
        }
        return node;
    }

    private Pair<String, String> splitURI(String uri) {
        String[] parts = uri.split("#", 1);
        if (parts.length == 1) {
            return new Pair<String, String>(parts[0], "");
        }
        return new Pair<String, String>(parts[0], parts[1]);
    }

    private IGraphNode getFromFragmentIndex(IHawkObject eObject) {
        IGraphNode node = null;
        Iterator itr = this.fragmentIdx.get("id", (Object)eObject.getUriFragment()).iterator();
        while (itr.hasNext()) {
            if (node == null) {
                node = (IGraphNode)itr.next();
                continue;
            }
            LOGGER.warn("isFragmentUnique returned more than one node, keeping first one.");
            break;
        }
        return node;
    }

    private void addEdge(IHawkObject from, IHawkObject to, String edgelabel, boolean isContainment, boolean isContainer) throws Exception {
        IGraphNode source = null;
        IGraphNode destination = null;
        source = this.hash.get(this.splitURI(from.getUri()));
        destination = this.hash.get(this.splitURI(to.getUri()));
        if (source == null && destination == null) {
            LOGGER.warn("hash error 1, not found from (class: {}) and to (class: {}) on reference: {}, source = {}, destination = {}", new Object[]{from.getType().getName(), to.getType().getName(), edgelabel, source, destination});
        } else if (source == null) {
            LOGGER.warn("hash error 2, not found from (class: {}) and to (class: {}) on reference: {}, source = {}, destination = {}", new Object[]{from.getType().getName(), to.getType().getName(), edgelabel, source, destination});
        } else if (destination == null) {
            this.addProxyRef(from, to, edgelabel, isContainment, isContainer);
        } else {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (isContainment) {
                props.put("isContainment", "true");
            }
            if (isContainer) {
                props.put("isContainer", "true");
            }
            this.createReference(edgelabel, source, destination, props, false);
            this.objectCount[0] = this.objectCount[0] + 1;
        }
    }

    private void createReference(String edgelabel, IGraphNode source, IGraphNode destination, Map<String, Object> props, boolean isTransient) {
        this.graph.createRelationship(source, destination, edgelabel, props);
        this.listener.referenceAddition(this.commitItem, source, destination, edgelabel, isTransient);
    }

    protected boolean addEReferences(IGraphNode fileNode, IGraphNode node, IHawkObject source, Map<String, IGraphNode> addedNodesHash, Map<String, IGraphNode> nodes) throws Exception {
        this.refreshIndexes();
        boolean ret = true;
        try {
            for (IHawkReference eReference : ((IHawkClass)source.getType()).getAllReferences()) {
                if (!source.isSet((IHawkStructuralFeature)eReference)) continue;
                String edgelabel = eReference.getName();
                Object destinationObject = source.get(eReference, false);
                if (destinationObject instanceof Iterable) {
                    for (Object destinationEObject : (Iterable)destinationObject) {
                        IHawkObject destinationHawkObject = (IHawkObject)destinationEObject;
                        if (!destinationHawkObject.isInDifferentResourceThan(source)) {
                            IGraphNode dest = null;
                            dest = addedNodesHash.get(destinationHawkObject.getUriFragment());
                            if (dest == null) {
                                dest = nodes.get(destinationHawkObject.getUriFragment());
                            }
                            HashMap<String, Object> props = new HashMap<String, Object>();
                            if (eReference.isContainment()) {
                                props.put("isContainment", "true");
                            }
                            if (eReference.isContainer()) {
                                props.put("isContainer", "true");
                            }
                            this.createReference(edgelabel, node, dest, props, false);
                            continue;
                        }
                        this.addProxyRef(node, destinationHawkObject, edgelabel, eReference.isContainment(), eReference.isContainer());
                    }
                    continue;
                }
                IHawkObject destinationHawkObject = (IHawkObject)destinationObject;
                if (!destinationHawkObject.isInDifferentResourceThan(source)) {
                    IGraphNode dest = addedNodesHash.get(destinationHawkObject.getUriFragment());
                    if (dest == null) {
                        dest = nodes.get(destinationHawkObject.getUriFragment());
                    }
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    if (eReference.isContainment()) {
                        props.put("isContainment", "true");
                    }
                    if (eReference.isContainer()) {
                        props.put("isContainer", "true");
                    }
                    this.createReference(edgelabel, node, dest, props, false);
                    continue;
                }
                this.addProxyRef(node, destinationHawkObject, edgelabel, eReference.isContainment(), eReference.isContainer());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ret = false;
        }
        return ret;
    }

    public boolean addEReferences(IHawkObject source, boolean resourceCanProvideSingletons) throws Exception {
        boolean atLeastOneSetReference = false;
        if (source.isFragmentUnique() && resourceCanProvideSingletons && this.hash.get(this.splitURI(source.getUri())) == null) {
            return atLeastOneSetReference;
        }
        for (IHawkReference eReference : ((IHawkClass)source.getType()).getAllReferences()) {
            if (source.isSet((IHawkStructuralFeature)eReference)) {
                atLeastOneSetReference = true;
                String edgelabel = eReference.getName();
                Object destinationObject = source.get(eReference, false);
                if (destinationObject instanceof Iterable) {
                    for (Object destinationEObject : (Iterable)destinationObject) {
                        IHawkObject destinationHawkObject = (IHawkObject)destinationEObject;
                        if (!destinationHawkObject.isInDifferentResourceThan(source)) {
                            this.addEdge(source, destinationHawkObject, edgelabel, eReference.isContainment(), eReference.isContainer());
                            continue;
                        }
                        this.addProxyRef(source, destinationHawkObject, edgelabel, eReference.isContainment(), eReference.isContainer());
                    }
                    continue;
                }
                IHawkObject destinationHawkObject = (IHawkObject)destinationObject;
                if (!destinationHawkObject.isInDifferentResourceThan(source)) {
                    this.addEdge(source, destinationHawkObject, edgelabel, eReference.isContainment(), eReference.isContainer());
                    continue;
                }
                this.addProxyRef(source, destinationHawkObject, edgelabel, eReference.isContainment(), eReference.isContainer());
                continue;
            }
            this.objectCount[3] = this.objectCount[3] + 1;
        }
        return atLeastOneSetReference;
    }

    private boolean addProxyRef(IHawkObject from, IHawkObject destinationObject, String edgelabel, boolean isContainment, boolean isContainer) {
        IGraphNode withProxy = this.hash.get(this.splitURI(from.getUri()));
        return this.addProxyRef(withProxy, destinationObject, edgelabel, isContainment, isContainer);
    }

    private boolean addProxyRef(IGraphNode node, IHawkObject destinationObject, String edgelabel, boolean isContainment, boolean isContainer) {
        try {
            String uri;
            String relativeObjectURI = uri = destinationObject.getUri();
            if (destinationObject.isFragmentUnique()) {
                relativeObjectURI = "*#" + relativeObjectURI.substring(relativeObjectURI.indexOf("#") + 1);
            } else if (!destinationObject.URIIsRelative()) {
                if (relativeObjectURI.startsWith(this.tempDirURI)) {
                    relativeObjectURI = relativeObjectURI.substring(this.tempDirURI.length());
                } else {
                    IVcsManager vcs = this.commitItem.getCommit().getDelta().getManager();
                    relativeObjectURI = vcs.getRepositoryPath(relativeObjectURI);
                }
            }
            String relativeObjectFileURI = relativeObjectURI.substring(0, relativeObjectURI.indexOf("#"));
            String fullObjectURI = String.valueOf(this.repoURL) + "||||" + relativeObjectURI;
            String fullObjectFileURI = String.valueOf(this.repoURL) + "||||" + relativeObjectFileURI;
            String[] proxies = node.getProperty("hawkProxyRef:" + fullObjectFileURI);
            proxies = new Utils().addToElementProxies(proxies, fullObjectURI, edgelabel, isContainment, isContainer);
            node.setProperty("hawkProxyRef:" + fullObjectFileURI, (Object)proxies);
            this.proxyDictionary.add(node, Collections.singletonMap("hawkProxyRef:", fullObjectFileURI));
        }
        catch (Exception e) {
            LOGGER.error("proxydictionary error", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean resolveProxyRef(IGraphNode source, IGraphNode target, String edgeLabel, boolean isContainment, boolean isContainer) throws Exception {
        this.refreshIndexes();
        for (IGraphEdge e : source.getOutgoingWithType(edgeLabel)) {
            if (!e.getEndNode().getId().equals(target.getId())) continue;
            return false;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (isContainment) {
            props.put("isContainment", "true");
        } else if (isContainer) {
            props.put("isContainer", "true");
        }
        this.graph.createRelationship(source, target, edgeLabel, props);
        return true;
    }

    public int getUnset() {
        return this.unset;
    }

    private void setUnset(int unset) {
        this.unset = unset;
    }

    public boolean getSuccess() {
        return this.successState;
    }

    private static enum ParseOptions {
        MODELELEMENTS,
        MODELREFERENCES;

    }
}

