/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.osgiserver;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IHawk;
import org.eclipse.hawk.core.IHawkFactory;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.core.IMetaModelIntrospector;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.IMetaModelUpdater;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.IModelUpdater;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.util.HawkConfig;
import org.eclipse.hawk.core.util.HawksConfig;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.osgiserver.SecurePreferencesCredentialsStore;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HManager {
    private static final String METAMODEL_UPDATER_CLASS_ATTRIBUTE = "metamodelupdater";
    private static final String METAMODEL_UPDATER_EXTENSION_POINT = "org.eclipse.hawk.core.MetaModelUpdaterExtensionPoint";
    public static final String BACK_END_EXTENSION_POINT = "org.eclipse.hawk.core.BackEndExtensionPoint";
    public static final String MODEL_EXTENSION_POINT = "org.eclipse.hawk.core.ModelExtensionPoint";
    public static final String MODEL_UPDATER_EXTENSION_POINT = "org.eclipse.hawk.core.ModelUpdaterExtensionPoint";
    public static final String META_MODEL_EXTENSION_POINT = "org.eclipse.hawk.core.MetaModelExtensionPoint";
    public static final String VCS_EXTENSION_POINT = "org.eclipse.hawk.core.VCSExtensionPoint";
    public static final String INDEXER_INTROSPECTION_EXTENSION_POINT = "org.eclipse.hawk.core.IndexerIntrospectionExtensionPoint";
    public static final String HAWK_FACTORY_EXTENSION_POINT = "org.eclipse.hawk.core.HawkFactoryExtensionPoint";
    public static final String QUERY_EXTENSION_POINT = "org.eclipse.hawk.core.QueryExtensionPoint";
    public static final String GRAPH_CHANGE_LISTENER_EXTENSION_POINT = "org.eclipse.hawk.core.GraphChangeListenerExtensionPoint";
    private static final Logger LOGGER = LoggerFactory.getLogger(HManager.class);
    public static final String BACKEND_CLASS_ATTRIBUTE = "store";
    public static final String MODEL_PARSER_CLASS_ATTRIBUTE = "ModelParser";
    public static final String MODEL_UPDATER_CLASS_ATTRIBUTE = "ModelUpdater";
    public static final String METAMODEL_PARSER_CLASS_ATTRIBUTE = "MetaModelParser";
    public static final String VCS_MANAGER_CLASS_ATTRIBUTE = "VCSManager";
    public static final String INDEXER_INTROSPECTOR_CLASS_ATTRIBUTE = "introspector";
    public static final String HAWKFACTORY_CLASS_ATTRIBUTE = "class";
    public static final String QUERY_LANG_CLASS_ATTRIBUTE = "query_language";
    public static final String GRAPH_CHANGE_LISTENER_CLASS_ATTRIBUTE = "class";
    private static HManager inst;
    protected Set<HModel> all = new HashSet<HModel>();
    protected boolean firstRun = true;

    protected void stateChanged(HModel m) {
    }

    protected void infoChanged(HModel m) {
    }

    public static synchronized HManager getInstance() {
        if (inst == null) {
            inst = new HManager();
        }
        return inst;
    }

    public static IEclipsePreferences getPreferences() {
        String bundleName = FrameworkUtil.getBundle(HManager.class).getSymbolicName();
        return InstanceScope.INSTANCE.getNode(bundleName);
    }

    private static <T> List<T> createExecutableExtensions(String propertyName, List<IConfigurationElement> elements) {
        ArrayList<Object> exts = new ArrayList<Object>();
        for (IConfigurationElement i : elements) {
            try {
                exts.add(i.createExecutableExtension(propertyName));
            }
            catch (CoreException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return exts;
    }

    private static Set<String> getAttributeFor(String attributeName, List<IConfigurationElement> elems) {
        HashSet<String> indexes = new HashSet<String>();
        for (IConfigurationElement i : elems) {
            indexes.add(i.getAttribute(attributeName));
        }
        return indexes;
    }

    private static List<IConfigurationElement> getConfigurationElementsFor(String extensionPointId) {
        ArrayList<IConfigurationElement> els = new ArrayList<IConfigurationElement>();
        if (Platform.isRunning()) {
            IConfigurationElement[] e = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
            els.addAll(Arrays.asList(e));
        }
        return els;
    }

    private static <T> Map<String, T> getInstanceMapFromConfiguration(String extensionPoint, String attribute) {
        HashMap<String, Object> ids = new HashMap<String, Object>();
        for (IConfigurationElement elem : HManager.getConfigurationElementsFor(extensionPoint)) {
            try {
                ids.put(elem.getAttribute(attribute), elem.createExecutableExtension(attribute));
            }
            catch (CoreException | InvalidRegistryObjectException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        return ids;
    }

    protected HManager() {
    }

    public boolean addHawk(HModel e) {
        if (e != null) {
            this.all.add(e);
            return true;
        }
        return false;
    }

    public IGraphDatabase createGraph(IHawk hawk) throws Exception {
        for (IConfigurationElement i : this.getBackends()) {
            if (!i.getAttribute(BACKEND_CLASS_ATTRIBUTE).equals(hawk.getDatabaseType())) continue;
            return (IGraphDatabase)i.createExecutableExtension(BACKEND_CLASS_ATTRIBUTE);
        }
        throw new Exception("cannot instantiate this type of graph: " + hawk.getDatabaseType());
    }

    public void delete(HModel o, boolean exists) throws BackingStoreException {
        if (this.all.contains(o)) {
            if (exists) {
                o.delete();
            } else {
                o.removeHawkFromMetadata(o.getHawkConfig());
            }
            this.all.remove(o);
        } else {
            o.removeHawkFromMetadata(o.getHawkConfig());
        }
    }

    public Object[] getElements(Object parent) {
        return this.getHawks().toArray();
    }

    public synchronized Set<HModel> getHawks() {
        if (this.firstRun) {
            this.firstRun = false;
            this.loadHawksFromMetadata();
        }
        return this.all;
    }

    public HModel getHawkByName(String name) {
        for (HModel m : this.getHawks()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public Collection<String> getIndexerNames() {
        ArrayList<String> name = new ArrayList<String>();
        for (HModel hm : this.all) {
            if (!hm.isRunning()) continue;
            name.add(hm.getName());
        }
        return name;
    }

    public Collection<String> getLocalIndexerNames() {
        ArrayList<String> name = new ArrayList<String>();
        for (HModel hm : this.all) {
            if (!hm.isLocal() || !hm.isRunning()) continue;
            name.add(hm.getName());
        }
        return name;
    }

    public IGraphDatabase createBackendGraph(IHawk hawk) throws Exception {
        for (IConfigurationElement i : this.getBackends()) {
            if (!i.getAttribute(BACKEND_CLASS_ATTRIBUTE).equals(hawk.getDatabaseType())) continue;
            return (IGraphDatabase)i.createExecutableExtension(BACKEND_CLASS_ATTRIBUTE);
        }
        throw new Exception("cannot instantiate this type of graph: " + hawk.getDatabaseType());
    }

    public List<IConfigurationElement> getBackends() {
        return HManager.getConfigurationElementsFor(BACK_END_EXTENSION_POINT);
    }

    public IGraphDatabase getGraphByIndexerName(String indexerName) {
        for (HModel hm : this.all) {
            if (!hm.getName().equals(indexerName)) continue;
            return hm.getGraph();
        }
        return null;
    }

    public Set<String> getIndexTypes() {
        return HManager.getAttributeFor(BACKEND_CLASS_ATTRIBUTE, this.getBackends());
    }

    public Map<String, IGraphDatabase> getBackendInstances() {
        return HManager.getInstanceMapFromConfiguration(BACK_END_EXTENSION_POINT, BACKEND_CLASS_ATTRIBUTE);
    }

    public List<IConfigurationElement> getLanguages() {
        return HManager.getConfigurationElementsFor(QUERY_EXTENSION_POINT);
    }

    public Set<String> getLanguageTypes() {
        return HManager.getAttributeFor(QUERY_LANG_CLASS_ATTRIBUTE, this.getLanguages());
    }

    public Map<String, IQueryEngine> getQueryLanguageInstances() {
        return HManager.getInstanceMapFromConfiguration(QUERY_EXTENSION_POINT, QUERY_LANG_CLASS_ATTRIBUTE);
    }

    public Set<String> getMetaModelTypes() {
        return HManager.getAttributeFor(METAMODEL_PARSER_CLASS_ATTRIBUTE, this.getMmps());
    }

    public List<IConfigurationElement> getMmps() {
        return HManager.getConfigurationElementsFor(META_MODEL_EXTENSION_POINT);
    }

    public Map<String, IMetaModelResourceFactory> getMetamodelParserInstances() {
        return HManager.getInstanceMapFromConfiguration(META_MODEL_EXTENSION_POINT, METAMODEL_PARSER_CLASS_ATTRIBUTE);
    }

    public IMetaModelUpdater getMetaModelUpdater() throws CoreException {
        IConfigurationElement[] e = Platform.getExtensionRegistry().getConfigurationElementsFor(METAMODEL_UPDATER_EXTENSION_POINT);
        IConfigurationElement i = null;
        IConfigurationElement[] iConfigurationElementArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ii = iConfigurationElementArray[n2];
            if (i == null) {
                i = ii;
            } else {
                HModel.getConsole().printerrln("more than one metamodel updater found, only one allowed");
            }
            ++n2;
        }
        if (i != null) {
            return (IMetaModelUpdater)i.createExecutableExtension(METAMODEL_UPDATER_CLASS_ATTRIBUTE);
        }
        return null;
    }

    public Map<String, IMetaModelUpdater> getMetamodelUpdaterInstances() {
        return HManager.getInstanceMapFromConfiguration(METAMODEL_UPDATER_EXTENSION_POINT, METAMODEL_UPDATER_CLASS_ATTRIBUTE);
    }

    public Set<String> getModelTypes() {
        return HManager.getAttributeFor(MODEL_PARSER_CLASS_ATTRIBUTE, this.getMps());
    }

    public List<IConfigurationElement> getMps() {
        return HManager.getConfigurationElementsFor(MODEL_EXTENSION_POINT);
    }

    public Map<String, IModelResourceFactory> getModelParserInstances() {
        return HManager.getInstanceMapFromConfiguration(MODEL_EXTENSION_POINT, MODEL_PARSER_CLASS_ATTRIBUTE);
    }

    public Set<String> getUpdaterTypes() {
        return HManager.getAttributeFor(MODEL_UPDATER_CLASS_ATTRIBUTE, this.getUps());
    }

    public List<IConfigurationElement> getUps() {
        return HManager.getConfigurationElementsFor(MODEL_UPDATER_EXTENSION_POINT);
    }

    public Map<String, IModelUpdater> getModelUpdaterInstances() {
        return HManager.getInstanceMapFromConfiguration(MODEL_UPDATER_EXTENSION_POINT, MODEL_UPDATER_CLASS_ATTRIBUTE);
    }

    public List<IConfigurationElement> getVCS() {
        return HManager.getConfigurationElementsFor(VCS_EXTENSION_POINT);
    }

    public Set<String> getVCSTypes() {
        return HManager.getAttributeFor(VCS_MANAGER_CLASS_ATTRIBUTE, this.getVCS());
    }

    public List<IHawkPlugin> getAvailablePlugins() {
        ArrayList<IHawkPlugin> all = new ArrayList<IHawkPlugin>();
        List backends = HManager.createExecutableExtensions(BACKEND_CLASS_ATTRIBUTE, this.getBackends());
        all.addAll(backends);
        List gcl = HManager.createExecutableExtensions("class", this.getGraphChangeListeners());
        all.addAll(gcl);
        List factories = HManager.createExecutableExtensions("class", this.getHawkFactories());
        all.addAll(factories);
        List mmParsers = HManager.createExecutableExtensions(METAMODEL_PARSER_CLASS_ATTRIBUTE, this.getMmps());
        all.addAll(mmParsers);
        List mParsers = HManager.createExecutableExtensions(MODEL_PARSER_CLASS_ATTRIBUTE, this.getMps());
        all.addAll(mParsers);
        List mUpdaters = HManager.createExecutableExtensions(MODEL_UPDATER_CLASS_ATTRIBUTE, this.getUps());
        all.addAll(mUpdaters);
        List queryEngines = HManager.createExecutableExtensions(QUERY_LANG_CLASS_ATTRIBUTE, this.getLanguages());
        all.addAll(queryEngines);
        all.addAll(this.getVCSInstances());
        return all;
    }

    public List<IVcsManager> getVCSInstances() {
        return HManager.createExecutableExtensions(VCS_MANAGER_CLASS_ATTRIBUTE, this.getVCS());
    }

    public Map<String, IVcsManager> getVcsManagerInstances() {
        return HManager.getInstanceMapFromConfiguration(VCS_EXTENSION_POINT, VCS_MANAGER_CLASS_ATTRIBUTE);
    }

    public IVcsManager createVCSManager(String s) throws CoreException {
        for (IConfigurationElement i : this.getVCS()) {
            if (!i.getAttribute(VCS_MANAGER_CLASS_ATTRIBUTE).equals(s)) continue;
            return (IVcsManager)i.createExecutableExtension(VCS_MANAGER_CLASS_ATTRIBUTE);
        }
        throw new NoSuchElementException("cannot instantiate this type of manager: " + s);
    }

    public List<IConfigurationElement> getGraphChangeListeners() {
        return HManager.getConfigurationElementsFor(GRAPH_CHANGE_LISTENER_EXTENSION_POINT);
    }

    public Set<String> getGraphChangeListenerTypes() {
        return HManager.getAttributeFor("class", this.getGraphChangeListeners());
    }

    public Map<String, IGraphChangeListener> getGraphChangeListenerInstances() {
        return HManager.getInstanceMapFromConfiguration(GRAPH_CHANGE_LISTENER_EXTENSION_POINT, "class");
    }

    public List<IConfigurationElement> getHawkFactories() {
        return HManager.getConfigurationElementsFor(HAWK_FACTORY_EXTENSION_POINT);
    }

    public Map<String, IHawkFactory> getHawkFactoryInstances() {
        return HManager.getInstanceMapFromConfiguration(HAWK_FACTORY_EXTENSION_POINT, "class");
    }

    public IHawkFactory createHawkFactory(String factoryClass) throws CoreException {
        for (IConfigurationElement elem : this.getHawkFactories()) {
            if (!factoryClass.equals(elem.getAttribute("class"))) continue;
            return (IHawkFactory)elem.createExecutableExtension("class");
        }
        return null;
    }

    public List<IConfigurationElement> getIntrospectors() {
        return HManager.getConfigurationElementsFor(INDEXER_INTROSPECTION_EXTENSION_POINT);
    }

    public Map<String, IMetaModelIntrospector> getIntrospectorInstances() {
        return HManager.getInstanceMapFromConfiguration(INDEXER_INTROSPECTION_EXTENSION_POINT, INDEXER_INTROSPECTOR_CLASS_ATTRIBUTE);
    }

    public IMetaModelIntrospector getIntrospectorFor(IModelIndexer idx) {
        for (IConfigurationElement conf : this.getIntrospectors()) {
            try {
                IMetaModelIntrospector.Factory impl = (IMetaModelIntrospector.Factory)conf.createExecutableExtension(INDEXER_INTROSPECTOR_CLASS_ATTRIBUTE);
                if (!impl.canIntrospect(idx)) continue;
                return impl.createFor(idx);
            }
            catch (CoreException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public synchronized boolean stopAllRunningInstances(IModelIndexer.ShutdownRequestType reqType) {
        HModel.getConsole().println("Shutting down hawk:");
        for (HModel hm : this.all) {
            if (!hm.isRunning()) continue;
            HModel.getConsole().println(String.format("Stopping %s (%s)", hm.getName(), hm.getFolder()));
            hm.stop(reqType);
        }
        return true;
    }

    protected synchronized void loadHawksFromMetadata() {
        IEclipsePreferences preferences = HManager.getPreferences();
        String xml = preferences.get("config", null);
        boolean success = true;
        if (xml != null) {
            try {
                XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
                stream.processAnnotations(HawksConfig.class);
                stream.processAnnotations(HawkConfig.class);
                stream.setClassLoader(HawksConfig.class.getClassLoader());
                HawksConfig hc = (HawksConfig)stream.fromXML(xml);
                HashSet<HawkConfig> hawks = new HashSet<HawkConfig>();
                for (HawkConfig s : hc.getConfigs()) {
                    if (!new File(s.getStorageFolder()).exists()) continue;
                    hawks.add(s);
                }
                for (HawkConfig s : hawks) {
                    boolean bl = success = success && this.addHawk(HModel.load(s, this));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load configuration: started with " + xml.substring(0, Math.min(xml.length() - 1, 20)), (Throwable)e);
                success = false;
            }
        }
        if (!success) {
            preferences.remove("config");
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                LOGGER.error("Failed to flush preferences", (Throwable)e);
            }
        }
    }

    public ICredentialsStore getCredentialsStore() {
        return new SecurePreferencesCredentialsStore();
    }

    public void saveHawkToMetadata(HModel e) throws BackingStoreException {
        this.saveHawkToMetadata(e, false);
    }

    public synchronized void saveHawkToMetadata(HModel e, boolean replace) throws BackingStoreException {
        IEclipsePreferences preferences = HManager.getPreferences();
        String oldXML = preferences.get("config", null);
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        stream.processAnnotations(HawksConfig.class);
        stream.processAnnotations(HawkConfig.class);
        stream.setClassLoader(HawksConfig.class.getClassLoader());
        HawksConfig hc = null;
        try {
            if (oldXML != null) {
                hc = (HawksConfig)stream.fromXML(oldXML);
            }
            HashSet<HawkConfig> locs = new HashSet<HawkConfig>();
            if (hc != null) {
                locs.addAll(hc.getConfigs());
            }
            if (replace && locs.contains(e.getHawkConfig())) {
                locs.remove(e.getHawkConfig());
            }
            locs.add(e.getHawkConfig());
            String xml = stream.toXML((Object)new HawksConfig(locs));
            preferences.put("config", xml);
        }
        catch (Exception ex) {
            preferences.put("config", oldXML);
        }
        preferences.flush();
    }
}

