/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.graph;

import java.util.Collections;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;

public class VCSManagerIndex {
    private static final String URI_PROPERTY = "uri";
    private final ITimeAwareGraphNodeIndex idx;
    private final ITimeAwareGraphDatabase db;

    public VCSManagerIndex(ITimeAwareGraphDatabase db) {
        this.db = db;
        this.idx = db.getOrCreateNodeIndex("_hawkVCSIndex");
    }

    public RepositoryNode getOrCreateRepositoryNode(String repoURI) {
        IGraphIterable iNode = this.idx.get(URI_PROPERTY, (Object)repoURI);
        if (iNode.size() > 0) {
            return new RepositoryNode((ITimeAwareGraphNode)iNode.getSingle());
        }
        ITimeAwareGraphNode node = this.db.createNode(Collections.singletonMap(URI_PROPERTY, repoURI), "_hawkRepo");
        this.idx.add((IGraphNode)node, URI_PROPERTY, (Object)repoURI);
        return new RepositoryNode(node);
    }

    public void removeRepositoryNode(String repoURI) {
        IGraphIterable iNode = this.idx.get(URI_PROPERTY, (Object)repoURI);
        if (iNode.size() > 0) {
            IGraphNode node = (IGraphNode)iNode.getSingle();
            this.idx.remove(node);
            node.delete();
        }
    }

    public class RepositoryNode {
        private static final String LASTREV_PROPERTY = "lastRevision";
        private static final String MESSAGE_PROPERTY = "message";
        private final ITimeAwareGraphNode node;

        public RepositoryNode(ITimeAwareGraphNode n) {
            this.node = n;
        }

        public String getURI() {
            return "" + this.node.getProperty(VCSManagerIndex.URI_PROPERTY);
        }

        public String getRevision() {
            Object lastRev = this.node.getProperty(LASTREV_PROPERTY);
            if (lastRev == null) {
                return null;
            }
            return lastRev.toString();
        }

        public void setRevision(String lastRev) {
            this.node.setProperty(LASTREV_PROPERTY, (Object)lastRev);
        }

        public RepositoryNode getLatest() throws Exception {
            return new RepositoryNode(this.node.getLatest());
        }

        public RepositoryNode travelInTime(long instant) throws Exception {
            return new RepositoryNode(this.node.travelInTime(instant));
        }

        public String getMessage() {
            Object message = this.node.getProperty(MESSAGE_PROPERTY);
            return message == null ? null : message.toString();
        }

        public void setMessage(String message) {
            this.node.setProperty(MESSAGE_PROPERTY, (Object)message);
        }

        public Object getId() {
            return this.node.getId();
        }
    }
}

