/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.generatedelementlistener;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.mylyn.docs.intent.client.synchronizer.listeners.AbstractGeneratedElementListener;
import org.eclipse.mylyn.docs.intent.client.ui.ide.generatedelementlistener.IDEGeneratedElementListenerDeltaVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEGeneratedElementListener
extends AbstractGeneratedElementListener
implements IResourceChangeListener {
    private Collection<URI> resourcesToIgnore;

    public IDEGeneratedElementListener() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
        this.resourcesToIgnore = new ArrayList<URI>();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta rootDelta;
        if (event.getType() == 1 && (rootDelta = event.getDelta()) != null) {
            this.analyseWorkspaceDelta(rootDelta);
        }
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected IDEGeneratedElementListenerDeltaVisitor createDeltaVisitor() {
        return new IDEGeneratedElementListenerDeltaVisitor(this.listenedElementsURIs);
    }

    protected void treatChangedResources(Collection<URI> changedResources) {
        if (!changedResources.isEmpty()) {
            this.synchronizer.handleChangeNotification(null);
        }
    }

    private void analyseWorkspaceDelta(IResourceDelta repositoryDelta) {
        IDEGeneratedElementListenerDeltaVisitor visitor = this.createDeltaVisitor();
        try {
            repositoryDelta.accept((IResourceDeltaVisitor)visitor);
            ArrayList<URI> changedResources = new ArrayList<URI>();
            if (!visitor.getRemovedResources().isEmpty()) {
                changedResources.addAll(visitor.getRemovedResources());
            }
            for (URI changedResource : visitor.getChangedResources()) {
                if (!this.resourcesToIgnore.contains(changedResource)) {
                    changedResources.add(changedResource);
                    continue;
                }
                this.resourcesToIgnore.remove(changedResource);
            }
            this.treatChangedResources(changedResources);
        }
        catch (CoreException coreException) {}
    }
}

