/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.launcher;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.common.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexerFactory;
import org.eclipse.mylyn.docs.intent.parser.IntentParser;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;

public final class IDEApplicationManager {
    private IDEApplicationManager() {
    }

    public static void initializeContent(IProject project, String initialContent) {
        try {
            if (project.isAccessible()) {
                Repository repository = IntentRepositoryManager.INSTANCE.getRepository(project.getName());
                repository.getOrCreateSession();
                if (project.exists() && !project.isOpen()) {
                    project.open(null);
                }
                IDEApplicationManager.initializeWithSampleContent(repository, initialContent);
            }
        }
        catch (CoreException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        catch (RepositoryConnectionException e) {
            IntentUiLogger.logError((Throwable)e);
        }
    }

    private static void initializeWithSampleContent(Repository repositoryToInitialize, final String initialContent) throws RepositoryConnectionException {
        final RepositoryAdapter repositoryAdapter = repositoryToInitialize.createRepositoryAdapter();
        repositoryAdapter.execute(new IntentCommand(){

            public void execute() {
                repositoryAdapter.openSaveContext();
                try {
                    IDEApplicationManager.initializeInRepository(initialContent, repositoryAdapter);
                }
                catch (ReadOnlyException e) {
                    IntentUiLogger.logError((Throwable)e);
                }
                catch (ParseException e) {
                    IntentUiLogger.logError((Throwable)e);
                }
                catch (SaveException e) {
                    IntentUiLogger.logError((Throwable)e);
                }
                repositoryAdapter.closeContext();
            }
        });
    }

    private static void initializeInRepository(String initialContent, RepositoryAdapter repositoryAdapter) throws ReadOnlyException, ParseException, SaveException {
        Resource wpResourceIndex = repositoryAdapter.getOrCreateResource("/IntentIndex");
        wpResourceIndex.getContents().add((Object)IntentIndexerFactory.eINSTANCE.createIntentIndex());
        Resource wpCompilStatusIndex = repositoryAdapter.getOrCreateResource("/COMPILATION/STATUS/StatusIndex");
        wpCompilStatusIndex.getContents().add((Object)CompilerFactory.eINSTANCE.createCompilationStatusManager());
        Resource wpTracabilityIndexResource = repositoryAdapter.getOrCreateResource("/COMPILATION/TRACES/TraceabilityIndex");
        wpTracabilityIndexResource.getContents().add((Object)CompilerFactory.eINSTANCE.createTraceabilityIndex());
        Resource repositoryIntentResource = repositoryAdapter.getOrCreateResource("/INTENT/IntentDocument");
        if (repositoryIntentResource.getContents().size() == 0) {
            repositoryIntentResource.getContents().clear();
            ArrayList<EObject> elementsToUpload = new ArrayList<EObject>();
            EObject parsedObject = new IntentParser().parse(initialContent);
            elementsToUpload.add(parsedObject);
            for (EObject objectToCopy : elementsToUpload) {
                repositoryIntentResource.getContents().add((Object)EcoreUtil.copy((EObject)objectToCopy));
            }
            repositoryAdapter.save();
        } else {
            repositoryAdapter.undo();
        }
    }
}

