/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInputFactory;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.common.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.query.DescriptionUnitHelper;
import org.eclipse.mylyn.docs.intent.core.query.StructuredElementHelper;
import org.eclipse.ui.IMemento;
import org.osgi.framework.Bundle;

public class IntentEditorInput
extends URIEditorInput {
    private static final int MAX_TITLE_SIZE = 25;
    private static final String URI_FRAGMENT_TAG = "uri_fragment";
    private EObject element;
    private String elementTitle;
    private RepositoryAdapter repositoryAdapter;

    public IntentEditorInput(EObject elementToOpen, RepositoryAdapter repositoryAdapter) {
        super(elementToOpen.eResource().getURI());
        this.element = elementToOpen;
        this.elementTitle = this.getTitleFromElement(elementToOpen);
        this.repositoryAdapter = repositoryAdapter;
    }

    public IntentEditorInput(IMemento memento) {
        super(memento);
    }

    public EObject getIntentElement() {
        return this.element;
    }

    public String getTitleFromElement(EObject newElement) {
        String newTitle = "";
        if (newElement instanceof ModelingUnit && ((newTitle = ((ModelingUnit)newElement).getUnitName()) == null || newTitle.length() < 1)) {
            newTitle = "Untitled ModelingUnit";
        }
        if (newElement instanceof DescriptionUnit) {
            newTitle = DescriptionUnitHelper.getDescriptionUnitTitle((DescriptionUnit)((DescriptionUnit)newElement), (int)25);
        }
        if (newElement instanceof IntentStructuredElement && ((newTitle = StructuredElementHelper.getTitle((IntentStructuredElement)((IntentStructuredElement)newElement))) == null || newTitle.length() < 1)) {
            newTitle = newElement.eClass().getName();
        }
        if (newTitle.length() > 25) {
            newTitle = newTitle.substring(0, 25);
        }
        return newTitle;
    }

    public String getName() {
        return this.elementTitle;
    }

    public String getToolTipText() {
        return this.elementTitle;
    }

    public void setName(String newName) {
        this.elementTitle = newName;
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        Resource resource = this.getResource();
        this.element = resource.getEObject(memento.getString(URI_FRAGMENT_TAG));
        this.elementTitle = this.getTitleFromElement(this.element);
    }

    private Resource getResource() {
        if (this.repositoryAdapter == null) {
            this.repositoryAdapter = this.getRepository().createRepositoryAdapter();
            this.repositoryAdapter.openSaveContext();
        }
        return this.repositoryAdapter.getResource(IntentEditorInput.getPath(this.getURI()));
    }

    public Repository getRepository() {
        try {
            return IntentRepositoryManager.INSTANCE.getRepository(IntentEditorInput.getProjectName(this.getURI()));
        }
        catch (RepositoryConnectionException e) {
            IntentUiLogger.logError(e);
        }
        catch (CoreException e) {
            IntentUiLogger.logError(e);
        }
        return null;
    }

    public RepositoryAdapter getRepositoryAdapter() {
        return this.repositoryAdapter;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(URI_FRAGMENT_TAG, this.element.eResource().getURIFragment(this.element));
        memento.putString("class", ((Object)((Object)this)).getClass().getName());
    }

    private static String getProjectName(URI uri) {
        String projectName = null;
        if (uri.isPlatformResource()) {
            projectName = uri.toString().replaceFirst("platform:/resource/", "");
            projectName = projectName.split("/")[0];
        }
        return projectName;
    }

    private static String getPath(URI uri) {
        String path = null;
        if (uri.isPlatformResource()) {
            path = uri.trimFileExtension().toString().replaceFirst("platform:/resource/", "");
            path = path.substring(path.indexOf("INTENT") - 1);
        }
        return path;
    }

    protected String getBundleSymbolicName() {
        return IntentEditorActivator.getDefault().getBundle().getSymbolicName();
    }

    public String getFactoryId() {
        return IntentEditorInputFactory.ID;
    }

    static IntentEditorInput create(IMemento memento) {
        String bundleSymbolicName = memento.getString("bundle");
        String className = memento.getString("class");
        try {
            Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
            Class theClass = bundle.loadClass(className);
            Constructor constructor = theClass.getConstructor(IMemento.class);
            return (IntentEditorInput)((Object)constructor.newInstance(memento));
        }
        catch (Exception exception) {
            CommonUIPlugin.INSTANCE.log((Object)exception);
            return new IntentEditorInput(memento);
        }
    }
}

