/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.document;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IntentSectionVisibility implements Enumerator
{
    PUBLIC(0, "PUBLIC", "PUBLIC"),
    HIDDEN(1, "HIDDEN", "HIDDEN"),
    INTERNAL(2, "INTERNAL", "INTERNAL");

    public static final int PUBLIC_VALUE = 0;
    public static final int HIDDEN_VALUE = 1;
    public static final int INTERNAL_VALUE = 2;
    private static final IntentSectionVisibility[] VALUES_ARRAY;
    public static final List<IntentSectionVisibility> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IntentSectionVisibility[]{PUBLIC, HIDDEN, INTERNAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IntentSectionVisibility get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntentSectionVisibility result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntentSectionVisibility getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntentSectionVisibility result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntentSectionVisibility get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC;
            }
            case 1: {
                return HIDDEN;
            }
            case 2: {
                return INTERNAL;
            }
        }
        return null;
    }

    private IntentSectionVisibility(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

