/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.markup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ListType implements Enumerator
{
    BULLETED(1, "BULLETED", "BULLETED"),
    NUMERIC(2, "NUMERIC", "NUMERIC"),
    TABLE_OF_CONTENT(3, "TABLE_OF_CONTENT", "TABLE_OF_CONTENT");

    public static final int BULLETED_VALUE = 1;
    public static final int NUMERIC_VALUE = 2;
    public static final int TABLE_OF_CONTENT_VALUE = 3;
    private static final ListType[] VALUES_ARRAY;
    public static final List<ListType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ListType[]{BULLETED, NUMERIC, TABLE_OF_CONTENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ListType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ListType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ListType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ListType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ListType get(int value) {
        switch (value) {
            case 1: {
                return BULLETED;
            }
            case 2: {
                return NUMERIC;
            }
            case 3: {
                return TABLE_OF_CONTENT;
            }
        }
        return null;
    }

    private ListType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

