/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.markup.markup.BlockContent;
import org.eclipse.mylyn.docs.intent.markup.markup.Image;
import org.eclipse.mylyn.docs.intent.markup.markup.Paragraph;
import org.eclipse.mylyn.docs.intent.markup.markup.TableCell;
import org.eclipse.mylyn.docs.intent.markup.serializer.AttributeStyleSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.SectionSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.WikiTextElementDispatcher;

public final class BlockSerializer {
    public static final String PARAGRAPH_PREFIX = "p.";
    public static final String DOT = ".";
    public static final String PREFORMATTED_EXTENDED_PREFIX = "pre..";
    public static final String CODE_PREFIX = "bc.";
    public static final String CODE_EXTENDED_PREFIX = "bc..";
    public static final String QUOTE_EXTENDED_PREFIX = "bq..";
    private static Boolean lastBlocWasPreformatted = false;

    private BlockSerializer() {
    }

    public static String render(Block wikiElement, WikiTextElementDispatcher dispatcher) {
        String prefix = "";
        if (!(wikiElement instanceof TableCell) && AttributeStyleSerializer.renderAttributeForBloc(wikiElement.getAttributes()).length() > 0) {
            prefix = "\np. \n";
            return String.valueOf(BlockSerializer.renderWithBlocPrefix(wikiElement, dispatcher, prefix)) + "\n";
        }
        if (BlockSerializer.lastElementWasParagraph(wikiElement)) {
            prefix = "\n";
        }
        return BlockSerializer.renderWithBlocPrefix(wikiElement, dispatcher, prefix);
    }

    private static boolean lastElementWasParagraph(Block block) {
        EObject previous;
        int indiceBlock;
        ArrayList containerContent = new ArrayList(block.eContainer().eContents());
        ListIterator possibleNeighbours = containerContent.listIterator(indiceBlock = containerContent.indexOf(block));
        if (possibleNeighbours.hasPrevious() && (previous = (EObject)possibleNeighbours.previous()) instanceof Paragraph) {
            EList<BlockContent> contents = ((Block)previous).getContent();
            return !(contents.get(contents.size() - 1) instanceof Image);
        }
        return false;
    }

    public static String renderWithBlocPrefix(Block wikiElement, WikiTextElementDispatcher dispatcher, String blockPrefix) {
        String renderedContent = BlockSerializer.renderPrefixAndStyle(wikiElement, blockPrefix);
        if (BlockSerializer.prefixMatchesWithPreformattedBloc(blockPrefix)) {
            renderedContent = "\n" + renderedContent;
            lastBlocWasPreformatted = true;
        } else {
            lastBlocWasPreformatted = false;
            if (BlockSerializer.prefixMatchesWithQuote(blockPrefix)) {
                renderedContent = "\n" + renderedContent;
            }
        }
        String lastContent = "";
        for (BlockContent blocContent : wikiElement.getContent()) {
            renderedContent = String.valueOf(renderedContent) + lastContent;
            lastContent = (String)dispatcher.doSwitch((EObject)blocContent);
        }
        if (!lastContent.equals("\n")) {
            renderedContent = String.valueOf(renderedContent) + lastContent;
        }
        return renderedContent;
    }

    private static String renderPrefixAndStyle(Block block, String blockPrefix) {
        String renderedPrefixAndStyle = "";
        if (blockPrefix.length() > 0) {
            String blockPrefixEnd = "";
            if (blockPrefix.contains(DOT)) {
                blockPrefixEnd = blockPrefix.substring(blockPrefix.indexOf(DOT), blockPrefix.length());
                renderedPrefixAndStyle = blockPrefix.substring(0, blockPrefix.indexOf(DOT));
            } else {
                renderedPrefixAndStyle = blockPrefix;
            }
            renderedPrefixAndStyle = String.valueOf(renderedPrefixAndStyle) + AttributeStyleSerializer.renderAttributeForBloc(block.getAttributes());
            renderedPrefixAndStyle = String.valueOf(renderedPrefixAndStyle) + blockPrefixEnd;
        }
        return renderedPrefixAndStyle;
    }

    private static boolean prefixMatchesWithPreformattedBloc(String prefix) {
        boolean matchesPreformated = prefix.contains(PREFORMATTED_EXTENDED_PREFIX);
        matchesPreformated = matchesPreformated || prefix.contains(CODE_EXTENDED_PREFIX);
        return matchesPreformated;
    }

    private static boolean prefixMatchesWithQuote(String prefix) {
        boolean matchesPreformated = prefix.contains(QUOTE_EXTENDED_PREFIX);
        return matchesPreformated;
    }

    public static Boolean usePrefix() {
        return lastBlocWasPreformatted;
    }

    public static void breakPreformatted() {
        lastBlocWasPreformatted = false;
    }

    static boolean isFirstElementofBlock(BlockContent element) {
        EObject container = element.eContainer();
        if (container instanceof Block) {
            return ((Block)container).getContent().indexOf((Object)element) == 0;
        }
        return false;
    }

    static boolean isLastElementOfBlockAndSection(BlockContent element) {
        EObject container = element.eContainer();
        EList<BlockContent> listOfContents = null;
        if (container instanceof Block) {
            boolean lastOfBlock;
            listOfContents = ((Block)container).getContent();
            boolean bl = lastOfBlock = listOfContents.lastIndexOf((Object)element) == listOfContents.size() - 1;
            if (lastOfBlock) {
                return SectionSerializer.isLastElementOfSection((Block)container);
            }
        }
        return false;
    }
}

