/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInput;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.query.IntentHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class IntentEditorOpener {
    private IntentEditorOpener() {
    }

    public static void openIntentEditor(Repository repository, boolean readOnlyMode) {
        try {
            RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
            Resource resource = repositoryAdapter.getOrCreateResource("/INTENT/IntentDocument");
            if (!resource.getContents().isEmpty() && resource.getContents().iterator().next() instanceof IntentDocument) {
                EObject elementToOpen = (EObject)resource.getContents().iterator().next();
                IntentEditorOpener.openIntentEditor(repositoryAdapter, elementToOpen, false, elementToOpen, false);
            }
        }
        catch (PartInitException e) {
            IntentUiLogger.logError(e);
        }
        catch (ReadOnlyException e) {
            IntentUiLogger.logError(e);
        }
    }

    public static void openIntentEditor(Repository repository, EObject elementToOpen, boolean readOnlyMode, EObject elementToSelectRangeWith, boolean forceNewEditor) {
        try {
            RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
            IntentEditorOpener.openIntentEditor(repositoryAdapter, elementToOpen, false, elementToSelectRangeWith, forceNewEditor);
        }
        catch (PartInitException e) {
            IntentUiLogger.logError(e);
        }
    }

    private static IntentEditor openIntentEditor(RepositoryAdapter repositoryAdapter, EObject elementToOpen, boolean readOnlyMode, EObject elementToSelectRangeWith, boolean forceNewEditor) throws PartInitException {
        IntentEditor editor;
        IntentEditor openedEditor = null;
        Status status = null;
        if (readOnlyMode) {
            repositoryAdapter.openReadOnlyContext();
        } else {
            repositoryAdapter.openSaveContext();
        }
        boolean foundInAlreadyExistingEditor = false;
        if (!forceNewEditor && (editor = IntentEditorOpener.getAlreadyOpenedEditor(elementToOpen)) != null) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
            openedEditor = editor;
            foundInAlreadyExistingEditor = editor.selectRange((IntentGenericElement)elementToOpen);
        }
        if (openedEditor == null || !foundInAlreadyExistingEditor) {
            IWorkbenchPage page = null;
            try {
                page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                openedEditor = IntentEditorOpener.openEditor(repositoryAdapter, page, elementToOpen);
                EObject container = elementToSelectRangeWith;
                while (container != null && !(container instanceof IntentGenericElement)) {
                    container = container.eContainer();
                }
                if (container instanceof IntentGenericElement) {
                    openedEditor.selectRange((IntentGenericElement)container);
                } else if (elementToOpen instanceof IntentGenericElement) {
                    openedEditor.selectRange((IntentGenericElement)elementToOpen);
                }
            }
            catch (NullPointerException nullPointerException) {
                status = new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", "An unexpected error has occured");
                throw new PartInitException((IStatus)status);
            }
        }
        return openedEditor;
    }

    public static IntentEditor getAlreadyOpenedEditor(EObject elementToOpen) {
        IntentEditor alreadyOpenedEditor = null;
        IWorkbenchPage activePage = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activePage = activeWorkbenchWindow.getActivePage();
        }
        if (activePage != null) {
            IEditorReference[] editorReferences = activePage.getEditorReferences();
            int editorCount = 0;
            while (editorCount < editorReferences.length && alreadyOpenedEditor == null) {
                IEditorReference editorReference = editorReferences[editorCount];
                IEditorPart editor = editorReference.getEditor(false);
                if (editor instanceof IntentEditor && ((IntentEditor)editor).containsElement((IntentGenericElement)elementToOpen)) {
                    alreadyOpenedEditor = (IntentEditor)editor;
                    activePage.activate((IWorkbenchPart)alreadyOpenedEditor);
                }
                ++editorCount;
            }
        }
        return alreadyOpenedEditor;
    }

    private static IntentEditor openEditor(RepositoryAdapter repositoryAdapter, IWorkbenchPage page, Object intentElementToOpen) throws PartInitException {
        boolean canBeOpenedByIntentEditor = IntentHelper.canBeOpenedByIntentEditor((Object)intentElementToOpen);
        EObject elementToOpen = null;
        if (intentElementToOpen instanceof EObject) {
            elementToOpen = (EObject)intentElementToOpen;
        }
        while (!canBeOpenedByIntentEditor && elementToOpen != null && !(elementToOpen instanceof Resource)) {
            elementToOpen = elementToOpen.eContainer();
            canBeOpenedByIntentEditor = IntentHelper.canBeOpenedByIntentEditor((Object)elementToOpen);
        }
        if (canBeOpenedByIntentEditor) {
            IntentEditorInput input = new IntentEditorInput(elementToOpen, repositoryAdapter);
            IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.mylyn.docs.intent.client.ui.IntentEditor");
            if (part instanceof IntentEditor) {
                return (IntentEditor)part;
            }
            Status status = new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", "cannot open the editor");
            throw new PartInitException((IStatus)status);
        }
        IntentUiLogger.logError("this element is not a correct Intent element", new PartInitException("Invalid element : must be a Intent Element"));
        Status status = new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", "this element is not a correct Intent element");
        throw new PartInitException((IStatus)status);
    }
}

