/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentPairMatcher;
import org.eclipse.mylyn.docs.intent.client.ui.editor.completion.AbstractIntentCompletionProcessor;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentCompletionProcessor
extends AbstractIntentCompletionProcessor {
    private static final int NULL_CONTEXT = -1;
    private static final int DOCUMENT_CONTEXT = 0;
    private static final int CHAPTER_CONTEXT = 1;
    private static final int SECTION_CONTEXT = 2;
    private static final Pattern[] PATTERNS_BY_CONTEXT = new Pattern[]{Pattern.compile("Document\\s+[^{\r\n]*\\{"), Pattern.compile("Chapter\\s+[^{\r\n]*\\{"), Pattern.compile("Section\\s+[^{\r\n]*\\{")};
    private static final String[][] KEYWORDS_BY_CONTEXT = new String[][]{{"Chapter"}, {"Section"}, {"Section", "@M"}};
    private int accurateContext;
    private IntentPairMatcher blockMatcher;

    public IntentCompletionProcessor(IntentPairMatcher matcher) {
        this.blockMatcher = matcher;
    }

    private void computeAccurateContext() throws BadLocationException {
        int[] offsetsByContextType = new int[3];
        String startText = this.document.get(0, this.offset);
        int i = 0;
        while (i < PATTERNS_BY_CONTEXT.length) {
            offsetsByContextType[i] = this.getLastIndexOf(startText, PATTERNS_BY_CONTEXT[i]);
            ++i;
        }
        int res = -1;
        int maxValue = -1;
        int i2 = 0;
        while (i2 < offsetsByContextType.length) {
            IRegion region;
            if (offsetsByContextType[i2] > maxValue && (region = this.blockMatcher.match(this.document, offsetsByContextType[i2])) != null && region.getOffset() + region.getLength() > this.offset) {
                maxValue = offsetsByContextType[i2];
                res = i2;
            }
            ++i2;
        }
        this.accurateContext = res;
    }

    @Override
    protected ICompletionProposal[] computeCompletionProposals() {
        try {
            this.computeAccurateContext();
        }
        catch (BadLocationException e) {
            IntentUiLogger.logError(e);
        }
        ArrayList<Object> proposals = new ArrayList<Object>();
        proposals.addAll(this.createKeyWordsProposals());
        proposals.addAll(this.createTemplatesProposals());
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected Collection<ICompletionProposal> createKeyWordsProposals() {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (this.accurateContext >= 0) {
            String[] stringArray = KEYWORDS_BY_CONTEXT[this.accurateContext];
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                if (!"".equals(this.start) && keyword.startsWith(this.start)) {
                    proposals.add(this.createKeyWordProposal(keyword));
                }
                ++n2;
            }
        }
        return proposals;
    }

    protected List<TemplateProposal> createTemplatesProposals() {
        TemplateProposal chapterProposal = this.createTemplateProposal("Chapter", "Chapter", "Chapter ${Title} {\n\t${Text}\n}\n", "icon/outline/chapter.gif");
        TemplateProposal sectionProposal = this.createTemplateProposal("Section", "Section", "Section ${Title} {\n\t${Text}\n}\n", "icon/outline/section.gif");
        TemplateProposal modelingUnitProposal = this.createTemplateProposal("Modeling Unit", "Modeling Unit", "@M\n${Code}\nM@\n", "icon/outline/modelingunit.png");
        ArrayList<TemplateProposal> proposals = new ArrayList<TemplateProposal>();
        switch (this.accurateContext) {
            case 0: {
                proposals.add(chapterProposal);
                break;
            }
            case 1: {
                proposals.add(sectionProposal);
                break;
            }
            case 2: {
                proposals.add(sectionProposal);
                proposals.add(modelingUnitProposal);
                break;
            }
        }
        return proposals;
    }

    @Override
    public String getContextType() {
        return "__dftl_partition_content_type";
    }
}

