/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import org.eclipse.mylyn.docs.intent.markup.markup.Annotations;

public final class AttributeStyleSerializer {
    private static String BLOC_ALIGN_LEFT = "text-align: left;";
    private static String BLOC_ALIGN_CENTER = "text-align: center;";
    private static String BLOC_ALIGN_RIGHT = "text-align: right;";
    private static String BLOC_ALIGN_JUSTIFY = "text-align: justify;";
    private static String BLOC_PADDINGLEFTBEGIN = "padding-left: ";
    private static String BLOC_PADDINGEND = "em;";
    private static String BLOC_PADDINGLEFT = String.valueOf(BLOC_PADDINGLEFTBEGIN) + "[0-9]+" + BLOC_PADDINGEND;
    private static String BLOC_PADDINGRIGHTBEGIN = "padding-right: ";
    private static String BLOC_PADDINGRIGHT = String.valueOf(BLOC_PADDINGRIGHTBEGIN) + "[0-9]+" + BLOC_PADDINGEND;

    private AttributeStyleSerializer() {
    }

    public static String renderAttributeForBloc(Annotations attr) {
        String style = "";
        if (attr != null && attr.getCSSStyle() != null) {
            style = String.valueOf(style) + AttributeStyleSerializer.renderStyle(attr.getCSSStyle());
        }
        return style;
    }

    private static String renderStyle(String style) {
        String preformattedStyles = "";
        String remainingStyles = style;
        String[] alignementResult = AttributeStyleSerializer.manageAlignment(style);
        remainingStyles = alignementResult[1];
        String[] paddingResult = AttributeStyleSerializer.managePadding(remainingStyles);
        if ((remainingStyles = paddingResult[1]).length() > 0 && !remainingStyles.contains("{")) {
            remainingStyles = "{" + remainingStyles + "}";
        }
        preformattedStyles = String.valueOf(alignementResult[0]) + paddingResult[0];
        return String.valueOf(preformattedStyles) + remainingStyles;
    }

    private static String[] manageAlignment(String style) {
        String preformattedStyles = "";
        String remainingStyles = style;
        if (style.contains(BLOC_ALIGN_JUSTIFY)) {
            preformattedStyles = String.valueOf(preformattedStyles) + "<>";
            remainingStyles = remainingStyles.replace(BLOC_ALIGN_JUSTIFY, "");
        }
        if (style.contains(BLOC_ALIGN_LEFT)) {
            preformattedStyles = String.valueOf(preformattedStyles) + "<";
            remainingStyles = remainingStyles.replace(BLOC_ALIGN_LEFT, "");
        }
        if (style.contains(BLOC_ALIGN_RIGHT)) {
            preformattedStyles = String.valueOf(preformattedStyles) + ">";
            remainingStyles = remainingStyles.replace(BLOC_ALIGN_RIGHT, "");
        }
        if (style.contains(BLOC_ALIGN_CENTER)) {
            preformattedStyles = String.valueOf(preformattedStyles) + "=";
            remainingStyles = remainingStyles.replace(BLOC_ALIGN_CENTER, "");
        }
        String[] result = new String[]{preformattedStyles, remainingStyles};
        return result;
    }

    private static String[] managePadding(String style) {
        String preformattedStyles = "";
        String remainingStyles = style;
        boolean styleHasPaddingDeclaration = false;
        boolean isLeftPadding = true;
        String paddingSymbol = "(";
        if (style.matches(BLOC_PADDINGLEFT)) {
            styleHasPaddingDeclaration = true;
            remainingStyles = remainingStyles.replaceAll(BLOC_PADDINGLEFT, "");
        }
        if (style.matches(BLOC_PADDINGRIGHT)) {
            isLeftPadding = false;
            styleHasPaddingDeclaration = true;
            paddingSymbol = ")";
            remainingStyles = remainingStyles.replaceAll(BLOC_PADDINGRIGHT, "");
        }
        if (styleHasPaddingDeclaration) {
            int paddingValue = AttributeStyleSerializer.getPaddingValue(style, isLeftPadding);
            int i = 1;
            while (i <= paddingValue) {
                preformattedStyles = String.valueOf(preformattedStyles) + paddingSymbol;
                ++i;
            }
        }
        String[] result = new String[]{preformattedStyles, remainingStyles};
        return result;
    }

    private static int getPaddingValue(String style, boolean isLeftPadding) {
        String paddingDeclaration = "";
        if (isLeftPadding) {
            paddingDeclaration = style.replace(style.replaceAll(BLOC_PADDINGLEFT, ""), "");
            paddingDeclaration = paddingDeclaration.replace(BLOC_PADDINGLEFTBEGIN, "");
        } else {
            paddingDeclaration = style.replace(style.replaceAll(BLOC_PADDINGRIGHT, ""), "");
            paddingDeclaration = paddingDeclaration.replace(BLOC_PADDINGRIGHTBEGIN, "");
        }
        paddingDeclaration = paddingDeclaration.replace(BLOC_PADDINGEND, "");
        return Integer.valueOf(paddingDeclaration);
    }
}

