/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.InvalidReferenceException;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.ModelingUnitGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.StructuralFeatureGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modellinking.ModelingUnitLinkResolver;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;

public final class ContributionInstructionGenerator {
    private ContributionInstructionGenerator() {
    }

    public static void generate(ContributionInstruction contributionInstruction, ModelingUnitGenerator modelingUnitGenerator, ModelingUnitLinkResolver linkResolver) {
        ModelingUnitGenerator.clearCompilationStatus((IntentGenericElement)contributionInstruction);
        String instanceTextualReference = contributionInstruction.getReferencedElement().getIntentHref();
        if (modelingUnitGenerator.getInformationHolder().isUnresolvedContribution(contributionInstruction)) {
            try {
                EObject referencedElement = linkResolver.resolveReferenceinElementList((UnitInstruction)contributionInstruction, null, instanceTextualReference);
                for (ModelingUnitInstruction instruction : contributionInstruction.getContributions()) {
                    if (!(instruction instanceof StructuralFeatureAffectation)) continue;
                    StructuralFeatureGenerator.generateFeatureAndAddToClass((StructuralFeatureAffectation)instruction, referencedElement, linkResolver, modelingUnitGenerator);
                }
                modelingUnitGenerator.getInformationHolder().addUnresolvedContribution(instanceTextualReference, contributionInstruction);
                modelingUnitGenerator.getInformationHolder().setContributionInstructionAsResolved(contributionInstruction);
            }
            catch (InvalidReferenceException invalidReferenceException) {
                modelingUnitGenerator.getInformationHolder().addUnresolvedContribution(instanceTextualReference, contributionInstruction);
            }
        }
    }
}

