/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.markup.markup.BlockContent;
import org.eclipse.mylyn.docs.intent.markup.markup.Table;
import org.eclipse.mylyn.docs.intent.markup.markup.TableCell;
import org.eclipse.mylyn.docs.intent.markup.markup.TableRow;
import org.eclipse.mylyn.docs.intent.markup.serializer.WikiTextElementDispatcher;

public final class TableSerializer {
    private static final String[] TD_ALIGNS = new String[]{"top;", "center;", "bottom;"};
    private static final String[] TD_ALIGNS_TRANSLATION = new String[]{"^", "-", Character.toString('~')};
    private static final String TD_TEXT_ALIGN = "text-align: ";
    private static final String TD_VERTICAL_ALIGN = "vertical-align: ";
    private static final String TD_HEADER_TRADUCTION = "_.";
    private static String TD_SPACE_TRADUCTION = "|";

    private TableSerializer() {
    }

    public static String render(Table table, WikiTextElementDispatcher dispatcher) {
        String renderedTable = "\n";
        if (table.getAttributes().getCSSClass() != null) {
            renderedTable = String.valueOf(renderedTable) + "table(" + table.getAttributes().getCSSClass() + ").";
        }
        for (BlockContent blocContent : table.getContent()) {
            if (!(blocContent instanceof TableRow)) continue;
            TableRow tr = (TableRow)blocContent;
            renderedTable = String.valueOf(renderedTable) + "\n";
            if (tr.getAttributes().getCSSClass() != null) {
                renderedTable = String.valueOf(renderedTable) + "(" + tr.getAttributes().getCSSClass() + "). ";
            }
            for (BlockContent bloc : tr.getContent()) {
                String cssStyle;
                TableCell td = (TableCell)bloc;
                renderedTable = String.valueOf(renderedTable) + TD_SPACE_TRADUCTION;
                if (td.isIsCellHeader()) {
                    renderedTable = String.valueOf(renderedTable) + "_. ";
                }
                if ((cssStyle = td.getAttributes().getCSSStyle()) != null) {
                    String[] renderedStyle = TableSerializer.renderStyleFortableCell(cssStyle);
                    cssStyle = renderedStyle[0];
                    renderedTable = String.valueOf(renderedTable) + renderedStyle[1];
                }
                renderedTable = String.valueOf(renderedTable) + (String)dispatcher.doSwitch((EObject)td);
            }
            renderedTable = String.valueOf(renderedTable) + TD_SPACE_TRADUCTION;
        }
        return renderedTable;
    }

    private static String[] renderStyleFortableCell(String styleToRender) {
        String cssStyle = styleToRender;
        String renderedCellStyle = "";
        int alignID = 0;
        String[] stringArray = TD_ALIGNS;
        int n = TD_ALIGNS.length;
        int n2 = 0;
        while (n2 < n) {
            String align = stringArray[n2];
            if (cssStyle.contains(TD_TEXT_ALIGN + align)) {
                renderedCellStyle = String.valueOf(renderedCellStyle) + TD_ALIGNS_TRANSLATION[alignID];
                cssStyle = cssStyle.replace(TD_TEXT_ALIGN + align, "");
            } else if (cssStyle.contains(TD_VERTICAL_ALIGN + align)) {
                renderedCellStyle = String.valueOf(renderedCellStyle) + TD_ALIGNS_TRANSLATION[alignID];
                cssStyle = cssStyle.replace(TD_VERTICAL_ALIGN + align, "");
            }
            ++alignID;
            ++n2;
        }
        if (cssStyle.length() > 0 && !"{}".equals(cssStyle)) {
            renderedCellStyle = String.valueOf(renderedCellStyle) + "{" + cssStyle + "}";
        }
        renderedCellStyle = String.valueOf(renderedCellStyle) + ". ";
        String[] result = new String[]{cssStyle, renderedCellStyle};
        return result;
    }
}

