/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.retro;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetroGeneratedElementListenerDeltaVisitor
implements IResourceDeltaVisitor {
    protected Collection<URI> changedResources;
    protected Collection<URI> removedResources;
    protected Set<URI> listennedElementsURIs;

    public RetroGeneratedElementListenerDeltaVisitor(Set<URI> listenedElementsURIs) {
        this.listennedElementsURIs = listenedElementsURIs;
        this.changedResources = Sets.newLinkedHashSet();
        this.removedResources = Sets.newLinkedHashSet();
    }

    public boolean visit(IResourceDelta delta) {
        if (delta.getResource().getType() != 1) {
            return true;
        }
        if (this.isRelevantModification(delta)) {
            String uri = delta.getFullPath().toString();
            URI changedResourceURI = URI.createPlatformResourceURI((String)uri, (boolean)false);
            URI retroResourceURI = this.getRetroResourceURI(changedResourceURI);
            if (changedResourceURI != null && retroResourceURI != null) {
                switch (delta.getKind()) {
                    case 2: {
                        this.removedResources.add(retroResourceURI);
                        break;
                    }
                    case 1: 
                    case 4: {
                        this.changedResources.add(retroResourceURI);
                        break;
                    }
                }
            }
        }
        return true;
    }

    protected boolean isRelevantModification(IResourceDelta delta) {
        boolean isRelevantModification = delta.getKind() == 2 || delta.getKind() == 4 || delta.getKind() == 1;
        isRelevantModification = isRelevantModification && (delta.getFlags() & 0x20000) == 0;
        return isRelevantModification;
    }

    public Collection<URI> getChangedResources() {
        return this.changedResources;
    }

    public Collection<URI> getRemovedResources() {
        return this.removedResources;
    }

    private URI getRetroResourceURI(URI changedResourceURI) {
        for (URI listenedElementURI : this.listennedElementsURIs) {
            if (!changedResourceURI.toString().contains(listenedElementURI.toString().replace(String.valueOf(listenedElementURI.scheme()) + ":/", ""))) continue;
            return listenedElementURI;
        }
        return null;
    }
}

