/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.util.Strings;

public class Reporter {
    private static final ThreadLocal<ITestResult> m_currentTestResult = new InheritableThreadLocal<ITestResult>();
    private static final List<String> m_output = new LinkedList<String>();
    private static final Map<String, List<Integer>> m_methodOutputMap = Maps.newConcurrentMap();
    private static boolean m_escapeHtml = false;
    private static final ThreadLocal<List<String>> m_orphanedOutput = new InheritableThreadLocal<List<String>>();

    public static void setCurrentTestResult(ITestResult m) {
        m_currentTestResult.set(m);
    }

    public static List<String> getOutput() {
        return m_output;
    }

    public static void clear() {
        m_methodOutputMap.clear();
        m_output.clear();
    }

    public static boolean getEscapeHtml() {
        return m_escapeHtml;
    }

    public static void setEscapeHtml(boolean escapeHtml) {
        m_escapeHtml = escapeHtml;
    }

    private static synchronized void log(String s, ITestResult m) {
        if (m_escapeHtml) {
            s = Strings.escapeHtml(s);
        }
        if (m == null) {
            if (m_orphanedOutput.get() == null) {
                m_orphanedOutput.set(new LinkedList());
            }
            m_orphanedOutput.get().add(s);
            return;
        }
        int n = Reporter.getOutput().size();
        List lines = m_methodOutputMap.computeIfAbsent(m.id(), k -> Lists.newLinkedList());
        if (m_orphanedOutput.get() != null) {
            n += m_orphanedOutput.get().size();
            Reporter.getOutput().addAll((Collection<String>)m_orphanedOutput.get());
            m_orphanedOutput.remove();
        }
        lines.add(n);
        Reporter.getOutput().add(s);
    }

    public static void log(String s) {
        Reporter.log(s, Reporter.getCurrentTestResult());
    }

    public static void log(String s, int level, boolean logToStandardOut) {
        if (Utils.getVerbose() >= level) {
            Reporter.log(s, Reporter.getCurrentTestResult());
            if (logToStandardOut) {
                System.out.println(s);
            }
        }
    }

    public static void log(String s, boolean logToStandardOut) {
        Reporter.log(s, Reporter.getCurrentTestResult());
        if (logToStandardOut) {
            System.out.println(s);
        }
    }

    public static void log(String s, int level) {
        if (Utils.getVerbose() >= level) {
            Reporter.log(s, Reporter.getCurrentTestResult());
        }
    }

    public static ITestResult getCurrentTestResult() {
        return m_currentTestResult.get();
    }

    public static synchronized List<String> getOutput(ITestResult tr) {
        List<String> result = Lists.newArrayList();
        if (tr == null) {
            return result;
        }
        List<Integer> lines = m_methodOutputMap.get(tr.id());
        if (lines != null) {
            for (Integer n : lines) {
                result.add(Reporter.getOutput().get(n));
            }
        }
        return result;
    }
}

