/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.TarBz2Exporter;
import org.jboss.shrinkwrap.api.exporter.TarExporter;
import org.jboss.shrinkwrap.api.exporter.TarGzExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.StreamImporter;
import org.jboss.shrinkwrap.api.importer.TarBz2Importer;
import org.jboss.shrinkwrap.api.importer.TarGzImporter;
import org.jboss.shrinkwrap.api.importer.TarImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArchiveFormatStreamBindings {
    private final Class<? extends StreamImporter<?>> importer;
    private final Class<? extends StreamExporter> exporter;

    ArchiveFormatStreamBindings(ArchiveFormat format) {
        switch (format) {
            case TAR: {
                this.importer = TarImporter.class;
                this.exporter = TarExporter.class;
                break;
            }
            case TAR_GZ: {
                this.importer = TarGzImporter.class;
                this.exporter = TarGzExporter.class;
                break;
            }
            case TAR_BZ: {
                this.importer = TarBz2Importer.class;
                this.exporter = TarBz2Exporter.class;
                break;
            }
            case ZIP: {
                this.importer = ZipImporter.class;
                this.exporter = ZipExporter.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format specified: " + format);
            }
        }
    }

    public Class<? extends StreamExporter> getExporter() {
        return this.exporter;
    }

    public Class<? extends StreamImporter<?>> getImporter() {
        return this.importer;
    }
}

