/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session;

import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import java.io.IOException;
import org.jboss.cdi.tck.tests.context.session.SimpleSessionBean;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebFilter(filterName="FilterTest", displayName="Test Filter for Sessions", urlPatterns={"/SimplePage.html"})
public class TestFilter
implements Filter {
    private static final SimpleLogger logger = new SimpleLogger(TestFilter.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private SimpleSessionBean simpleBean;

    public void destroy() {
        this.beanManager = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.log("Do filter...", new Object[0]);
        this.checkSessionContextActive();
        chain.doFilter(request, response);
        this.checkSessionContextActive();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private void checkSessionContextActive() throws ServletException {
        if (this.beanManager == null || !this.beanManager.getContext(SessionScoped.class).isActive() || this.simpleBean == null) {
            throw new ServletException("Session context is not active");
        }
        this.simpleBean.getId();
    }
}

