/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.qualifier.builtin;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.qualifier.builtin.AnyBean;
import org.jboss.cdi.tck.tests.definition.qualifier.builtin.NamedAnyBean;
import org.jboss.cdi.tck.tests.definition.qualifier.builtin.NamedBean;
import org.jboss.cdi.tck.tests.definition.qualifier.builtin.Order;
import org.jboss.cdi.tck.tests.definition.qualifier.builtin.ProducedAnyBean;
import org.jboss.cdi.tck.tests.definition.qualifier.builtin.ProducedNamedAnyBean;
import org.jboss.cdi.tck.tests.definition.qualifier.builtin.ProducedNamedBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class BuiltInQualifierDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltInQualifierDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtin_qualifiers", id="aa"), @SpecAssertion(section="builtin_qualifiers", id="ab")})
    public void testDefaultQualifierDeclaredInJava() {
        Bean<Order> order = this.getBeans(Order.class, new Annotation[0]).iterator().next();
        Assert.assertEquals((int)order.getQualifiers().size(), (int)2);
        Assert.assertTrue((boolean)order.getQualifiers().contains(Default.Literal.INSTANCE));
        Assert.assertTrue((boolean)order.getQualifiers().contains(Any.Literal.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtin_qualifiers", id="b"), @SpecAssertion(section="bean", id="c")})
    public void testDefaultQualifierForInjectionPoint() {
        Bean<Order> order = this.getBeans(Order.class, new Annotation[0]).iterator().next();
        Assert.assertEquals((int)order.getInjectionPoints().size(), (int)1);
        InjectionPoint injectionPoint = (InjectionPoint)order.getInjectionPoints().iterator().next();
        Assert.assertTrue((boolean)injectionPoint.getQualifiers().contains(Default.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="builtin_qualifiers", id="ab")
    public void testNamedAndAnyBeanHasDefaultQualifier() {
        Bean<NamedAnyBean> nameAnyBeanBean = this.getUniqueBean(NamedAnyBean.class, new Annotation[]{Any.Literal.INSTANCE});
        Assert.assertEquals((int)nameAnyBeanBean.getQualifiers().size(), (int)3);
        this.checkSetContainsAllQuallifiers(nameAnyBeanBean.getQualifiers(), new Annotation[]{Default.Literal.INSTANCE, NamedLiteral.of((String)"namedAnyBean"), Any.Literal.INSTANCE});
    }

    @Test
    @SpecAssertion(section="builtin_qualifiers", id="ab")
    public void testNamedBeanHasDefaultQualifier() {
        Bean<NamedBean> namedBean = this.getUniqueBean(NamedBean.class, new Annotation[0]);
        Assert.assertEquals((int)namedBean.getQualifiers().size(), (int)3);
        this.checkSetContainsAllQuallifiers(namedBean.getQualifiers(), new Annotation[]{Default.Literal.INSTANCE, NamedLiteral.of((String)"namedBean"), Any.Literal.INSTANCE});
    }

    @Test
    @SpecAssertion(section="builtin_qualifiers", id="ab")
    public void testAnyBeanHasDefaultQualifier() {
        Bean<AnyBean> anyBean = this.getUniqueBean(AnyBean.class, new Annotation[]{Any.Literal.INSTANCE});
        Assert.assertEquals((int)anyBean.getQualifiers().size(), (int)2);
        this.checkSetContainsAllQuallifiers(anyBean.getQualifiers(), new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE});
    }

    @Test
    @SpecAssertion(section="builtin_qualifiers", id="ab")
    public void testProducedNamedAndAnyBeanHasDefaultQualifier() {
        Bean<ProducedNamedAnyBean> producedNamedAnyBeanBean = this.getUniqueBean(ProducedNamedAnyBean.class, new Annotation[0]);
        Assert.assertEquals((int)producedNamedAnyBeanBean.getQualifiers().size(), (int)3);
        this.checkSetContainsAllQuallifiers(producedNamedAnyBeanBean.getQualifiers(), new Annotation[]{Default.Literal.INSTANCE, NamedLiteral.of((String)"producedNamedAnyBean"), Any.Literal.INSTANCE});
    }

    @Test
    @SpecAssertion(section="builtin_qualifiers", id="ab")
    public void testProducedNamedBeanHasDefaultQualifier() {
        Bean<ProducedNamedBean> producedNamedBeanBean = this.getUniqueBean(ProducedNamedBean.class, new Annotation[0]);
        Assert.assertEquals((int)producedNamedBeanBean.getQualifiers().size(), (int)3);
        this.checkSetContainsAllQuallifiers(producedNamedBeanBean.getQualifiers(), new Annotation[]{Default.Literal.INSTANCE, NamedLiteral.of((String)"producedNamedBean"), Any.Literal.INSTANCE});
    }

    @Test
    @SpecAssertion(section="builtin_qualifiers", id="ab")
    public void testProducedAnyBeanHasDefaultQualifier() {
        Bean<ProducedAnyBean> producedAnyBeanBean = this.getUniqueBean(ProducedAnyBean.class, new Annotation[0]);
        Assert.assertEquals((int)producedAnyBeanBean.getQualifiers().size(), (int)2);
        this.checkSetContainsAllQuallifiers(producedAnyBeanBean.getQualifiers(), new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE});
    }

    private void checkSetContainsAllQuallifiers(Set<Annotation> qualifiersSet, Annotation ... literals) {
        for (Annotation literal : literals) {
            Assert.assertTrue((boolean)qualifiersSet.contains(literal));
        }
    }
}

