/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Assert {
    private Assert() {
    }

    public static void assertAnnotationSetMatches(Set<? extends Annotation> annotations, Class<? extends Annotation> ... requiredAnnotationTypes) {
        if (annotations == null) {
            throw new IllegalArgumentException();
        }
        if (annotations.size() != requiredAnnotationTypes.length) {
            org.testng.Assert.fail((String)String.format("Set %s (%s) does not match array %s (%s)", annotations, annotations.size(), Arrays.toString(requiredAnnotationTypes), requiredAnnotationTypes.length));
        }
        if (annotations.isEmpty() && requiredAnnotationTypes.length == 0) {
            return;
        }
        List<Class<? extends Annotation>> requiredAnnotationTypesList = Arrays.asList(requiredAnnotationTypes);
        for (Annotation annotation : annotations) {
            if (requiredAnnotationTypesList.contains(annotation.annotationType())) continue;
            org.testng.Assert.fail((String)String.format("Set %s (%s) does not match array %s (%s)", annotations, annotations.size(), requiredAnnotationTypesList, requiredAnnotationTypesList.size()));
        }
    }

    public static void assertTypeSetMatches(Set<? extends Type> types, Type ... requiredTypes) {
        if (types == null) {
            throw new IllegalArgumentException();
        }
        List<Type> requiredTypeList = Arrays.asList(requiredTypes);
        if (requiredTypes.length != types.size() || !types.containsAll(requiredTypeList)) {
            org.testng.Assert.fail((String)String.format("Set %s (%s) does not match array %s (%s)", types, types.size(), requiredTypeList, requiredTypeList.size()));
        }
    }

    public static void assertTypeListMatches(List<? extends Type> types, Type ... requiredTypes) {
        if (types == null) {
            throw new IllegalArgumentException();
        }
        List<Type> requiredTypeList = Arrays.asList(requiredTypes);
        if (requiredTypes.length != types.size() || !types.containsAll(requiredTypeList)) {
            org.testng.Assert.fail((String)String.format("List %s (%s) does not match array %s (%s)", types, types.size(), requiredTypeList, requiredTypeList.size()));
        }
    }

    public static void assertAnnotated(Annotated expected, Annotated actual) {
        org.testng.Assert.assertEquals((Object)Assert.unwrap(expected), (Object)Assert.unwrap(actual));
    }

    private static Object unwrap(Annotated annotated) {
        if (annotated instanceof AnnotatedMember) {
            return ((AnnotatedMember)annotated).getJavaMember();
        }
        if (annotated instanceof AnnotatedParameter) {
            return ((AnnotatedParameter)annotated).getJavaParameter();
        }
        if (annotated instanceof AnnotatedType) {
            return ((AnnotatedType)annotated).getJavaClass();
        }
        throw new UnsupportedOperationException("Unknown Annotated instance: " + annotated);
    }
}

