/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class EnumPlatformClasspathImpl
implements Classpath {
    private List<String> classes;
    private Iterator<String> it;

    @Override
    public void init(String classPath) throws IOException {
        this.init();
    }

    @Override
    public void close() {
        if (this.classes != null) {
            this.classes.clear();
        }
    }

    @Override
    public boolean hasNext() {
        this.init();
        return this.it.hasNext();
    }

    @Override
    public String nextClassName() {
        this.init();
        return this.it.next();
    }

    @Override
    public boolean isEmpty() {
        this.init();
        return this.classes.isEmpty();
    }

    @Override
    public void printErrors(PrintWriter out) {
    }

    @Override
    public void setListToBegin() {
        this.it = this.classes.iterator();
    }

    @Override
    public InputStream findClass(String qualifiedClassName) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassDescription findClassDescription(String className) throws ClassNotFoundException {
        ClassDescriptionLoader l = AppContext.getContext().getClassLoader();
        assert (l != null);
        if (l != null) {
            return l.load(className);
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Classpath.KIND_CLASS_DATA isClassPresent(String qualifiedClassName) {
        throw new UnsupportedOperationException();
    }

    private void init() {
        if (this.classes == null) {
            this.classes = new ArrayList<String>();
            for (ModuleReference modRef : ModuleFinder.ofSystem().findAll()) {
                try {
                    ModuleReader reader = modRef.open();
                    try {
                        String ext = ".class";
                        int eLen = ext.length();
                        this.classes.addAll(reader.list().filter(e -> e.endsWith(ext) && !e.equals("module-info.class")).map(e -> e.replace('/', '.').substring(0, e.length() - eLen)).collect(Collectors.toList()));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e2) {
                    SwissKnife.reportThrowable(e2);
                }
            }
            this.setListToBegin();
        }
    }
}

