/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.WizPrint;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinderQueue;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PropertyArray;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

class HarnessHttpHandler
extends JThttpProvider
implements Harness.Observer {
    private Harness harness;
    private boolean debug = false;
    private String magicToken;
    private int[] stats = new int[4];
    private TestFinderQueue tfq;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(HarnessHttpHandler.class);

    HarnessHttpHandler(Harness harness) {
        this.harness = harness;
        harness.addObserver(this);
    }

    @Override
    public void serviceRequest(httpURL requestURL, PrintWriter out) {
        String nf = requestURL.getNextFile();
        if (nf == null) {
            this.beginGood(out);
            this.printHtml(out);
        } else if (nf.equals("env")) {
            this.beginGood(out);
            this.printEnv(out);
        } else if (nf.equals("interview")) {
            this.beginGood(out);
            this.printInterview(out);
        } else if (nf.equals("text")) {
            this.printText(requestURL, out);
        } else if (nf.equals("stop")) {
            if (!this.harness.isRunning()) {
                HarnessHttpHandler.println(out, i18n.getString("harnessHttp.noStop"));
            } else {
                this.beginGood(out);
                if (this.magicToken == null) {
                    long num = Math.round(Math.floor(Math.random() * 30000.0));
                    this.magicToken = Integer.toString((int)num);
                }
                PageGenerator.writeHeader(out, i18n.getString("harnessHttp.stop.hdr"));
                PageGenerator.startBody(out);
                String token = requestURL.getValue("token");
                if (token == null) {
                    this.printStopConfirm(out);
                } else if (token.equals(this.magicToken)) {
                    this.harness.stop();
                    HarnessHttpHandler.println(out, i18n.getString("harnessHttp.stopped"));
                } else {
                    this.printStopErr(out);
                }
                out.println("<hr>");
                PageGenerator.writeFooter(out);
                PageGenerator.endBody(out);
                PageGenerator.writeEndDoc(out);
            }
        } else {
            if (this.debug) {
                System.out.println("TRT.HH-remainder of URL unknown (" + nf + ")");
            }
            this.beginBad(out);
            this.printHtml(out);
        }
        out.close();
    }

    private void beginGood(PrintWriter out) {
        PageGenerator.generateOkHttp(out);
        PageGenerator.generateDocType(out, 0);
    }

    private void beginBad(PrintWriter out) {
        PageGenerator.generateBadHttp(out);
        PageGenerator.generateDocType(out, 0);
    }

    private void printHtml(PrintWriter out) {
        PageGenerator.writeBeginDoc(out);
        this.printIndex(out);
        out.println("<hr>");
        PageGenerator.writeFooter(out);
        PageGenerator.endBody(out);
        PageGenerator.writeEndDoc(out);
    }

    private void printEnv(PrintWriter out) {
        PageGenerator.writeBeginDoc(out);
        PageGenerator.writeHeader(out, i18n.getString("harnessHttp.env.title"));
        out.print("<h3>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.env.hdr"));
        out.println("</h3>");
        Parameters params = this.harness.getParameters();
        if (params != null) {
            this.printEnv(out, params.getEnv());
        } else {
            out.println(i18n.getString("harnessHttp.env.none"));
        }
        out.println("<hr>");
        PageGenerator.writeFooter(out);
        PageGenerator.endBody(out);
        PageGenerator.writeEndDoc(out);
    }

    private void printInterview(PrintWriter out) {
        PageGenerator.writeBeginDoc(out);
        PageGenerator.writeHeader(out, i18n.getString("harnessHttp.interview.title"));
        out.print("<h3>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.interview.hdr"));
        out.println("</h3>");
        try {
            Parameters params = this.harness.getParameters();
            if (params == null || !(this.harness.getParameters() instanceof InterviewParameters)) {
                HarnessHttpHandler.println(out, i18n.getString("harnessHttp.interview.none"));
            } else {
                InterviewParameters interview = (InterviewParameters)this.harness.getParameters();
                WizPrint wp = new WizPrint(interview);
                wp.setShowResponses(true);
                wp.setShowResponseTypes(true);
                wp.setShowTags(true);
                wp.write(out);
            }
            out.println("<hr>");
            PageGenerator.writeFooter(out);
            PageGenerator.endBody(out);
            PageGenerator.writeEndDoc(out);
        }
        catch (IOException e) {
            HarnessHttpHandler.println(out, i18n.getString("harnessHttp.ioProblem"));
        }
    }

    private void printText(httpURL requestURL, PrintWriter out) {
        Parameters params = this.harness.getParameters();
        String nf = requestURL.getNextFile();
        if (nf == null) {
            this.beginGood(out);
            this.printIndex(out);
        } else if (nf.equals("env")) {
            TestEnvironment env = params.getEnv();
            if (env == null) {
                HarnessHttpHandler.print(out, i18n.getString("harnessHttp.env.none"));
                return;
            }
            String[] pa = new String[]{};
            for (TestEnvironment.Element elem : env.elements()) {
                pa = PropertyArray.put(pa, elem.getKey(), elem.getValue());
            }
            try {
                PropertyArray.save(pa, out);
            }
            catch (IOException e) {
                out.println(i18n.getString("harnessHttp.ioProblem"));
            }
        } else if (nf.equals("config")) {
            if (params == null) {
                out.print(i18n.getString("harnessHttp.text.unavail"));
                return;
            }
            TestSuite ts = params.getTestSuite();
            out.print(i18n.getString("harnessHttp.text.ts.path"));
            out.print("=");
            if (ts != null) {
                out.println(ts.getPath());
            } else {
                out.println(i18n.getString("harnessHttp.text.empty"));
            }
            out.print(i18n.getString("harnessHttp.text.ts.name"));
            out.print("=");
            if (ts != null) {
                out.println(ts.getName());
            } else {
                out.println(i18n.getString("harnessHttp.text.empty"));
            }
            out.print(i18n.getString("harnessHttp.text.wd.val"));
            out.print("=");
            WorkDirectory wd = params.getWorkDirectory();
            if (wd != null) {
                out.println(wd.getPath());
            } else {
                out.println(i18n.getString("harnessHttp.text.empty"));
            }
        } else if (nf.equals("tests")) {
            if (params == null) {
                out.print(i18n.getString("harnessHttp.text.unavail"));
                return;
            }
            String[] tests = params.getTests();
            if (tests != null && tests.length != 0) {
                for (int i = 0; i < tests.length; ++i) {
                    out.print("url");
                    out.print(Integer.toString(i));
                    out.print("=");
                    out.println(tests[i]);
                }
            }
        } else if (nf.equals("stats")) {
            if (!this.harness.isRunning()) {
                out.println("");
                return;
            }
            this.stats[3] = this.harness.getTestsFoundCount() - this.stats[0] - this.stats[1] - this.stats[2];
            for (int i = 0; i < 4; ++i) {
                out.print(Status.typeToString(i).replace(' ', '_'));
                out.print("=");
                out.println(this.stats[i]);
            }
        } else if (nf.equals("state")) {
            HarnessHttpHandler.print(out, i18n.getString("harnessHttp.state.run.val"));
            out.println(this.harness.isRunning());
        } else if (nf.equals("results")) {
            TestResultTable trt = this.harness.getResultTable();
            TestFilter[] filters = params.getFilters();
            String[] tests = params.getTests();
            TestResultTable.TreeIterator it = null;
            it = tests == null || tests.length == 0 ? trt.getIterator(filters) : trt.getIterator(params.getTests(), filters);
            while (it.hasNext()) {
                TestResult tr = (TestResult)it.next();
                out.println(tr.getTestName());
                out.println(tr.getStatus().toString());
            }
        } else {
            if (this.debug) {
                System.out.println("TRT.HH-remainder of URL unknown (" + nf + ")");
            }
            HarnessHttpHandler.println(out, i18n.getString("harnessHttp.badRequest", requestURL.getFullPath()));
        }
    }

    private void printStopConfirm(PrintWriter out) {
        out.print("<h2>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.stopConfirm.hdr"));
        out.println("</h2>");
        out.print("<h4>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.stopConfirm.txt"));
        out.println("</h4>");
        out.print("<Form method=get enctype=application/x-www-form-urlencoded>");
        out.print("<p><Input align=center type=submit value=");
        out.print(i18n.getString("harnessHttp.stopConfirm.btn"));
        out.println(">");
        out.print("<Input type=hidden name=token value=");
        out.print(this.magicToken);
        out.println("></Form>");
    }

    private void printStopErr(PrintWriter out) {
        out.println("<h2>");
        HarnessHttpHandler.println(out, i18n.getString("harnessHttp.stopErr.hdr"));
        out.println("</h2>");
        out.println("<b>");
        HarnessHttpHandler.println(out, i18n.getString("harnessHttp.stopErr.text1"));
        HarnessHttpHandler.println(out, i18n.getString("harnessHttp.stopErr.text2"));
        out.println("</b>");
        out.println("<p>");
        HarnessHttpHandler.println(out, i18n.getString("harnessHttp.stopErr.text3"));
        out.println("<a href=\"/harness/stop\">");
        HarnessHttpHandler.println(out, i18n.getString("harnessHttp.stopErr.text4"));
        out.println("</a>");
        HarnessHttpHandler.println(out, i18n.getString("harnessHttp.stopErr.text5"));
    }

    private void printIndex(PrintWriter out) {
        PageGenerator.writeHeader(out, i18n.getString("harnessHttp.index.title"));
        PageGenerator.startBody(out);
        out.println("<h2>");
        out.print("JT Harness &#8482; ");
        HarnessHttpHandler.println(out, i18n.getString("harnessHttp.index.hdr"));
        out.println("</h2>");
        Parameters params = this.harness.getParameters();
        if (params == null) {
            out.println(i18n.getString("harnessHttp.parameters.noParams"));
            return;
        }
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.parameters.tsName"));
        String name = params.getTestSuite().getName();
        HarnessHttpHandler.println(out, name == null ? i18n.getString("harnessHttp.parameters.noTs") : name);
        out.println("<br>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.parameters.tsPath"));
        File tsr = params.getTestSuite().getRoot();
        HarnessHttpHandler.println(out, tsr == null ? i18n.getString("harnessHttp.parameters.noTs") : tsr.getPath());
        out.println("<br>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.parameters.wd"));
        WorkDirectory wd = params.getWorkDirectory();
        if (wd != null) {
            HarnessHttpHandler.println(out, wd.getPath());
        } else {
            HarnessHttpHandler.print(out, i18n.getString("harnessHttp.parameters.noWd"));
        }
        out.println("<p>");
        this.printParameters(out, params);
        TestResultTable currentResults = this.harness.getResultTable();
        out.println("<h3>");
        HarnessHttpHandler.println(out, i18n.getString("harnessHttp.results.hdr"));
        out.println("</h3>");
        if (currentResults != null) {
            JThttpProvider trtProv = RootRegistry.getObjectHandler(currentResults);
            if (trtProv != null && trtProv.getRootURL() != null) {
                out.print("<a href=\"");
                out.print(trtProv.getRootURL());
                out.print("\">");
                HarnessHttpHandler.print(out, i18n.getString("harnessHttp.trt.link"));
                out.println("</a>");
            }
        } else {
            out.print(i18n.getString("harnessHttp.trt.none"));
        }
    }

    private void printParameters(PrintWriter out, Parameters params) {
        out.println("<h3>");
        HarnessHttpHandler.println(out, i18n.getString("harnessHttp.parameters.hdr"));
        out.println("</h3>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.parameters.env"));
        TestEnvironment tev = params.getEnv();
        if (tev != null) {
            out.print("<a href=\"");
            out.print(this.getRootURL());
            out.print("/env\">");
            HarnessHttpHandler.print(out, tev.getName());
            out.println("</a>");
        } else {
            HarnessHttpHandler.println(out, i18n.getString("harnessHttp.parameters.noEnv"));
        }
        out.println("<br>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.parameters.interview"));
        if (params instanceof InterviewParameters) {
            InterviewParameters ip = (InterviewParameters)params;
            File ipf = ip.getFile();
            out.print("<a href=\"");
            out.print(this.getRootURL());
            out.print("/interview\">");
            HarnessHttpHandler.print(out, ipf == null ? i18n.getString("harnessHttp.parameters.noInterviewFile") : ipf.getPath());
            out.println("</a>");
        } else {
            HarnessHttpHandler.println(out, i18n.getString("harnessHttp.parameters.noInterview"));
        }
        out.println("<p>");
        out.println("<ul>");
        out.print("<li>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.parameters.urls"));
        this.printTests(out);
        out.print("<li>");
        HarnessHttpHandler.print(out, i18n.getString("harnessHttp.parameters.jtx"));
        Parameters.ExcludeListParameters exclParams = params.getExcludeListParameters();
        if (exclParams instanceof Parameters.MutableExcludeListParameters) {
            Parameters.MutableExcludeListParameters e = (Parameters.MutableExcludeListParameters)exclParams;
            File[] jtx = e.getExcludeFiles();
            if (jtx == null || jtx.length == 0) {
                HarnessHttpHandler.println(out, i18n.getString("harnessHttp.parameters.emptyJtx"));
            } else {
                out.println("<ul>");
                for (int i = 0; i < jtx.length; ++i) {
                    out.println("<li>" + jtx[i].getPath());
                }
                out.println("</ul>");
            }
        } else {
            HarnessHttpHandler.println(out, i18n.getString("harnessHttp.parameters.noJtx"));
        }
        out.println("</ul>");
    }

    private void printTests(PrintWriter out) {
        String[] tests = this.harness.getParameters().getTests();
        if (tests == null || tests.length == 0) {
            HarnessHttpHandler.print(out, i18n.getString("harnessHttp.parameters.noTests"));
        } else {
            out.println("<ul>");
            for (int i = 0; i < tests.length; ++i) {
                out.println("<li>");
                HarnessHttpHandler.println(out, tests[i]);
            }
            out.println("</ul>");
        }
    }

    private void printEnv(PrintWriter out, TestEnvironment env) {
        out.print(i18n.getString("harnessHttp.env.name"));
        HarnessHttpHandler.println(out, env.getName());
        String keyHeader = "Key";
        String valHeader = "Value";
        out.println("<Table Border>");
        StringBuffer buf = new StringBuffer(50);
        buf.append("<tr><th>");
        buf.append(HarnessHttpHandler.filterTags(keyHeader));
        buf.append("<th>");
        buf.append(HarnessHttpHandler.filterTags(valHeader));
        buf.append("</tr>");
        out.println(buf.toString());
        for (String key : env.keys()) {
            out.println("<tr>");
            buf.setLength(0);
            buf.append("<td>");
            buf.append(key.toString());
            buf.append("<td>");
            try {
                buf.append(HarnessHttpHandler.filterTags(StringArray.join(env.lookup(key))));
            }
            catch (TestEnvironment.Fault f) {
                buf.append(i18n.getString("harnessHttp.env.error"));
            }
            out.println(buf.toString());
            out.println("</tr>");
        }
        out.println("</Table>");
    }

    @Override
    public void startingTestRun(Parameters params) {
    }

    @Override
    public void startingTest(TestResult tr) {
    }

    @Override
    public void finishedTest(TestResult tr) {
        int n = tr.getStatus().getType();
        this.stats[n] = this.stats[n] + 1;
    }

    @Override
    public void stoppingTestRun() {
    }

    @Override
    public void finishedTesting() {
    }

    @Override
    public void finishedTestRun(boolean allOK) {
    }

    @Override
    public void error(String msg) {
    }
}

