/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.january.form.AbstractTreeCompositeIterator;
import org.eclipse.january.form.TreeComposite;

public class BreadthFirstTreeCompositeIterator
extends AbstractTreeCompositeIterator {
    private final Queue<TreeComposite> queue = new LinkedList<TreeComposite>();

    public BreadthFirstTreeCompositeIterator(TreeComposite root) {
        super(root != null ? root : new TreeComposite());
        if (root == null) {
            throw new IllegalArgumentException("BreadthFirstTreeCompositeIterator error: Root cannot be null.");
        }
        this.queue.add(root);
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public TreeComposite next() {
        TreeComposite next = super.next();
        next = this.queue.poll();
        int i = 0;
        while (i < next.getNumberOfChildren()) {
            this.queue.add(next.getChildAtIndex(i));
            ++i;
        }
        return next;
    }
}

