/*
 * generated by Xtext 2.10.0
 */
package org.eclipse.january.geometry.xtext.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.january.geometry.xtext.iGES.Data;
import org.eclipse.january.geometry.xtext.iGES.End;
import org.eclipse.january.geometry.xtext.iGES.Entry;
import org.eclipse.january.geometry.xtext.iGES.Global;
import org.eclipse.january.geometry.xtext.iGES.HString;
import org.eclipse.january.geometry.xtext.iGES.IGES;
import org.eclipse.january.geometry.xtext.iGES.IGESPackage;
import org.eclipse.january.geometry.xtext.iGES.PEntry;
import org.eclipse.january.geometry.xtext.iGES.Param;
import org.eclipse.january.geometry.xtext.iGES.Parameters;
import org.eclipse.january.geometry.xtext.iGES.Pointer;
import org.eclipse.january.geometry.xtext.iGES.Start;
import org.eclipse.january.geometry.xtext.services.IGESGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class IGESSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private IGESGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == IGESPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case IGESPackage.DATA:
				sequence_Data(context, (Data) semanticObject); 
				return; 
			case IGESPackage.END:
				sequence_End(context, (End) semanticObject); 
				return; 
			case IGESPackage.ENTRY:
				sequence_Entry(context, (Entry) semanticObject); 
				return; 
			case IGESPackage.GLOBAL:
				sequence_Global(context, (Global) semanticObject); 
				return; 
			case IGESPackage.HSTRING:
				if (rule == grammarAccess.getGlobalRule()) {
					sequence_Global_HString(context, (HString) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getValueRule()
						|| rule == grammarAccess.getHStringRule()) {
					sequence_HString(context, (HString) semanticObject); 
					return; 
				}
				else break;
			case IGESPackage.IGES:
				sequence_IGES(context, (IGES) semanticObject); 
				return; 
			case IGESPackage.PENTRY:
				if (rule == grammarAccess.getPEntryRule()) {
					sequence_PEntry(context, (PEntry) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPMultiEntryRule()) {
					sequence_PMultiEntry(context, (PEntry) semanticObject); 
					return; 
				}
				else break;
			case IGESPackage.PARAM:
				sequence_Param(context, (Param) semanticObject); 
				return; 
			case IGESPackage.PARAMETERS:
				sequence_Parameters(context, (Parameters) semanticObject); 
				return; 
			case IGESPackage.POINTER:
				sequence_Pointer(context, (Pointer) semanticObject); 
				return; 
			case IGESPackage.START:
				sequence_Start(context, (Start) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     Data returns Data
	 *
	 * Constraint:
	 *     entries+=Entry+
	 */
	protected void sequence_Data(ISerializationContext context, Data semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     End returns End
	 *
	 * Constraint:
	 *     (sval=INT gval=INT dval=INT pval=INT tval=INT)
	 */
	protected void sequence_End(ISerializationContext context, End semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.END__SVAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.END__SVAL));
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.END__GVAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.END__GVAL));
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.END__DVAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.END__DVAL));
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.END__PVAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.END__PVAL));
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.END__TVAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.END__TVAL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEndAccess().getSvalINTTerminalRuleCall_2_0(), semanticObject.getSval());
		feeder.accept(grammarAccess.getEndAccess().getGvalINTTerminalRuleCall_5_0(), semanticObject.getGval());
		feeder.accept(grammarAccess.getEndAccess().getDvalINTTerminalRuleCall_8_0(), semanticObject.getDval());
		feeder.accept(grammarAccess.getEndAccess().getPvalINTTerminalRuleCall_11_0(), semanticObject.getPval());
		feeder.accept(grammarAccess.getEndAccess().getTvalINTTerminalRuleCall_15_0(), semanticObject.getTval());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Entry returns Entry
	 *
	 * Constraint:
	 *     (
	 *         type=INT 
	 *         paramData=INT 
	 *         structure=INT 
	 *         lineFont=INT 
	 *         level=INT 
	 *         view=INT 
	 *         TransformMatrix=INT 
	 *         status=INT 
	 *         index=INT 
	 *         lineWeight=INT 
	 *         color=INT 
	 *         paramLines=INT 
	 *         form=INT 
	 *         entityLabel=STRING? 
	 *         subNum=INT?
	 *     )
	 */
	protected void sequence_Entry(ISerializationContext context, Entry semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Global returns Global
	 *
	 * Constraint:
	 *     (values+=Value+ values+=Value*)
	 */
	protected void sequence_Global(ISerializationContext context, Global semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Global returns HString
	 *
	 * Constraint:
	 *     (val=HOLLERITH values+=Value+ values+=Value*)
	 */
	protected void sequence_Global_HString(ISerializationContext context, HString semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Value returns HString
	 *     HString returns HString
	 *
	 * Constraint:
	 *     val=HOLLERITH
	 */
	protected void sequence_HString(ISerializationContext context, HString semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.HSTRING__VAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.HSTRING__VAL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getHStringAccess().getValHOLLERITHTerminalRuleCall_0_0(), semanticObject.getVal());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     IGES returns IGES
	 *
	 * Constraint:
	 *     (start=Start global=Global data=Data parameters=Parameters end=End)
	 */
	protected void sequence_IGES(ISerializationContext context, IGES semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.IGES__START) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.IGES__START));
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.IGES__GLOBAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.IGES__GLOBAL));
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.IGES__DATA) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.IGES__DATA));
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.IGES__PARAMETERS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.IGES__PARAMETERS));
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.IGES__END) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.IGES__END));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIGESAccess().getStartStartParserRuleCall_0_0(), semanticObject.getStart());
		feeder.accept(grammarAccess.getIGESAccess().getGlobalGlobalParserRuleCall_1_0(), semanticObject.getGlobal());
		feeder.accept(grammarAccess.getIGESAccess().getDataDataParserRuleCall_2_0(), semanticObject.getData());
		feeder.accept(grammarAccess.getIGESAccess().getParametersParametersParserRuleCall_3_0(), semanticObject.getParameters());
		feeder.accept(grammarAccess.getIGESAccess().getEndEndParserRuleCall_4_0(), semanticObject.getEnd());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     PEntry returns PEntry
	 *
	 * Constraint:
	 *     (type=INT values+=Value* dIndex=INT indicies+=INT)
	 */
	protected void sequence_PEntry(ISerializationContext context, PEntry semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PMultiEntry returns PEntry
	 *
	 * Constraint:
	 *     (type=INT (values+=Value* dIndex=INT indicies+=INT)+ values+=Value*)
	 */
	protected void sequence_PMultiEntry(ISerializationContext context, PEntry semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Value returns Param
	 *     Param returns Param
	 *
	 * Constraint:
	 *     val=DOUBLE
	 */
	protected void sequence_Param(ISerializationContext context, Param semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.PARAM__VAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.PARAM__VAL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getParamAccess().getValDOUBLETerminalRuleCall_0_0(), semanticObject.getVal());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Parameters returns Parameters
	 *
	 * Constraint:
	 *     (entries+=PMultiEntry | entries+=PEntry)+
	 */
	protected void sequence_Parameters(ISerializationContext context, Parameters semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Value returns Pointer
	 *     Pointer returns Pointer
	 *
	 * Constraint:
	 *     val=INT
	 */
	protected void sequence_Pointer(ISerializationContext context, Pointer semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, IGESPackage.Literals.POINTER__VAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, IGESPackage.Literals.POINTER__VAL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getPointerAccess().getValINTTerminalRuleCall_0_0(), semanticObject.getVal());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Start returns Start
	 *
	 * Constraint:
	 *     lines+=startLine+
	 */
	protected void sequence_Start(ISerializationContext context, Start semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
