/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.LinearAlgebra;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.metadata.Dirtiable;
import org.eclipse.january.metadata.MetadataType;

public class Stats {
    private static QStatisticsImpl<?> calcQuartileStats(Dataset a) {
        Dataset s = null;
        int is = a.getElementsPerItem();
        if (is == 1) {
            s = DatasetUtils.sort(a);
            QStatisticsImpl<Double> qstats = new QStatisticsImpl<Double>();
            qstats.setQuantile(QStatisticsImpl.Q1, Stats.pQuantile(s, QStatisticsImpl.Q1));
            qstats.setQuantile(QStatisticsImpl.Q2, Stats.pQuantile(s, QStatisticsImpl.Q2));
            qstats.setQuantile(QStatisticsImpl.Q3, Stats.pQuantile(s, QStatisticsImpl.Q3));
            qstats.s = new ReferencedDataset(s);
            return qstats;
        }
        QStatisticsImpl<double[]> qstats = new QStatisticsImpl<double[]>();
        Object w = DatasetFactory.zeros(1, a.getClass(), a.getShapeRef());
        double[] q1 = new double[is];
        double[] q2 = new double[is];
        double[] q3 = new double[is];
        qstats.setQuantile(QStatisticsImpl.Q1, q1);
        qstats.setQuantile(QStatisticsImpl.Q2, q2);
        qstats.setQuantile(QStatisticsImpl.Q3, q3);
        int j = 0;
        while (j < is) {
            ((CompoundDataset)a).copyElements((Dataset)w, j);
            w.sort(null);
            q1[j] = Stats.pQuantile(w, QStatisticsImpl.Q1);
            q2[j] = Stats.pQuantile(w, QStatisticsImpl.Q2);
            q3[j] = Stats.pQuantile(w, QStatisticsImpl.Q3);
            if (j == 0) {
                s = w.clone();
            }
            ++j;
        }
        qstats.s = new ReferencedDataset(s);
        return qstats;
    }

    private static QStatisticsImpl<?> getQStatistics(Dataset a) {
        QStatisticsImpl<?> m = (QStatisticsImpl<?>)a.getFirstMetadata(QStatisticsImpl.class);
        if (m == null || ((QStatisticsImpl)m).isDirty) {
            m = Stats.calcQuartileStats(a);
            a.setMetadata(m);
        }
        return m;
    }

    private static QStatisticsImpl<?> getQStatistics(Dataset a, int axis) {
        axis = a.checkAxis(axis);
        int is = a.getElementsPerItem();
        QStatisticsImpl qstats = (QStatisticsImpl)a.getFirstMetadata(QStatisticsImpl.class);
        if (qstats == null || qstats.isDirty) {
            qstats = is == 1 ? new QStatisticsImpl() : new QStatisticsImpl();
            a.setMetadata(qstats);
        }
        if (qstats.getQuantile(axis, QStatisticsImpl.Q2) == null) {
            if (is == 1) {
                Dataset s = DatasetUtils.sort(a, axis);
                qstats.setQuantile(axis, QStatisticsImpl.Q1, Stats.pQuantile(s, axis, QStatisticsImpl.Q1));
                qstats.setQuantile(axis, QStatisticsImpl.Q2, Stats.pQuantile(s, axis, QStatisticsImpl.Q2));
                qstats.setQuantile(axis, QStatisticsImpl.Q3, Stats.pQuantile(s, axis, QStatisticsImpl.Q3));
                qstats.setSortedDataset(axis, s);
            } else {
                Object w = DatasetFactory.zeros(1, a.getClass(), a.getShapeRef());
                CompoundDoubleDataset q1 = null;
                CompoundDoubleDataset q2 = null;
                CompoundDoubleDataset q3 = null;
                int j = 0;
                while (j < is) {
                    ((CompoundDataset)a).copyElements((Dataset)w, j);
                    w.sort(axis);
                    Dataset c = Stats.pQuantile(w, axis, QStatisticsImpl.Q1);
                    if (j == 0) {
                        q1 = DatasetFactory.zeros(is, CompoundDoubleDataset.class, c.getShapeRef());
                        q2 = DatasetFactory.zeros(is, CompoundDoubleDataset.class, c.getShapeRef());
                        q3 = DatasetFactory.zeros(is, CompoundDoubleDataset.class, c.getShapeRef());
                    }
                    q1.setElements(c, j);
                    q2.setElements(Stats.pQuantile(w, axis, QStatisticsImpl.Q2), j);
                    q3.setElements(Stats.pQuantile(w, axis, QStatisticsImpl.Q3), j);
                    ++j;
                }
                qstats.setQuantile(axis, QStatisticsImpl.Q1, q1);
                qstats.setQuantile(axis, QStatisticsImpl.Q2, q2);
                qstats.setQuantile(axis, QStatisticsImpl.Q3, q3);
            }
        }
        return qstats;
    }

    private static double pQuantile(Dataset s, double q) {
        double f = (double)(s.getSize() - 1) * q;
        if (f < 0.0) {
            return Double.NaN;
        }
        int qpt = (int)Math.floor(f);
        f -= (double)qpt;
        double quantile = s.getElementDoubleAbs(qpt);
        if (f > 0.0) {
            quantile = (1.0 - f) * quantile + f * s.getElementDoubleAbs(qpt + 1);
        }
        return quantile;
    }

    private static Dataset pQuantile(Dataset s, int axis, double q) {
        int rank = s.getRank();
        int is = s.getElementsPerItem();
        int[] oshape = s.getShape();
        double f = (double)(oshape[axis] - 1) * q;
        int qpt = (int)Math.floor(f);
        f -= (double)qpt;
        oshape[axis] = 1;
        int[] qshape = ShapeUtils.squeezeShape(oshape, false);
        CompoundDoubleDataset qds = DatasetFactory.zeros(is, CompoundDoubleDataset.class, qshape);
        IndexIterator qiter = qds.getIterator(true);
        int[] qpos = qiter.getPos();
        int[] spos = oshape;
        while (qiter.hasNext()) {
            int i = 0;
            while (i < axis) {
                spos[i] = qpos[i];
                ++i;
            }
            spos[i++] = qpt;
            while (i < rank) {
                spos[i] = qpos[i - 1];
                ++i;
            }
            Object obj = s.getObject(spos);
            qds.set(obj, qpos);
        }
        if (f > 0.0) {
            qiter = qds.getIterator(true);
            qpos = qiter.getPos();
            ++qpt;
            CompoundDoubleDataset rds = DatasetFactory.zeros(is, CompoundDoubleDataset.class, qshape);
            while (qiter.hasNext()) {
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = qpt;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                Object obj = s.getObject(spos);
                rds.set(obj, qpos);
            }
            rds.imultiply(f);
            qds.imultiply(1.0 - f);
            qds.iadd(rds);
        }
        return qds;
    }

    public static double quantile(Dataset a, double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("Quantile requested is outside [0,1]");
        }
        QStatisticsImpl<?> qs = Stats.getQStatistics(a);
        Double qv = (Double)qs.getQuantile(q);
        if (qv == null) {
            qv = Stats.pQuantile((Dataset)qs.s.get(), q);
            qs.setQuantile(q, qv);
        }
        return qv;
    }

    public static double[] quantile(Dataset a, double ... values) {
        double[] points = new double[values.length];
        QStatisticsImpl<?> qs = Stats.getQStatistics(a);
        int i = 0;
        while (i < points.length) {
            double q = values[i];
            if (q < 0.0 || q > 1.0) {
                throw new IllegalArgumentException("Quantile requested is outside [0,1]");
            }
            Double qv = (Double)qs.getQuantile(q);
            if (qv == null) {
                qv = Stats.pQuantile((Dataset)qs.s.get(), q);
                qs.setQuantile(q, qv);
            }
            points[i] = qv;
            ++i;
        }
        return points;
    }

    public static Dataset[] quantile(Dataset a, int axis, double ... values) {
        Dataset[] points = new Dataset[values.length];
        int is = a.getElementsPerItem();
        if (is == 1) {
            QStatisticsImpl<?> qs = Stats.getQStatistics(a, axis);
            int i = 0;
            while (i < points.length) {
                double q = values[i];
                if (q < 0.0 || q > 1.0) {
                    throw new IllegalArgumentException("Quantile requested is outside [0,1]");
                }
                Dataset qv = qs.getQuantile(axis, q);
                if (qv == null) {
                    qv = Stats.pQuantile(qs.getSortedDataset(axis), axis, q);
                    qs.setQuantile(axis, q, qv);
                }
                points[i] = qv;
                ++i;
            }
        } else {
            QStatisticsImpl<?> qs = Stats.getQStatistics(a);
            Object w = DatasetFactory.zeros(1, a.getClass(), a.getShapeRef());
            int j = 0;
            while (j < is) {
                boolean copied = false;
                int i = 0;
                while (i < points.length) {
                    double q = values[i];
                    if (q < 0.0 || q > 1.0) {
                        throw new IllegalArgumentException("Quantile requested is outside [0,1]");
                    }
                    Dataset qv = qs.getQuantile(axis, q);
                    if (qv == null) {
                        if (!copied) {
                            copied = true;
                            ((CompoundDataset)a).copyElements((Dataset)w, j);
                            w.sort(axis);
                        }
                        qv = Stats.pQuantile(w, axis, q);
                        qs.setQuantile(axis, q, qv);
                        if (j == 0) {
                            points[i] = DatasetFactory.zeros(is, qv.getClass(), qv.getShapeRef());
                        }
                        ((CompoundDoubleDataset)points[i]).setElements(qv, j);
                    }
                    ++i;
                }
                ++j;
            }
        }
        return points;
    }

    public static Dataset median(Dataset a, int axis) {
        return Stats.getQStatistics(a, axis).getQuantile(axis, QStatisticsImpl.Q2);
    }

    public static Object median(Dataset a) {
        return Stats.getQStatistics(a).getQuantile(QStatisticsImpl.Q2);
    }

    public static Object iqr(Dataset a) {
        int is = a.getElementsPerItem();
        if (is == 1) {
            QStatisticsImpl<?> qs = Stats.getQStatistics(a);
            return (Double)qs.getQuantile(QStatisticsImpl.Q3) - (Double)qs.getQuantile(QStatisticsImpl.Q1);
        }
        QStatisticsImpl<?> qs = Stats.getQStatistics(a);
        double[] q1 = (double[])qs.getQuantile(QStatisticsImpl.Q1);
        double[] q3 = (double[])((double[])qs.getQuantile(QStatisticsImpl.Q3)).clone();
        int j = 0;
        while (j < is) {
            int n = j;
            q3[n] = q3[n] - q1[j];
            ++j;
        }
        return q3;
    }

    public static Dataset iqr(Dataset a, int axis) {
        QStatisticsImpl<?> qs = Stats.getQStatistics(a, axis);
        Dataset q3 = qs.getQuantile(axis, QStatisticsImpl.Q3);
        return Maths.subtract(q3, qs.getQuantile(axis, QStatisticsImpl.Q1));
    }

    private static HigherStatisticsImpl<?> getHigherStatistic(Dataset a, boolean[] ignoreInvalids) {
        HigherStatisticsImpl<?> stats;
        boolean ignoreNaNs = false;
        boolean ignoreInfs = false;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            boolean bl = ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        }
        if ((stats = (HigherStatisticsImpl<?>)a.getFirstMetadata(HigherStatisticsImpl.class)) == null || ((HigherStatisticsImpl)stats).isDirty) {
            stats = Stats.calculateHigherMoments(a, ignoreNaNs, ignoreInfs);
            a.setMetadata(stats);
        }
        return stats;
    }

    private static HigherStatisticsImpl<?> getHigherStatistic(Dataset a, boolean[] ignoreInvalids, int axis) {
        boolean ignoreNaNs = false;
        boolean ignoreInfs = false;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        }
        axis = a.checkAxis(axis);
        HigherStatisticsImpl<?> stats = (HigherStatisticsImpl<?>)a.getFirstMetadata(HigherStatisticsImpl.class);
        if (stats == null || stats.getSkewness(axis) == null || ((HigherStatisticsImpl)stats).isDirty) {
            stats = Stats.calculateHigherMoments(a, ignoreNaNs, ignoreInfs, axis);
            a.setMetadata(stats);
        }
        return stats;
    }

    /*
     * Unable to fully structure code
     */
    private static HigherStatisticsImpl<?> calculateHigherMoments(Dataset a, boolean ignoreNaNs, boolean ignoreInfs) {
        block12: {
            block10: {
                block11: {
                    is = a.getElementsPerItem();
                    iter = a.getIterator();
                    if (is != 1) break block10;
                    s = new Skewness();
                    k = new Kurtosis();
                    if (!ignoreNaNs) ** GOTO lbl17
                    while (iter.hasNext()) {
                        x = a.getElementDoubleAbs(iter.index);
                        if (Double.isNaN(x)) continue;
                        s.increment(x);
                        k.increment(x);
                    }
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        x = a.getElementDoubleAbs(iter.index);
                        s.increment(x);
                        k.increment(x);
lbl17:
                        // 2 sources

                        ** while (iter.hasNext())
                    }
                }
                stats = new HigherStatisticsImpl<T>();
                stats.skewness = s.getResult();
                stats.kurtosis = k.getResult();
                return stats;
            }
            s = new Skewness[is];
            k = new Kurtosis[is];
            j = 0;
            while (j < is) {
                s[j] = new Skewness();
                k[j] = new Kurtosis();
                ++j;
            }
            if (!ignoreNaNs) ** GOTO lbl59
            while (iter.hasNext()) {
                skip = false;
                j = 0;
                while (j < is) {
                    if (Double.isNaN(a.getElementDoubleAbs(iter.index + j))) {
                        skip = true;
                        break;
                    }
                    ++j;
                }
                if (skip) continue;
                j = 0;
                while (j < is) {
                    val = a.getElementDoubleAbs(iter.index + j);
                    s[j].increment(val);
                    k[j].increment(val);
                    ++j;
                }
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                j = 0;
                while (j < is) {
                    val = a.getElementDoubleAbs(iter.index + j);
                    s[j].increment(val);
                    k[j].increment(val);
                    ++j;
                }
lbl59:
                // 2 sources

                ** while (iter.hasNext())
            }
        }
        ts = new double[is];
        tk = new double[is];
        j = 0;
        while (j < is) {
            ts[j] = s[j].getResult();
            tk[j] = k[j].getResult();
            ++j;
        }
        stats = new HigherStatisticsImpl<T>();
        stats.skewness = (T)ts;
        stats.kurtosis = (T)tk;
        return stats;
    }

    private static HigherStatisticsImpl<?> calculateHigherMoments(Dataset a, boolean ignoreNaNs, boolean ignoreInfs, int axis) {
        AbstractDataset ku;
        AbstractDataset sk;
        int rank = a.getRank();
        int is = a.getElementsPerItem();
        int[] oshape = a.getShape();
        int alen = oshape[axis];
        oshape[axis] = 1;
        int[] nshape = ShapeUtils.squeezeShape(oshape, false);
        HigherStatisticsImpl stats = null;
        if (is == 1) {
            if (stats == null) {
                stats = new HigherStatisticsImpl();
                a.setMetadata(stats);
            }
            sk = DatasetFactory.zeros(DoubleDataset.class, nshape);
            ku = DatasetFactory.zeros(DoubleDataset.class, nshape);
            IndexIterator qiter = sk.getIterator(true);
            int[] qpos = qiter.getPos();
            int[] spos = oshape;
            while (qiter.hasNext()) {
                double val;
                int j;
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = 0;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                Skewness s = new Skewness();
                Kurtosis k = new Kurtosis();
                if (ignoreNaNs) {
                    j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        val = a.getDouble(spos);
                        if (!Double.isNaN(val)) {
                            s.increment(val);
                            k.increment(val);
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < alen) {
                        spos[axis] = j++;
                        val = a.getDouble(spos);
                        s.increment(val);
                        k.increment(val);
                    }
                }
                sk.set((Object)s.getResult(), qpos);
                ku.set((Object)k.getResult(), qpos);
            }
        } else {
            if (stats == null) {
                stats = new HigherStatisticsImpl();
                a.setMetadata(stats);
            }
            sk = DatasetFactory.zeros(is, CompoundDoubleDataset.class, nshape);
            ku = DatasetFactory.zeros(is, CompoundDoubleDataset.class, nshape);
            IndexIterator qiter = sk.getIterator(true);
            int[] qpos = qiter.getPos();
            int[] spos = oshape;
            Skewness[] s = new Skewness[is];
            Kurtosis[] k = new Kurtosis[is];
            double[] ts = new double[is];
            double[] tk = new double[is];
            int j = 0;
            while (j < is) {
                s[j] = new Skewness();
                k[j] = new Kurtosis();
                ++j;
            }
            while (qiter.hasNext()) {
                int j2;
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = 0;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                int j3 = 0;
                while (j3 < is) {
                    s[j3].clear();
                    k[j3].clear();
                    ++j3;
                }
                int index = a.get1DIndex(spos);
                if (ignoreNaNs) {
                    boolean skip = false;
                    int j4 = 0;
                    while (j4 < is) {
                        if (Double.isNaN(a.getElementDoubleAbs(index + j4))) {
                            skip = true;
                            break;
                        }
                        ++j4;
                    }
                    if (!skip) {
                        j4 = 0;
                        while (j4 < is) {
                            double val = a.getElementDoubleAbs(index + j4);
                            s[j4].increment(val);
                            k[j4].increment(val);
                            ++j4;
                        }
                    }
                } else {
                    j2 = 0;
                    while (j2 < is) {
                        double val = a.getElementDoubleAbs(index + j2);
                        s[j2].increment(val);
                        k[j2].increment(val);
                        ++j2;
                    }
                }
                j2 = 0;
                while (j2 < is) {
                    ts[j2] = s[j2].getResult();
                    tk[j2] = k[j2].getResult();
                    ++j2;
                }
                sk.set((Object)ts, qpos);
                ku.set((Object)tk, qpos);
            }
        }
        stats.setSkewness(axis, sk);
        stats.setKurtosis(axis, ku);
        return stats;
    }

    public static Object skewness(Dataset a, boolean ... ignoreInvalids) {
        return Stats.getHigherStatistic((Dataset)a, (boolean[])ignoreInvalids).skewness;
    }

    public static Object kurtosis(Dataset a, boolean ... ignoreInvalids) {
        return Stats.getHigherStatistic((Dataset)a, (boolean[])ignoreInvalids).kurtosis;
    }

    public static Dataset skewness(Dataset a, int axis, boolean ... ignoreInvalids) {
        return Stats.getHigherStatistic(a, ignoreInvalids, axis).getSkewness(axis);
    }

    public static Dataset kurtosis(Dataset a, int axis, boolean ... ignoreInvalids) {
        return Stats.getHigherStatistic(a, ignoreInvalids, axis).getKurtosis(axis);
    }

    public static Object sum(Dataset a, boolean ... ignoreInvalids) {
        return a.sum(ignoreInvalids);
    }

    public static Object typedSum(Dataset a, int dtype, boolean ... ignoreInvalids) {
        if (a.isComplex()) {
            Complex m = (Complex)a.sum(ignoreInvalids);
            return m;
        }
        if (a instanceof CompoundDataset) {
            return DTypeUtils.fromDoublesToBiggestPrimitives((double[])a.sum(ignoreInvalids), dtype);
        }
        return DTypeUtils.fromDoubleToBiggestNumber(DTypeUtils.toReal(a.sum(ignoreInvalids)), dtype);
    }

    public static Dataset typedSum(Dataset a, int dtype, int axis, boolean ... ignoreInvalids) {
        return DatasetUtils.cast(a.sum(axis, ignoreInvalids), dtype);
    }

    public static Object product(Dataset a, boolean ... ignoreInvalids) {
        return Stats.typedProduct(a, a.getDType(), ignoreInvalids);
    }

    public static Dataset product(Dataset a, int axis, boolean ... ignoreInvalids) {
        return Stats.typedProduct(a, a.getDType(), axis, ignoreInvalids);
    }

    public static Object typedProduct(Dataset a, int dtype, boolean ... ignoreInvalids) {
        boolean ignoreInfs;
        boolean ignoreNaNs;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        } else {
            ignoreNaNs = false;
            ignoreInfs = false;
        }
        if (a.isComplex()) {
            IndexIterator it = a.getIterator();
            double rv = 1.0;
            double iv = 0.0;
            while (it.hasNext()) {
                double r1 = a.getElementDoubleAbs(it.index);
                double i1 = a.getElementDoubleAbs(it.index + 1);
                if (ignoreNaNs && (Double.isNaN(r1) || Double.isNaN(i1)) || ignoreInfs && (Double.isInfinite(r1) || Double.isInfinite(i1))) continue;
                double tv = r1 * rv - i1 * iv;
                iv = r1 * iv + i1 * rv;
                rv = tv;
                if (Double.isNaN(rv) && Double.isNaN(iv)) break;
            }
            return new Complex(rv, iv);
        }
        IndexIterator it = a.getIterator();
        switch (dtype) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                long lresult = 1L;
                while (it.hasNext()) {
                    lresult *= a.getElementLongAbs(it.index);
                }
                return new Long(lresult);
            }
            case 100: 
            case 200: 
            case 300: 
            case 400: {
                long lresult = 1L;
                int is = a.getElementsPerItem();
                long[] lresults = new long[is];
                int j = 0;
                while (j < is) {
                    lresults[j] = 1L;
                    ++j;
                }
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        int n = j;
                        lresults[n] = lresults[n] * a.getElementLongAbs(it.index + j);
                        ++j;
                    }
                }
                return lresults;
            }
            case 5: 
            case 6: {
                double dresult = 1.0;
                while (it.hasNext()) {
                    double x = a.getElementDoubleAbs(it.index);
                    if (!(ignoreNaNs && Double.isNaN(x) || ignoreInfs && Double.isInfinite(x)) && Double.isNaN(dresult *= x)) break;
                }
                return dresult;
            }
            case 500: 
            case 600: {
                int is = a.getElementsPerItem();
                double[] vals = new double[is];
                double[] dresults = new double[is];
                int j = 0;
                while (j < is) {
                    dresults[j] = 1.0;
                    ++j;
                }
                while (it.hasNext()) {
                    double val;
                    boolean okay = true;
                    int j2 = 0;
                    while (j2 < is) {
                        val = a.getElementDoubleAbs(it.index + j2);
                        if (ignoreNaNs && Double.isNaN(val)) {
                            okay = false;
                            break;
                        }
                        if (ignoreInfs && Double.isInfinite(val)) {
                            okay = false;
                            break;
                        }
                        vals[j2] = val;
                        ++j2;
                    }
                    if (!okay) continue;
                    j2 = 0;
                    while (j2 < is) {
                        val = vals[j2];
                        int n = j2++;
                        dresults[n] = dresults[n] * val;
                    }
                }
                return dresults;
            }
        }
        return null;
    }

    public static Dataset typedProduct(Dataset a, int dtype, int axis, boolean ... ignoreInvalids) {
        boolean ignoreInfs;
        boolean ignoreNaNs;
        axis = a.checkAxis(axis);
        int[] oshape = a.getShape();
        int is = a.getElementsPerItem();
        int alen = oshape[axis];
        oshape[axis] = 1;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        } else {
            ignoreNaNs = false;
            ignoreInfs = false;
        }
        Dataset result = DatasetFactory.zeros(is, oshape, dtype);
        IndexIterator qiter = result.getIterator(true);
        int[] qpos = qiter.getPos();
        while (qiter.hasNext()) {
            int[] spos = (int[])qpos.clone();
            if (a.isComplex()) {
                double rv = 1.0;
                double iv = 0.0;
                block0 : switch (dtype) {
                    case 7: {
                        ComplexFloatDataset af = (ComplexFloatDataset)a;
                        int j = 0;
                        while (j < alen) {
                            spos[axis] = j;
                            float r1 = af.getReal(spos);
                            float i1 = af.getImag(spos);
                            if (!(ignoreNaNs && (Float.isNaN(r1) || Float.isNaN(i1)) || ignoreInfs && (Float.isInfinite(r1) || Float.isInfinite(i1)))) {
                                double tv = (double)r1 * rv - (double)i1 * iv;
                                iv = (double)r1 * iv + (double)i1 * rv;
                                rv = tv;
                                if (Double.isNaN(rv) && Double.isNaN(iv)) break block0;
                            }
                            ++j;
                        }
                        break;
                    }
                    case 8: {
                        ComplexDoubleDataset ad = (ComplexDoubleDataset)a;
                        int j = 0;
                        while (j < alen) {
                            spos[axis] = j;
                            double r1 = ad.getReal(spos);
                            double i1 = ad.getImag(spos);
                            if (!(ignoreNaNs && (Double.isNaN(r1) || Double.isNaN(i1)) || ignoreInfs && (Double.isInfinite(r1) || Double.isInfinite(i1)))) {
                                double tv = r1 * rv - i1 * iv;
                                iv = r1 * iv + i1 * rv;
                                rv = tv;
                                if (Double.isNaN(rv) && Double.isNaN(iv)) break block0;
                            }
                            ++j;
                        }
                        break;
                    }
                }
                result.set((Object)new Complex(rv, iv), qpos);
                continue;
            }
            switch (dtype) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    long lresult = 1L;
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j++;
                        lresult *= (long)a.getInt(spos);
                    }
                    result.set((Object)lresult, qpos);
                    break;
                }
                case 100: {
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        byte[] va = (byte[])a.getObject(spos);
                        int k2 = 0;
                        while (k2 < is) {
                            int n = k2;
                            lresults[n] = lresults[n] * (long)va[k2];
                            ++k2;
                        }
                        ++j;
                    }
                    result.set((Object)lresults, qpos);
                    break;
                }
                case 200: {
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        short[] va = (short[])a.getObject(spos);
                        int k3 = 0;
                        while (k3 < is) {
                            int n = k3;
                            lresults[n] = lresults[n] * (long)va[k3];
                            ++k3;
                        }
                        ++j;
                    }
                    result.set((Object)lresults, qpos);
                    break;
                }
                case 300: {
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        int[] va = (int[])a.getObject(spos);
                        int k4 = 0;
                        while (k4 < is) {
                            int n = k4;
                            lresults[n] = lresults[n] * (long)va[k4];
                            ++k4;
                        }
                        ++j;
                    }
                    result.set((Object)lresults, qpos);
                    break;
                }
                case 400: {
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        long[] va = (long[])a.getObject(spos);
                        int k5 = 0;
                        while (k5 < is) {
                            int n = k5;
                            lresults[n] = lresults[n] * va[k5];
                            ++k5;
                        }
                        ++j;
                    }
                    result.set((Object)lresults, qpos);
                    break;
                }
                case 5: 
                case 6: {
                    double dresult = 1.0;
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        double x = a.getDouble(spos);
                        if (!(ignoreNaNs && Double.isNaN(x) || ignoreInfs && Double.isInfinite(x) || !Double.isNaN(dresult *= x))) break;
                        ++j;
                    }
                    result.set((Object)dresult, qpos);
                    break;
                }
                case 500: 
                case 600: {
                    CompoundDataset da = (CompoundDataset)a;
                    double[] dvalues = new double[is];
                    double[] dresults = new double[is];
                    int k = 0;
                    while (k < is) {
                        dresults[k] = 1.0;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        da.getDoubleArray(dvalues, spos);
                        boolean okay = true;
                        int k6 = 0;
                        while (k6 < is) {
                            double val = dvalues[k6];
                            if (ignoreNaNs && Double.isNaN(val)) {
                                okay = false;
                                break;
                            }
                            if (ignoreInfs && Double.isInfinite(val)) {
                                okay = false;
                                break;
                            }
                            ++k6;
                        }
                        if (okay) {
                            k6 = 0;
                            while (k6 < is) {
                                int n = k6;
                                dresults[n] = dresults[n] * dvalues[k6];
                                ++k6;
                            }
                        }
                        ++j;
                    }
                    result.set((Object)dresults, qpos);
                }
            }
        }
        result.setShape(ShapeUtils.squeezeShape(oshape, axis));
        return result;
    }

    public static Dataset cumulativeProduct(Dataset a, boolean ... ignoreInvalids) {
        return Stats.cumulativeProduct(a.flatten(), 0, ignoreInvalids);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset cumulativeProduct(Dataset a, int axis, boolean ... ignoreInvalids) {
        axis = a.checkAxis(axis);
        dtype = a.getDType();
        oshape = a.getShape();
        alen = oshape[axis];
        oshape[axis] = 1;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        } else {
            ignoreNaNs = false;
            ignoreInfs = false;
        }
        result = DatasetFactory.zeros(a);
        pi = result.getPositionIterator(new int[]{axis});
        pos = pi.getPos();
        block13: while (pi.hasNext()) {
            block48: {
                if (!a.isComplex()) break block48;
                rv = 1.0;
                iv = 0.0;
                switch (dtype) {
                    case 7: {
                        af = (ComplexFloatDataset)a;
                        rf = (ComplexFloatDataset)result;
                        j = 0;
                        while (j < alen) {
                            if (Double.isNaN(rv) && Double.isNaN(iv)) ** GOTO lbl33
                            pos[axis] = j;
                            r1 = af.getReal(pos);
                            i1 = af.getImag(pos);
                            if (ignoreNaNs && (Float.isNaN(r1) || Float.isNaN(i1)) || ignoreInfs && (Float.isInfinite(r1) || Float.isInfinite(i1))) ** GOTO lbl34
                            tv = (double)r1 * rv - (double)i1 * iv;
                            iv = (double)r1 * iv + (double)i1 * rv;
                            rv = tv;
lbl33:
                            // 2 sources

                            rf.set((float)rv, (float)iv, pos);
lbl34:
                            // 2 sources

                            ++j;
                        }
                        continue block13;
                    }
                    case 8: {
                        ad = (ComplexDoubleDataset)a;
                        rd = (ComplexDoubleDataset)result;
                        j = 0;
                        while (j < alen) {
                            if (Double.isNaN(rv) && Double.isNaN(iv)) ** GOTO lbl50
                            pos[axis] = j;
                            r1 = ad.getReal(pos);
                            i1 = ad.getImag(pos);
                            if (ignoreNaNs && (Double.isNaN(r1) || Double.isNaN(i1)) || ignoreInfs && (Double.isInfinite(r1) || Double.isInfinite(i1))) ** GOTO lbl51
                            tv = r1 * rv - i1 * iv;
                            iv = r1 * iv + i1 * rv;
                            rv = tv;
lbl50:
                            // 2 sources

                            rd.set(rv, iv, pos);
lbl51:
                            // 2 sources

                            ++j;
                        }
                        break block0;
                    }
                }
                continue;
            }
            switch (dtype) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    lresult = 1L;
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j++;
                        result.set((Object)(lresult *= (long)a.getInt(pos)), pos);
                    }
                    continue block13;
                }
                case 100: {
                    is = a.getElementsPerItem();
                    lresults = new long[is];
                    k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (byte[])a.getObject(pos);
                        k = 0;
                        while (k < is) {
                            v0 = k;
                            lresults[v0] = lresults[v0] * (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block13;
                }
                case 200: {
                    is = a.getElementsPerItem();
                    lresults = new long[is];
                    k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (short[])a.getObject(pos);
                        k = 0;
                        while (k < is) {
                            v1 = k;
                            lresults[v1] = lresults[v1] * (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block13;
                }
                case 300: {
                    is = a.getElementsPerItem();
                    lresults = new long[is];
                    k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (int[])a.getObject(pos);
                        k = 0;
                        while (k < is) {
                            v2 = k;
                            lresults[v2] = lresults[v2] * (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block13;
                }
                case 400: {
                    is = a.getElementsPerItem();
                    lresults = new long[is];
                    k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (long[])a.getObject(pos);
                        k = 0;
                        while (k < is) {
                            v3 = k;
                            lresults[v3] = lresults[v3] * va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block13;
                }
                case 5: 
                case 6: {
                    dresult = 1.0;
                    j = 0;
                    while (j < alen) {
                        if (Double.isNaN(dresult)) ** GOTO lbl161
                        pos[axis] = j;
                        x = a.getDouble(pos);
                        if (ignoreNaNs && Double.isNaN(x) || ignoreInfs && Double.isInfinite(x)) ** GOTO lbl162
                        dresult *= x;
lbl161:
                        // 2 sources

                        result.set((Object)dresult, pos);
lbl162:
                        // 2 sources

                        ++j;
                    }
                    continue block13;
                }
                case 500: 
                case 600: {
                    is = a.getElementsPerItem();
                    da = (CompoundDataset)a;
                    dvalues = new double[is];
                    dresults = new double[is];
                    k = 0;
                    while (k < is) {
                        dresults[k] = 1.0;
                        ++k;
                    }
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        da.getDoubleArray(dvalues, pos);
                        okay = true;
                        k = 0;
                        while (k < is) {
                            val = dvalues[k];
                            if (ignoreNaNs && Double.isNaN(val)) {
                                okay = false;
                                break;
                            }
                            if (ignoreInfs && Double.isInfinite(val)) {
                                okay = false;
                                break;
                            }
                            ++k;
                        }
                        if (okay) {
                            k = 0;
                            while (k < is) {
                                v4 = k;
                                dresults[v4] = dresults[v4] * dvalues[k];
                                ++k;
                            }
                        }
                        result.set((Object)dresults, pos);
                        ++j;
                    }
                    continue block13;
                }
            }
        }
        return result;
    }

    public static Dataset cumulativeSum(Dataset a, boolean ... ignoreInvalids) {
        return Stats.cumulativeSum(a.flatten(), 0, ignoreInvalids);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset cumulativeSum(Dataset a, int axis, boolean ... ignoreInvalids) {
        axis = a.checkAxis(axis);
        dtype = a.getDType();
        oshape = a.getShape();
        alen = oshape[axis];
        oshape[axis] = 1;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        } else {
            ignoreNaNs = false;
            ignoreInfs = false;
        }
        result = DatasetFactory.zeros(a);
        pi = result.getPositionIterator(new int[]{axis});
        pos = pi.getPos();
        block13: while (pi.hasNext()) {
            block43: {
                if (!a.isComplex()) break block43;
                rv = 0.0;
                iv = 0.0;
                switch (dtype) {
                    case 7: {
                        af = (ComplexFloatDataset)a;
                        rf = (ComplexFloatDataset)result;
                        j = 0;
                        while (j < alen) {
                            if (Double.isNaN(rv) && Double.isNaN(iv)) ** GOTO lbl32
                            pos[axis] = j;
                            r1 = af.getReal(pos);
                            i1 = af.getImag(pos);
                            if (ignoreNaNs && (Float.isNaN(r1) || Float.isNaN(i1)) || ignoreInfs && (Float.isInfinite(r1) || Float.isInfinite(i1))) ** GOTO lbl33
                            rv += (double)r1;
                            iv += (double)i1;
lbl32:
                            // 2 sources

                            rf.set((float)rv, (float)iv, pos);
lbl33:
                            // 2 sources

                            ++j;
                        }
                        continue block13;
                    }
                    case 8: {
                        ad = (ComplexDoubleDataset)a;
                        rd = (ComplexDoubleDataset)result;
                        j = 0;
                        while (j < alen) {
                            if (Double.isNaN(rv) && Double.isNaN(iv)) ** GOTO lbl48
                            pos[axis] = j;
                            r1 = ad.getReal(pos);
                            i1 = ad.getImag(pos);
                            if (ignoreNaNs && (Double.isNaN(r1) || Double.isNaN(i1)) || ignoreInfs && (Double.isInfinite(r1) || Double.isInfinite(i1))) ** GOTO lbl49
                            rv += r1;
                            iv += i1;
lbl48:
                            // 2 sources

                            rd.set(rv, iv, pos);
lbl49:
                            // 2 sources

                            ++j;
                        }
                        break block0;
                    }
                }
                continue;
            }
            switch (dtype) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    lresult = 0L;
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j++;
                        result.set((Object)(lresult += (long)a.getInt(pos)), pos);
                    }
                    continue block13;
                }
                case 100: {
                    is = a.getElementsPerItem();
                    lresults = new long[is];
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (byte[])a.getObject(pos);
                        k = 0;
                        while (k < is) {
                            v0 = k;
                            lresults[v0] = lresults[v0] + (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block13;
                }
                case 200: {
                    is = a.getElementsPerItem();
                    lresults = new long[is];
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (short[])a.getObject(pos);
                        k = 0;
                        while (k < is) {
                            v1 = k;
                            lresults[v1] = lresults[v1] + (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block13;
                }
                case 300: {
                    is = a.getElementsPerItem();
                    lresults = new long[is];
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (int[])a.getObject(pos);
                        k = 0;
                        while (k < is) {
                            v2 = k;
                            lresults[v2] = lresults[v2] + (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block13;
                }
                case 400: {
                    is = a.getElementsPerItem();
                    lresults = new long[is];
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (long[])a.getObject(pos);
                        k = 0;
                        while (k < is) {
                            v3 = k;
                            lresults[v3] = lresults[v3] + va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block13;
                }
                case 5: 
                case 6: {
                    dresult = 0.0;
                    j = 0;
                    while (j < alen) {
                        if (Double.isNaN(dresult)) ** GOTO lbl139
                        pos[axis] = j;
                        x = a.getDouble(pos);
                        if (ignoreNaNs && Double.isNaN(x) || ignoreInfs && Double.isInfinite(x)) ** GOTO lbl140
                        dresult += x;
lbl139:
                        // 2 sources

                        result.set((Object)dresult, pos);
lbl140:
                        // 2 sources

                        ++j;
                    }
                    continue block13;
                }
                case 500: 
                case 600: {
                    is = a.getElementsPerItem();
                    da = (CompoundDataset)a;
                    dvalues = new double[is];
                    dresults = new double[is];
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        da.getDoubleArray(dvalues, pos);
                        okay = true;
                        k = 0;
                        while (k < is) {
                            val = dvalues[k];
                            if (ignoreNaNs && Double.isNaN(val)) {
                                okay = false;
                                break;
                            }
                            if (ignoreInfs && Double.isInfinite(val)) {
                                okay = false;
                                break;
                            }
                            ++k;
                        }
                        if (okay) {
                            k = 0;
                            while (k < is) {
                                v4 = k;
                                dresults[v4] = dresults[v4] + dvalues[k];
                                ++k;
                            }
                        }
                        result.set((Object)dresults, pos);
                        ++j;
                    }
                    continue block13;
                }
            }
        }
        return result;
    }

    public static Object averageDeviation(Dataset a) {
        IndexIterator it = a.getIterator();
        int is = a.getElementsPerItem();
        if (is == 1) {
            double mean = (Double)a.mean(new boolean[0]);
            double sum = 0.0;
            while (it.hasNext()) {
                sum += Math.abs(a.getElementDoubleAbs(it.index) - mean);
            }
            return sum / (double)a.getSize();
        }
        double[] means = (double[])a.mean(new boolean[0]);
        double[] sums = new double[is];
        while (it.hasNext()) {
            int j = 0;
            while (j < is) {
                int n = j;
                sums[n] = sums[n] + Math.abs(a.getElementDoubleAbs(it.index + j) - means[j]);
                ++j;
            }
        }
        double n = a.getSize();
        int j = 0;
        while (j < is) {
            int n2 = j++;
            sums[n2] = sums[n2] / n;
        }
        return sums;
    }

    public static double residual(Dataset a, Dataset b) {
        return a.residual(b);
    }

    public static double weightedResidual(Dataset a, Dataset b, Dataset w) {
        return a.residual(b, w, false);
    }

    public static double[] outlierValues(Dataset a, double lo, double hi, int length) {
        if (lo <= 0.0 || hi <= 0.0 || lo >= hi || hi >= 100.0 || Double.isNaN(lo) || Double.isNaN(hi)) {
            throw new IllegalArgumentException("Thresholds must be between (0,100) and in order");
        }
        int size = a.getSize();
        int nl = Math.max((int)(lo * (double)size / 100.0), 1);
        if (length > 0 && nl > length) {
            nl = length;
        }
        int nh = Math.max((int)((100.0 - hi) * (double)size / 100.0), 1);
        if (length > 0 && nh > length) {
            nh = length;
        }
        double[] results = Math.max(nl, nh) > 640 ? Stats.outlierValuesMap(a, nl, nh) : Stats.outlierValuesList(a, nl, nh);
        results[2] = results[2] * 100.0 / (double)size;
        results[3] = 100.0 - results[3] * 100.0 / (double)size;
        return results;
    }

    static double[] outlierValuesMap(Dataset a, int nl, int nh) {
        double hx;
        TreeMap<Double, Integer> lMap = new TreeMap<Double, Integer>();
        TreeMap<Double, Integer> hMap = new TreeMap<Double, Integer>();
        int ml = 0;
        int mh = 0;
        IndexIterator it = a.getIterator();
        while (it.hasNext()) {
            Integer i;
            Double k;
            Double x = a.getElementDoubleAbs(it.index);
            if (ml == nl) {
                k = (Double)lMap.lastKey();
                if (x < k) {
                    i = (Integer)lMap.get(k) - 1;
                    if (i == 0) {
                        lMap.remove(k);
                    } else {
                        lMap.put(k, i);
                    }
                    i = (Integer)lMap.get(x);
                    if (i == null) {
                        lMap.put(x, 1);
                    } else {
                        lMap.put(x, i + 1);
                    }
                }
            } else {
                i = (Integer)lMap.get(x);
                if (i == null) {
                    lMap.put(x, 1);
                } else {
                    lMap.put(x, i + 1);
                }
                ++ml;
            }
            if (mh == nh) {
                k = (Double)hMap.firstKey();
                if (!(x > k)) continue;
                i = (Integer)hMap.get(k) - 1;
                if (i == 0) {
                    hMap.remove(k);
                } else {
                    hMap.put(k, i);
                }
                i = (Integer)hMap.get(x);
                if (i == null) {
                    hMap.put(x, 1);
                    continue;
                }
                hMap.put(x, i + 1);
                continue;
            }
            i = (Integer)hMap.get(x);
            if (i == null) {
                hMap.put(x, 1);
            } else {
                hMap.put(x, i + 1);
            }
            ++mh;
        }
        double lx = (Double)lMap.lastKey();
        if (lx >= (hx = ((Double)hMap.firstKey()).doubleValue())) {
            Double h = hMap.higherKey(lx);
            if (h != null) {
                hx = h;
                --mh;
            } else {
                Double l = lMap.lowerKey(hx);
                if (l != null) {
                    lx = l;
                    --ml;
                }
            }
        }
        return new double[]{(Double)lMap.lastKey(), (Double)hMap.firstKey(), ml, mh};
    }

    static double[] outlierValuesList(Dataset a, int nl, int nh) {
        ArrayList<Double> lList = new ArrayList<Double>(nl);
        ArrayList<Double> hList = new ArrayList<Double>(nh);
        double lx = Double.POSITIVE_INFINITY;
        double hx = Double.NEGATIVE_INFINITY;
        IndexIterator it = a.getIterator();
        while (it.hasNext()) {
            double x = a.getElementDoubleAbs(it.index);
            if (x < lx) {
                if (lList.size() == nl) {
                    lList.remove(lx);
                }
                lList.add(x);
                lx = (Double)Collections.max(lList);
            } else if (x == lx && lList.size() < nl) {
                lList.add(x);
            }
            if (x > hx) {
                if (hList.size() == nh) {
                    hList.remove(hx);
                }
                hList.add(x);
                hx = (Double)Collections.min(hList);
                continue;
            }
            if (x != hx || hList.size() >= nh) continue;
            hList.add(x);
        }
        nl = lList.size();
        nh = hList.size();
        if (lx >= hx) {
            Collections.sort(hList);
            Iterator iterator = hList.iterator();
            while (iterator.hasNext()) {
                double h = (Double)iterator.next();
                if (h > hx) {
                    hx = h;
                    break;
                }
                --nh;
            }
            if (lx >= hx) {
                Collections.sort(lList);
                Collections.reverse(lList);
                iterator = lList.iterator();
                while (iterator.hasNext()) {
                    double l = (Double)iterator.next();
                    if (l < lx) {
                        lx = l;
                        break;
                    }
                    --nl;
                }
            }
        }
        return new double[]{lx, hx, nl, nh};
    }

    public static Dataset covariance(Dataset a) {
        return Stats.covariance(a, true, false, null);
    }

    public static Dataset covariance(Dataset a, boolean rowvar, boolean bias, Integer ddof) {
        return Stats.covariance(a, null, rowvar, bias, ddof);
    }

    public static Dataset covariance(Dataset a, Dataset b) {
        return Stats.covariance(a, b, true, false, null);
    }

    public static Dataset covariance(Dataset a, Dataset b, boolean rowvar, boolean bias, Integer ddof) {
        double norm_fact;
        int axis;
        int nr;
        Dataset vars = a.clone();
        if (a.getRank() == 1) {
            vars.setShape(1, a.getShape()[0]);
        }
        if (vars.getShape()[0] == 1) {
            rowvar = true;
        }
        if (rowvar) {
            nr = vars.getShape()[1];
            axis = 0;
        } else {
            nr = vars.getShape()[0];
            axis = 1;
        }
        if (ddof == null) {
            ddof = !bias ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        if ((norm_fact = (double)(nr - ddof)) <= 0.0) {
            norm_fact = 0.0;
        }
        if (b != null) {
            Dataset extraVars = b.clone();
            if (b.getRank() == 1) {
                extraVars.setShape(1, a.getShape()[0]);
            }
            vars = DatasetUtils.concatenate(new Dataset[]{vars, extraVars}, axis);
        }
        Dataset varsMean = vars.mean(1 - axis, false);
        int[] meanShape = vars.getShape();
        meanShape[1 - axis] = 1;
        varsMean.setShape(meanShape);
        vars.isubtract(varsMean);
        Dataset cov = rowvar ? Maths.divide(LinearAlgebra.dotProduct(vars, Maths.conjugate(vars.transpose(new int[0]))), norm_fact).squeeze() : Maths.divide(LinearAlgebra.dotProduct(vars.transpose(new int[0]), Maths.conjugate(vars)), norm_fact).squeeze();
        return cov;
    }

    private static class HigherStatisticsImpl<T>
    implements MetadataType {
        private static final long serialVersionUID = -6587974784104116792L;
        T skewness;
        T kurtosis;
        transient Map<Integer, ReferencedDataset> smap = new HashMap<Integer, ReferencedDataset>();
        transient Map<Integer, ReferencedDataset> kmap = new HashMap<Integer, ReferencedDataset>();
        @Dirtiable
        private boolean isDirty = true;

        @Override
        public HigherStatisticsImpl<T> clone() {
            return new HigherStatisticsImpl<T>(this);
        }

        public HigherStatisticsImpl() {
        }

        private HigherStatisticsImpl(HigherStatisticsImpl<T> hstats) {
            this.skewness = hstats.skewness;
            this.kurtosis = hstats.kurtosis;
            this.smap.putAll(hstats.smap);
            this.kmap.putAll(hstats.kmap);
            this.isDirty = hstats.isDirty;
        }

        public Dataset getSkewness(int axis) {
            ReferencedDataset rd = this.smap.get(axis);
            return rd == null ? null : (Dataset)rd.get();
        }

        public Dataset getKurtosis(int axis) {
            ReferencedDataset rd = this.kmap.get(axis);
            return rd == null ? null : (Dataset)rd.get();
        }

        public void setSkewness(int axis, Dataset s) {
            this.smap.put(axis, new ReferencedDataset(s));
        }

        public void setKurtosis(int axis, Dataset k) {
            this.kmap.put(axis, new ReferencedDataset(k));
        }
    }

    private static class QStatisticsImpl<T>
    implements MetadataType {
        private static final long serialVersionUID = -3296671666463190388L;
        static final Double Q1 = 0.25;
        static final Double Q2 = 0.5;
        static final Double Q3 = 0.75;
        Map<Double, T> qmap = new HashMap<Double, T>();
        transient Map<Integer, Map<Double, ReferencedDataset>> aqmap = new HashMap<Integer, Map<Double, ReferencedDataset>>();
        transient ReferencedDataset s;
        transient Map<Integer, ReferencedDataset> smap = new HashMap<Integer, ReferencedDataset>();
        @Dirtiable
        private boolean isDirty = true;

        @Override
        public QStatisticsImpl<T> clone() {
            return new QStatisticsImpl<T>(this);
        }

        public QStatisticsImpl() {
        }

        private QStatisticsImpl(QStatisticsImpl<T> qstats) {
            if (qstats.s != null && qstats.s.get() != null) {
                this.s = new ReferencedDataset(((Dataset)qstats.s.get()).getView(false));
            }
            this.qmap.putAll(qstats.qmap);
            for (Integer i : qstats.aqmap.keySet()) {
                this.aqmap.put(i, new HashMap<Double, ReferencedDataset>(qstats.aqmap.get(i)));
            }
            this.smap.putAll(qstats.smap);
            this.isDirty = qstats.isDirty;
        }

        public void setQuantile(double q, T v) {
            this.qmap.put(q, v);
        }

        public T getQuantile(double q) {
            return this.qmap.get(q);
        }

        private Map<Double, ReferencedDataset> getMap(int axis) {
            Map<Double, ReferencedDataset> qm = this.aqmap.get(axis);
            if (qm == null) {
                qm = new HashMap<Double, ReferencedDataset>();
                this.aqmap.put(axis, qm);
            }
            return qm;
        }

        public void setQuantile(int axis, double q, Dataset v) {
            Map<Double, ReferencedDataset> qm = this.getMap(axis);
            qm.put(q, new ReferencedDataset(v));
        }

        public Dataset getQuantile(int axis, double q) {
            Map<Double, ReferencedDataset> qm = this.getMap(axis);
            ReferencedDataset rd = qm.get(q);
            return rd == null ? null : (Dataset)rd.get();
        }

        Dataset getSortedDataset(int axis) {
            return this.smap.containsKey(axis) ? (Dataset)this.smap.get(axis).get() : null;
        }

        void setSortedDataset(int axis, Dataset v) {
            this.smap.put(axis, new ReferencedDataset(v));
        }
    }

    private static class ReferencedDataset
    extends SoftReference<Dataset> {
        public ReferencedDataset(Dataset d) {
            super(d);
        }
    }
}

