/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.junit.Assert;
import org.junit.Test;

public class UnsignedArithmeticsTest {
    static final int MAX = 256;

    @Test
    public void testAdd() {
        byte[] results = new byte[65536];
        int k = 0;
        int i = 0;
        while (i < 256) {
            byte bi = (byte)i;
            int j = 0;
            while (j < 256) {
                byte bj = (byte)j;
                bj = (byte)(bj + bi);
                results[k++] = bj;
                ++j;
            }
            ++i;
        }
        k = 0;
        i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 256) {
                Assert.assertEquals((String)String.format("%d + %d: ", j, i), (long)(0xFF & j + i), (long)(0xFF & results[k++]));
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testSub() {
        byte[] results = new byte[65536];
        int k = 0;
        int i = 0;
        while (i < 256) {
            byte bi = (byte)i;
            int j = 0;
            while (j < 256) {
                byte bj = (byte)j;
                bj = (byte)(bj - bi);
                results[k++] = bj;
                ++j;
            }
            ++i;
        }
        k = 0;
        i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 256) {
                Assert.assertEquals((String)String.format("%d - %d: ", j, i), (long)(0xFF & j - i), (long)(0xFF & results[k++]));
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testMul() {
        byte[] results = new byte[65536];
        int k = 0;
        int i = 0;
        while (i < 256) {
            byte bi = (byte)i;
            int j = 0;
            while (j < 256) {
                byte bj = (byte)j;
                bj = (byte)(bj * bi);
                results[k++] = bj;
                ++j;
            }
            ++i;
        }
        k = 0;
        i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 256) {
                Assert.assertEquals((String)String.format("%d * %d: ", j, i), (long)(0xFF & j * i), (long)(0xFF & results[k++]));
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testDiv() {
        byte[] results = new byte[65280];
        int k = 0;
        int i = 1;
        while (i < 256) {
            byte bi = (byte)i;
            int j = 0;
            while (j < 256) {
                byte bj = (byte)j;
                results[k++] = UnsignedArithmeticsTest.divide(bj, bi);
                ++j;
            }
            ++i;
        }
        k = 0;
        i = 1;
        while (i < 256) {
            int j = 0;
            while (j < 256) {
                Assert.assertEquals((String)String.format("%d / %d: ", j, i), (long)(0xFF & j / i), (long)(0xFF & results[k++]));
                ++j;
            }
            ++i;
        }
    }

    public static byte divide(byte num, byte den) {
        if (den == 0) {
            throw new ArithmeticException("/ by zero");
        }
        byte q = num;
        byte r = 0;
        int i = 0;
        while (i < 8) {
            r = (byte)(r << 1);
            if (q < 0) {
                r = (byte)(r + 1);
            }
            q = (byte)(q << 1);
            if (!UnsignedArithmeticsTest.lessThan(r, den)) {
                q = (byte)(q + 1);
                r = (byte)(r - den);
            }
            ++i;
        }
        return q;
    }

    public static boolean lessThan(byte x, byte y) {
        return x < y ^ (x < 0 ^ y < 0);
    }

    @Test
    public void testTruncate() {
        double d = 9.0458382169E10;
        System.err.println("Double is " + d);
        System.err.println("Long is " + (long)d);
        System.err.println("Int is " + (int)d);
        System.err.println("Short is " + (short)d);
        System.err.println("Byte from double is " + (byte)d);
        System.err.println("Byte from long is " + (byte)d);
        System.err.println("Byte from int is " + (byte)d);
        System.err.println("Byte from short is " + (byte)d);
    }
}

