/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IsCompletelySelected;
import org.eclipse.jdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class DeleteModifications
extends RefactoringModifications {
    private List<IJavaElement> fDelete = new ArrayList<IJavaElement>();
    private Set<IPackageFragment> fPackagesToDelete = new LinkedHashSet<IPackageFragment>();

    public void delete(IResource resource) {
        this.getResourceModifications().addDelete(resource);
    }

    public void delete(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.delete(resource);
            ++n2;
        }
    }

    public void delete(IJavaElement[] elements) throws CoreException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            this.delete(element);
            ++n2;
        }
    }

    public void delete(IJavaElement element) throws CoreException {
        switch (element.getElementType()) {
            case 1: {
                return;
            }
            case 2: {
                this.fDelete.add(element);
                if (element.getResource() != null) {
                    this.getResourceModifications().addDelete(element.getResource());
                }
                return;
            }
            case 3: {
                this.fDelete.add(element);
                IResource resource = element.getResource();
                if (resource != null) {
                    this.getResourceModifications().addDelete(resource);
                }
                IJavaProject[] iJavaProjectArray = JavaElementUtil.getReferencingProjects((IPackageFragmentRoot)element);
                int n = iJavaProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject referencingProject = iJavaProjectArray[n2];
                    IFile classpath = referencingProject.getProject().getFile(".classpath");
                    this.getResourceModifications().addChanged(classpath);
                    ++n2;
                }
                return;
            }
            case 4: {
                this.fDelete.add(element);
                this.fPackagesToDelete.add((IPackageFragment)element);
                return;
            }
            case 5: {
                this.fDelete.add(element);
                IType[] types = ((ICompilationUnit)element).getTypes();
                this.fDelete.addAll(Arrays.asList(types));
                if (element.getResource() != null) {
                    this.getResourceModifications().addDelete(element.getResource());
                }
                return;
            }
        }
        this.fDelete.add(element);
    }

    public List<IResource> postProcess() throws CoreException {
        return this.postProcess((IProgressMonitor)new NullProgressMonitor());
    }

    public List<IResource> postProcess(IProgressMonitor monitor) throws CoreException {
        String taskName = RefactoringCoreMessages.DeleteRefactoring_progress_collecting_resources;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)this.fPackagesToDelete.size());
        IsCompletelySelected isCompletelySelected = new IsCompletelySelected(this.fPackagesToDelete, (IProgressMonitor)subMonitor);
        ArrayList<IResource> resourcesCollector = new ArrayList<IResource>();
        for (IPackageFragment pack : this.fPackagesToDelete) {
            subMonitor.checkCanceled();
            this.handlePackageFragmentDelete(pack, resourcesCollector, isCompletelySelected);
            subMonitor.worked(1);
        }
        return resourcesCollector;
    }

    @Override
    public void buildDelta(IResourceChangeDescriptionFactory deltaFactory) {
        this.getResourceModifications().buildDelta(deltaFactory);
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (IJavaElement javaElement : this.fDelete) {
            result.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, (Object)javaElement, (DeleteArguments)new DeleteArguments(), (String[])natures, (SharableParticipants)shared)));
        }
        result.addAll(Arrays.asList(this.getResourceModifications().getParticipants(status, owner, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void handlePackageFragmentDelete(IPackageFragment pack, ArrayList<IResource> resourcesCollector, IsCompletelySelected isCompletelySelected) throws CoreException {
        block11: {
            IResource[] members;
            block10: {
                IContainer container = (IContainer)pack.getResource();
                if (container == null) {
                    return;
                }
                members = container.members();
                if (pack.isDefaultPackage() || !isCompletelySelected.test(pack)) break block10;
                boolean parentIsMarked = false;
                IPackageFragment parent = JavaElementUtil.getParentSubpackage(pack);
                parentIsMarked = parent == null ? false : this.fPackagesToDelete.contains(parent);
                if (parentIsMarked) {
                    if (!isCompletelySelected.test(parent)) {
                        resourcesCollector.add((IResource)container);
                        this.getResourceModifications().addDelete((IResource)container);
                    }
                } else {
                    resourcesCollector.add((IResource)container);
                    this.getResourceModifications().addDelete((IResource)container);
                }
                break block11;
            }
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    IPackageFragment frag;
                    IResource member;
                    block12: {
                        member = iResourceArray[n2];
                        if (!(member instanceof IFile)) break block12;
                        IFile file = (IFile)member;
                        if ("class".equals(file.getFileExtension()) && file.isDerived() || pack.isDefaultPackage() && !JavaCore.isJavaLikeFileName((String)file.getName())) break block13;
                        resourcesCollector.add(member);
                        this.getResourceModifications().addDelete(member);
                    }
                    if (!pack.isDefaultPackage() && member instanceof IFolder && (frag = (IPackageFragment)JavaCore.create((IResource)member)) == null) {
                        resourcesCollector.add(member);
                        this.getResourceModifications().addDelete(member);
                    }
                }
                ++n2;
            }
        }
    }
}

