/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import org.eclipse.core.runtime.Platform;

public class CommandLineQuoting {
    private CommandLineQuoting() {
    }

    public static String[] quoteWindowsArgs(String[] cmdLine) {
        if (Platform.OS.isWindows()) {
            String[] winCmdLine = new String[cmdLine.length];
            if (cmdLine.length > 0) {
                winCmdLine[0] = cmdLine[0];
            }
            int i = 1;
            while (i < cmdLine.length) {
                winCmdLine[i] = CommandLineQuoting.winQuote(cmdLine[i]);
                ++i;
            }
            cmdLine = winCmdLine;
        }
        return cmdLine;
    }

    static boolean needsQuoting(String s) {
        int len = s.length();
        if (len == 0) {
            return true;
        }
        if ("\"\"".equals(s)) {
            return false;
        }
        int i = 0;
        while (i < len) {
            switch (s.charAt(i)) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '\\': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String winQuote(String s) {
        if (!CommandLineQuoting.needsQuoting(s)) {
            return s;
        }
        s = s.replaceAll("([\\\\]*)\"", "$1$1\\\\\"");
        s = s.replaceAll("([\\\\]*)\\z", "$1$1");
        return "\"" + s + "\"";
    }
}

