/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.LRUMap;

public class MethodOverrideTester {
    private final IType fFocusType;
    private final ITypeHierarchy fHierarchy;
    private Map<IMethod, Substitutions> fMethodSubstitutions;
    private Map<IType, Substitutions> fTypeVariableSubstitutions;

    public MethodOverrideTester(IType focusType, ITypeHierarchy hierarchy) {
        if (focusType == null || hierarchy == null) {
            throw new IllegalArgumentException();
        }
        this.fFocusType = focusType;
        this.fHierarchy = hierarchy;
        this.fTypeVariableSubstitutions = null;
        this.fMethodSubstitutions = null;
    }

    public IType getFocusType() {
        return this.fFocusType;
    }

    public ITypeHierarchy getTypeHierarchy() {
        return this.fHierarchy;
    }

    public IMethod findDeclaringMethod(IMethod overriding, boolean testVisibility) throws JavaModelException {
        IMethod result = null;
        IMethod overridden = this.findOverriddenMethod(overriding, testVisibility);
        while (overridden != null) {
            result = overridden;
            overridden = this.findOverriddenMethod(result, testVisibility);
        }
        return result;
    }

    public IMethod findOverriddenMethod(IMethod overriding, boolean testVisibility) throws JavaModelException {
        IMethod res;
        int flags = overriding.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || overriding.isConstructor()) {
            return null;
        }
        IType type = overriding.getDeclaringType();
        IType superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null && (res = this.findOverriddenMethodInHierarchy(superClass, overriding)) != null && (!testVisibility || JavaModelUtil.isVisibleInHierarchy((IMember)res, type.getPackageFragment()))) {
            return res;
        }
        IType[] iTypeArray = this.fHierarchy.getSuperInterfaces(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType intf = iTypeArray[n2];
            IMethod res2 = this.findOverriddenMethodInHierarchy(intf, overriding);
            if (res2 != null) {
                return res2;
            }
            ++n2;
        }
        return null;
    }

    public IMethod findOverriddenMethodInHierarchy(IType type, IMethod overriding) throws JavaModelException {
        return this.findOverriddenMethodInHierarchy(type, overriding, new HashSet<IType>());
    }

    private IMethod findOverriddenMethodInHierarchy(IType type, IMethod overriding, Set<IType> visitedTypes) throws JavaModelException {
        IMethod res;
        if (!visitedTypes.add(type)) {
            return null;
        }
        IMethod method = this.findOverriddenMethodInType(type, overriding);
        if (method != null) {
            return method;
        }
        IType superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null && (res = this.findOverriddenMethodInHierarchy(superClass, overriding, visitedTypes)) != null) {
            return res;
        }
        IType[] iTypeArray = this.fHierarchy.getSuperInterfaces(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType superInterface = iTypeArray[n2];
            IMethod res2 = this.findOverriddenMethodInHierarchy(superInterface, overriding, visitedTypes);
            if (res2 != null) {
                return res2;
            }
            ++n2;
        }
        return method;
    }

    public Set<IMethod> findAllOverriddenMethodsInHierarchy(IType type, IMethod overriding) throws JavaModelException {
        Set<IMethod> ans = this.findAllOverriddenMethodsInType(type, overriding);
        IType superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null) {
            ans.addAll(this.findAllOverriddenMethodsInHierarchy(superClass, overriding));
        }
        IType[] superInterfaces = this.fHierarchy.getSuperInterfaces(type);
        int i = 0;
        while (i < superInterfaces.length) {
            ans.addAll(this.findAllOverriddenMethodsInHierarchy(superInterfaces[i], overriding));
            ++i;
        }
        return ans;
    }

    public IMethod findOverriddenMethodInType(IType overriddenType, IMethod overriding) throws JavaModelException {
        int flags = overriding.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || overriding.isConstructor()) {
            return null;
        }
        IMethod[] iMethodArray = overriddenType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod overridden = iMethodArray[n2];
            flags = overridden.getFlags();
            if (!Flags.isPrivate((int)flags) && !Flags.isStatic((int)flags) && !overridden.isConstructor() && this.isSubsignature(overriding, overridden)) {
                return overridden;
            }
            ++n2;
        }
        return null;
    }

    public Set<IMethod> findAllOverriddenMethodsInType(IType overriddenType, IMethod overriding) throws JavaModelException {
        HashSet<IMethod> ans = new HashSet<IMethod>();
        int flags = overriding.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || overriding.isConstructor()) {
            return ans;
        }
        IMethod[] overriddenMethods = overriddenType.getMethods();
        int i = 0;
        while (i < overriddenMethods.length) {
            IMethod overridden = overriddenMethods[i];
            flags = overridden.getFlags();
            if (!Flags.isPrivate((int)flags) && !Flags.isStatic((int)flags) && !overridden.isConstructor() && this.isSubsignature(overriding, overridden)) {
                ans.add(overridden);
            }
            ++i;
        }
        return ans;
    }

    public IMethod findOverridingMethodInType(IType overridingType, IMethod overridden) throws JavaModelException {
        int flags = overridden.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || overridden.isConstructor()) {
            return null;
        }
        IMethod[] iMethodArray = overridingType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod overriding = iMethodArray[n2];
            flags = overriding.getFlags();
            if (!Flags.isPrivate((int)flags) && !Flags.isStatic((int)flags) && !overriding.isConstructor() && this.isSubsignature(overriding, overridden)) {
                return overriding;
            }
            ++n2;
        }
        return null;
    }

    public boolean isSubsignature(IMethod overriding, IMethod overridden) throws JavaModelException {
        if (!overridden.getElementName().equals(overriding.getElementName())) {
            return false;
        }
        int nParameters = overridden.getNumberOfParameters();
        if (nParameters != overriding.getNumberOfParameters()) {
            return false;
        }
        if (!this.hasCompatibleTypeParameters(overriding, overridden)) {
            return false;
        }
        return nParameters == 0 || this.hasCompatibleParameterTypes(overriding, overridden);
    }

    private boolean hasCompatibleTypeParameters(IMethod overriding, IMethod overridden) throws JavaModelException {
        ITypeParameter[] overridingTypeParameters;
        int nOverridingTypeParameters;
        ITypeParameter[] overriddenTypeParameters = overridden.getTypeParameters();
        if (overriddenTypeParameters.length != (nOverridingTypeParameters = (overridingTypeParameters = overriding.getTypeParameters()).length)) {
            return nOverridingTypeParameters == 0;
        }
        Substitutions overriddenSubst = this.getMethodSubstitions(overridden);
        Substitutions overridingSubst = this.getMethodSubstitions(overriding);
        int i = 0;
        while (i < nOverridingTypeParameters) {
            String erasure1 = overriddenSubst.getErasure(overriddenTypeParameters[i].getElementName());
            String erasure2 = overridingSubst.getErasure(overridingTypeParameters[i].getElementName());
            if (erasure1 == null || !erasure1.equals(erasure2)) {
                return false;
            }
            int nBounds = overriddenTypeParameters[i].getBounds().length;
            if (nBounds > 1 && nBounds != overridingTypeParameters[i].getBounds().length) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasCompatibleParameterTypes(IMethod overriding, IMethod overridden) throws JavaModelException {
        String overridingParamName;
        String overriddenParamName;
        String overriddenParamSig;
        String[] overriddenParamTypes = overridden.getParameterTypes();
        String[] overridingParamTypes = overriding.getParameterTypes();
        String[] substitutedOverriding = new String[overridingParamTypes.length];
        boolean testErasure = false;
        int i = 0;
        while (i < overridingParamTypes.length) {
            overriddenParamSig = overriddenParamTypes[i];
            overriddenParamName = this.getSubstitutedTypeName(overriddenParamSig, (IMember)overridden);
            substitutedOverriding[i] = overridingParamName = this.getSubstitutedTypeName(overridingParamTypes[i], (IMember)overriding);
            if (!overriddenParamName.equals(overridingParamName)) {
                testErasure = true;
                break;
            }
            ++i;
        }
        if (testErasure) {
            i = 0;
            while (i < overridingParamTypes.length) {
                overriddenParamSig = overriddenParamTypes[i];
                overriddenParamName = this.getErasedTypeName(overriddenParamSig, (IMember)overridden);
                overridingParamName = substitutedOverriding[i];
                if (overridingParamName == null) {
                    overridingParamName = this.getSubstitutedTypeName(overridingParamTypes[i], (IMember)overriding);
                }
                if (!overriddenParamName.equals(overridingParamName)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private String getVariableSubstitution(IMember context, String variableName) throws JavaModelException {
        IType type;
        String subst;
        if (context instanceof IMethod) {
            subst = this.getMethodSubstitions((IMethod)context).getSubstitution(variableName);
            if (subst != null) {
                return subst;
            }
            type = context.getDeclaringType();
        } else {
            type = (IType)context;
        }
        subst = this.getTypeSubstitions(type).getSubstitution(variableName);
        if (subst != null) {
            return subst;
        }
        IJavaElement parent = type.getParent();
        if (parent instanceof IMethod) {
            return this.getVariableSubstitution((IMember)((IMethod)parent), variableName);
        }
        if (type.getDeclaringType() != null) {
            return this.getVariableSubstitution((IMember)type.getDeclaringType(), variableName);
        }
        return variableName;
    }

    private String getVariableErasure(IMember context, String variableName) throws JavaModelException {
        IType type;
        String subst;
        if (context instanceof IMethod) {
            subst = this.getMethodSubstitions((IMethod)context).getErasure(variableName);
            if (subst != null) {
                return subst;
            }
            type = context.getDeclaringType();
        } else {
            type = (IType)context;
        }
        subst = this.getTypeSubstitions(type).getErasure(variableName);
        if (subst != null) {
            return subst;
        }
        IJavaElement parent = type.getParent();
        if (parent instanceof IMethod) {
            return this.getVariableErasure((IMember)((IMethod)parent), variableName);
        }
        if (type.getDeclaringType() != null) {
            return this.getVariableErasure((IMember)type.getDeclaringType(), variableName);
        }
        return variableName;
    }

    private Substitutions getMethodSubstitions(IMethod method) throws JavaModelException {
        Substitutions s;
        if (this.fMethodSubstitutions == null) {
            this.fMethodSubstitutions = new LRUMap<IMethod, Substitutions>(3);
        }
        if ((s = this.fMethodSubstitutions.get(method)) == null) {
            ITypeParameter[] typeParameters = method.getTypeParameters();
            if (typeParameters.length == 0) {
                s = Substitutions.EMPTY_SUBST;
            } else {
                IType instantiatedType = method.getDeclaringType();
                s = new Substitutions();
                int i = 0;
                while (i < typeParameters.length) {
                    ITypeParameter curr = typeParameters[i];
                    s.addSubstitution(curr.getElementName(), "+" + String.valueOf(i), this.getTypeParameterErasure(curr, instantiatedType));
                    ++i;
                }
            }
            this.fMethodSubstitutions.put(method, s);
        }
        return s;
    }

    private Substitutions getTypeSubstitions(IType type) throws JavaModelException {
        Substitutions subst;
        if (this.fTypeVariableSubstitutions == null) {
            this.fTypeVariableSubstitutions = new HashMap<IType, Substitutions>();
            this.computeSubstitutions(this.fFocusType, null, null);
        }
        if ((subst = this.fTypeVariableSubstitutions.get(type)) == null) {
            return Substitutions.EMPTY_SUBST;
        }
        return subst;
    }

    private void computeSubstitutions(IType instantiatedType, IType instantiatingType, String[] typeArguments) throws JavaModelException {
        IType[] superInterfaces;
        String[] superInterfacesTypeSignature;
        int nInterfaces;
        Substitutions s = new Substitutions();
        this.fTypeVariableSubstitutions.put(instantiatedType, s);
        ITypeParameter[] typeParameters = instantiatedType.getTypeParameters();
        if (instantiatingType == null) {
            ITypeParameter[] iTypeParameterArray = typeParameters;
            int n = typeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                curr = iTypeParameterArray[n2];
                s.addSubstitution(curr.getElementName(), "*" + curr.getElementName(), this.getTypeParameterErasure(curr, instantiatedType));
                ++n2;
            }
        } else if (typeParameters.length == typeArguments.length) {
            int i = 0;
            while (i < typeParameters.length) {
                ITypeParameter curr = typeParameters[i];
                String substString = this.getSubstitutedTypeName(typeArguments[i], (IMember)instantiatingType);
                erasure = this.getErasedTypeName(typeArguments[i], (IMember)instantiatingType);
                s.addSubstitution(curr.getElementName(), substString, (String)erasure);
                ++i;
            }
        } else if (typeArguments.length == 0) {
            erasure = typeParameters;
            int substString = typeParameters.length;
            int curr = 0;
            while (curr < substString) {
                curr = erasure[curr];
                String erasure = this.getTypeParameterErasure(curr, instantiatedType);
                s.addSubstitution(curr.getElementName(), erasure, erasure);
                ++curr;
            }
        }
        String superclassTypeSignature = instantiatedType.getSuperclassTypeSignature();
        if (superclassTypeSignature != null) {
            String[] superTypeArguments = Signature.getTypeArguments((String)superclassTypeSignature);
            IType superclass = this.fHierarchy.getSuperclass(instantiatedType);
            if (superclass != null && !this.fTypeVariableSubstitutions.containsKey(superclass)) {
                this.computeSubstitutions(superclass, instantiatedType, superTypeArguments);
            }
        }
        if ((nInterfaces = (superInterfacesTypeSignature = instantiatedType.isAnonymous() ? new String[]{superclassTypeSignature} : instantiatedType.getSuperInterfaceTypeSignatures()).length) > 0 && (superInterfaces = this.fHierarchy.getSuperInterfaces(instantiatedType)).length == nInterfaces) {
            int i = 0;
            while (i < nInterfaces) {
                String[] superTypeArguments = Signature.getTypeArguments((String)superInterfacesTypeSignature[i]);
                IType superInterface = superInterfaces[i];
                if (!this.fTypeVariableSubstitutions.containsKey(superInterface)) {
                    this.computeSubstitutions(superInterface, instantiatedType, superTypeArguments);
                }
                ++i;
            }
        }
    }

    private String getTypeParameterErasure(ITypeParameter typeParameter, IType context) throws JavaModelException {
        String[] bounds = typeParameter.getBounds();
        if (bounds.length > 0) {
            return this.getErasedTypeName(Signature.createTypeSignature((String)bounds[0], (boolean)false), (IMember)context);
        }
        return "Object";
    }

    private String getSubstitutedTypeName(String typeSig, IMember context) throws JavaModelException {
        return this.internalGetSubstitutedTypeName(typeSig, context, false, new StringBuffer()).toString();
    }

    private String getErasedTypeName(String typeSig, IMember context) throws JavaModelException {
        return this.internalGetSubstitutedTypeName(typeSig, context, true, new StringBuffer()).toString();
    }

    private StringBuffer internalGetSubstitutedTypeName(String typeSig, IMember context, boolean erasure, StringBuffer buf) throws JavaModelException {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                return buf.append(Signature.toString((String)typeSig));
            }
            case 4: {
                this.internalGetSubstitutedTypeName(Signature.getElementType((String)typeSig), context, erasure, buf);
                int i = Signature.getArrayCount((String)typeSig);
                while (i > 0) {
                    buf.append('[').append(']');
                    --i;
                }
                return buf;
            }
            case 1: {
                String[] typeArguments;
                String erasureSig = Signature.getTypeErasure((String)typeSig);
                String erasureName = Signature.getSimpleName((String)Signature.toString((String)erasureSig));
                char ch = erasureSig.charAt(0);
                if (ch == 'L') {
                    buf.append(erasureName);
                } else if (ch == 'Q') {
                    if (erasure) {
                        buf.append(this.getVariableErasure(context, erasureName));
                    } else {
                        buf.append(this.getVariableSubstitution(context, erasureName));
                    }
                } else {
                    Assert.isTrue((boolean)false, (String)"Unknown class type signature");
                }
                if (!erasure && (typeArguments = Signature.getTypeArguments((String)typeSig)).length > 0) {
                    buf.append('<');
                    int i = 0;
                    while (i < typeArguments.length) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        this.internalGetSubstitutedTypeName(typeArguments[i], context, erasure, buf);
                        ++i;
                    }
                    buf.append('>');
                }
                return buf;
            }
            case 3: {
                String varName = Signature.toString((String)typeSig);
                if (erasure) {
                    return buf.append(this.getVariableErasure(context, varName));
                }
                return buf.append(this.getVariableSubstitution(context, varName));
            }
            case 5: {
                buf.append('?');
                char ch = typeSig.charAt(0);
                if (ch == '*') {
                    return buf;
                }
                if (ch == '+') {
                    buf.append(" extends ");
                } else {
                    buf.append(" super ");
                }
                return this.internalGetSubstitutedTypeName(typeSig.substring(1), context, erasure, buf);
            }
            case 6: {
                return this.internalGetSubstitutedTypeName(typeSig.substring(1), context, erasure, buf);
            }
        }
        Assert.isTrue((boolean)false, (String)"Unhandled type signature kind");
        return buf;
    }

    public Set<IMethod> findAllOverridenMethods(IMethod overriding) throws JavaModelException {
        return this.findAllOverriddenMethodsInHierarchy(overriding.getDeclaringType(), overriding);
    }

    private static class Substitutions {
        public static final Substitutions EMPTY_SUBST = new Substitutions();
        private HashMap<String, String[]> fMap = null;

        public void addSubstitution(String typeVariable, String substitution, String erasure) {
            if (this.fMap == null) {
                this.fMap = new HashMap(3);
            }
            this.fMap.put(typeVariable, new String[]{substitution, erasure});
        }

        private String[] getSubstArray(String typeVariable) {
            if (this.fMap != null) {
                return this.fMap.get(typeVariable);
            }
            return null;
        }

        public String getSubstitution(String typeVariable) {
            String[] subst = this.getSubstArray(typeVariable);
            if (subst != null) {
                return subst[0];
            }
            return null;
        }

        public String getErasure(String typeVariable) {
            String[] subst = this.getSubstArray(typeVariable);
            if (subst != null) {
                return subst[1];
            }
            return null;
        }
    }
}

