/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameNodeCorrectionProposalCore
extends CUCorrectionProposalCore {
    private String fNewName;
    private int fOffset;
    private int fLength;

    public RenameNodeCorrectionProposalCore(String name, ICompilationUnit cu, int offset, int length, String newName, int relevance) {
        super(name, cu, relevance);
        this.fOffset = offset;
        this.fLength = length;
        this.fNewName = newName;
    }

    @Override
    public void addEdits(IDocument doc, TextEdit root) throws CoreException {
        SimpleName[] names;
        super.addEdits(doc, root);
        CompilationUnit unit = SharedASTProviderCore.getAST((ITypeRoot)this.getCompilationUnit(), SharedASTProviderCore.WAIT_YES, null);
        ASTNode name = NodeFinder.perform((ASTNode)unit, (int)this.fOffset, (int)this.fLength);
        if (name instanceof SimpleName && (names = LinkedNodeFinder.findByProblems((ASTNode)unit, (SimpleName)name)) != null) {
            SimpleName[] simpleNameArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleName curr = simpleNameArray[n2];
                root.addChild((TextEdit)new ReplaceEdit(curr.getStartPosition(), curr.getLength(), this.fNewName));
                ++n2;
            }
            return;
        }
        root.addChild((TextEdit)new ReplaceEdit(this.fOffset, this.fLength, this.fNewName));
    }
}

