/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.BufferChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISynchronizable;

public class DocumentAdapter
implements IBuffer,
IDocumentListener {
    public static final IBuffer Null = new NullBuffer();
    private Object lock = new Object();
    private IOpenable fOwner;
    private IFile fFile;
    private boolean fIsClosed;
    private List<IBufferChangedListener> fBufferListeners;
    private ITextFileBuffer fTextFileBuffer;
    private IDocument fDocument;

    public DocumentAdapter(IOpenable owner, IFile file) {
        this.fOwner = owner;
        this.fFile = file;
        this.fBufferListeners = new ArrayList<IBufferChangedListener>(3);
        this.fIsClosed = false;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            manager.connect(file.getFullPath(), LocationKind.IFILE, null);
            this.fTextFileBuffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBufferChangedListener(IBufferChangedListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.fBufferListeners.contains(listener)) {
                this.fBufferListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeBufferChangedListener(IBufferChangedListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.fBufferListeners.remove(listener);
        }
    }

    public void append(char[] text) {
        this.append(new String(text));
    }

    public void append(String text) {
        try {
            this.fDocument.replace(this.fDocument.getLength(), 0, text);
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.fIsClosed) {
                return;
            }
            this.fIsClosed = true;
            this.fDocument.removeDocumentListener((IDocumentListener)this);
            if (this.fTextFileBuffer != null) {
                try {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    manager.disconnect(this.fFile.getFullPath(), LocationKind.NORMALIZE, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                this.fTextFileBuffer = null;
            }
            this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, 0, 0, null));
            this.fBufferListeners.clear();
            this.fDocument = null;
        }
    }

    public char getChar(int position) {
        try {
            return this.fDocument.getChar(position);
        }
        catch (BadLocationException x) {
            throw new IndexOutOfBoundsException(x.getMessage());
        }
    }

    public char[] getCharacters() {
        String content = this.getContents();
        return content != null ? content.toCharArray() : null;
    }

    public String getContents() {
        return this.fDocument != null ? this.fDocument.get() : null;
    }

    public int getLength() {
        return this.fDocument.getLength();
    }

    public IOpenable getOwner() {
        return this.fOwner;
    }

    public String getText(int offset, int length) throws IndexOutOfBoundsException {
        try {
            return this.fDocument.get(offset, length);
        }
        catch (BadLocationException x) {
            throw new IndexOutOfBoundsException(x.getMessage());
        }
    }

    public IResource getUnderlyingResource() {
        return this.fFile;
    }

    public boolean hasUnsavedChanges() {
        return this.fTextFileBuffer != null ? this.fTextFileBuffer.isDirty() : false;
    }

    public boolean isClosed() {
        return this.fIsClosed;
    }

    public boolean isReadOnly() {
        if (this.fTextFileBuffer != null) {
            return this.fTextFileBuffer.isCommitable();
        }
        ResourceAttributes attributes = this.fFile.getResourceAttributes();
        return attributes != null ? attributes.isReadOnly() : false;
    }

    public void replace(int position, int length, char[] text) {
        this.replace(position, length, new String(text));
    }

    public void replace(int position, int length, String text) {
        try {
            this.fDocument.replace(position, length, text);
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public void save(IProgressMonitor progress, boolean force) throws JavaModelException {
        try {
            if (this.fTextFileBuffer != null) {
                this.fTextFileBuffer.commit(progress, force);
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public void setContents(char[] contents) {
        this.setContents(new String(contents));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(String contents) {
        Object object = this.lock;
        synchronized (object) {
            if (this.fDocument == null) {
                if (this.fTextFileBuffer != null) {
                    this.fDocument = this.fTextFileBuffer.getDocument();
                } else {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    this.fDocument = manager.createEmptyDocument(this.fFile.getFullPath(), LocationKind.IFILE);
                }
                this.fDocument.addDocumentListener((IDocumentListener)this);
                ((ISynchronizable)this.fDocument).setLockObject(this.lock);
            }
        }
        if (!contents.equals(this.fDocument.get())) {
            this.fDocument.set(contents);
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, event.getOffset(), event.getLength(), event.getText()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBufferChanged(BufferChangedEvent event) {
        IBufferChangedListener[] listeners = null;
        Object object = this.lock;
        synchronized (object) {
            listeners = this.fBufferListeners.toArray(new IBufferChangedListener[this.fBufferListeners.size()]);
        }
        IBufferChangedListener[] iBufferChangedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IBufferChangedListener listener = iBufferChangedListenerArray[n2];
            listener.bufferChanged(event);
            ++n2;
        }
    }

    private static class NullBuffer
    implements IBuffer {
        private NullBuffer() {
        }

        public void addBufferChangedListener(IBufferChangedListener listener) {
        }

        public void append(char[] text) {
        }

        public void append(String text) {
        }

        public void close() {
        }

        public char getChar(int position) {
            return '\u0000';
        }

        public char[] getCharacters() {
            return null;
        }

        public String getContents() {
            return null;
        }

        public int getLength() {
            return 0;
        }

        public IOpenable getOwner() {
            return null;
        }

        public String getText(int offset, int length) {
            return null;
        }

        public IResource getUnderlyingResource() {
            return null;
        }

        public boolean hasUnsavedChanges() {
            return false;
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void removeBufferChangedListener(IBufferChangedListener listener) {
        }

        public void replace(int position, int length, char[] text) {
        }

        public void replace(int position, int length, String text) {
        }

        public void save(IProgressMonitor progress, boolean force) throws JavaModelException {
        }

        public void setContents(char[] contents) {
        }

        public void setContents(String contents) {
        }
    }
}

