/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class JDTUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String PERIOD = ".";
    public static final String SRC = "src";
    private static final String JDT_SCHEME = "jdt";
    private static Set<String> SILENCED_CODEGENS = Collections.singleton("lombok");

    private JDTUtils() {
    }

    public static ICompilationUnit resolveCompilationUnit(String uriString) {
        return JDTUtils.resolveCompilationUnit(JDTUtils.toURI(uriString));
    }

    public static ICompilationUnit resolveCompilationUnit(URI uri) {
        if (uri == null || JDT_SCHEME.equals(uri.getScheme()) || !uri.isAbsolute()) {
            return null;
        }
        IFile resource = (IFile)JDTUtils.findResource(uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
        if (resource != null) {
            if (!ProjectUtils.isJavaProject(resource.getProject())) {
                return null;
            }
            IJavaElement element = JavaCore.create((IFile)resource);
            if (element instanceof ICompilationUnit) {
                return (ICompilationUnit)element;
            }
        }
        if (resource == null) {
            return JDTUtils.getFakeCompilationUnit(uri, (IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }

    public static IPackageFragment resolvePackage(String uriString) {
        return JDTUtils.resolvePackage(JDTUtils.toURI(uriString));
    }

    public static IPackageFragment resolvePackage(URI uri) {
        if (uri == null || JDT_SCHEME.equals(uri.getScheme()) || !uri.isAbsolute()) {
            return null;
        }
        IFolder resource = (IFolder)JDTUtils.findResource(uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findContainersForLocationURI(arg_0));
        if (resource != null) {
            if (!ProjectUtils.isJavaProject(resource.getProject())) {
                return null;
            }
            IJavaElement element = JavaCore.create((IFolder)resource);
            if (element instanceof IPackageFragment) {
                return (IPackageFragment)element;
            }
        }
        return null;
    }

    static ICompilationUnit getFakeCompilationUnit(URI uri, IProgressMonitor monitor) {
        if (uri == null || !"file".equals(uri.getScheme()) || !uri.getPath().endsWith(".java")) {
            return null;
        }
        java.nio.file.Path path = Paths.get(uri);
        if (!Files.isReadable(path)) {
            return null;
        }
        IProject project = JavaLanguageServerPlugin.getProjectsManager().getDefaultProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String packageName = JDTUtils.getPackageName(javaProject, uri);
        String fileName = path.getName(path.getNameCount() - 1).toString();
        String packagePath = packageName.replace(PERIOD, PATH_SEPARATOR);
        IPath filePath = new Path(SRC).append(packagePath).append(fileName);
        IFile file = project.getFile(filePath);
        if (!file.isLinked()) {
            try {
                JDTUtils.createFolders(file.getParent(), monitor);
                file.createLink(uri, 256, monitor);
            }
            catch (CoreException e) {
                String errMsg = "Failed to create linked resource from " + uri + " to " + project.getName();
                JavaLanguageServerPlugin.logException(errMsg, e);
            }
        }
        if (file.isLinked()) {
            return (ICompilationUnit)JavaCore.create((IResource)file, (IJavaProject)javaProject);
        }
        return null;
    }

    public static void createFolders(IContainer folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists() && folder instanceof IFolder) {
            IContainer parent = folder.getParent();
            JDTUtils.createFolders(parent, monitor);
            folder.refreshLocal(0, monitor);
            if (!folder.exists()) {
                ((IFolder)folder).create(true, true, monitor);
            }
        }
    }

    public static String getPackageName(IJavaProject javaProject, URI uri) {
        block4: {
            try {
                File file = ResourceUtils.toFile(uri);
                String content = com.google.common.io.Files.toString((File)file, (Charset)Charsets.UTF_8);
                if (content.isEmpty() && javaProject != null && "jdt.ls-java-project".equals(javaProject.getProject().getName())) {
                    java.nio.file.Path path;
                    java.nio.file.Path parent = path = Paths.get(uri);
                    while (parent.getParent() != null && parent.getParent().getNameCount() > 0) {
                        String pathStr;
                        String name = (parent = parent.getParent()).getName(parent.getNameCount() - 1).toString();
                        if (!SRC.equals(name) || (pathStr = path.getParent().toString()).length() <= parent.toString().length()) continue;
                        pathStr = pathStr.substring(parent.toString().length() + 1);
                        pathStr = pathStr.replace(PATH_SEPARATOR, PERIOD);
                        return pathStr;
                    }
                    break block4;
                }
                return JDTUtils.getPackageName(javaProject, content);
            }
            catch (IOException e) {
                JavaLanguageServerPlugin.logException("Failed to read package name from " + uri, e);
            }
        }
        return "";
    }

    public static String getPackageName(IJavaProject javaProject, String fileContent) {
        if (fileContent == null) {
            return "";
        }
        char[] source = fileContent.toCharArray();
        ASTParser parser = ASTParser.newParser((int)9);
        parser.setProject(javaProject);
        parser.setIgnoreMethodBodies(true);
        parser.setSource(source);
        CompilationUnit ast = (CompilationUnit)parser.createAST(null);
        PackageDeclaration pkg = ast.getPackage();
        return pkg == null || pkg.getName() == null ? "" : pkg.getName().getFullyQualifiedName();
    }

    public static IClassFile resolveClassFile(String uriString) {
        return JDTUtils.resolveClassFile(JDTUtils.toURI(uriString));
    }

    public static IClassFile resolveClassFile(URI uri) {
        if (uri != null && JDT_SCHEME.equals(uri.getScheme()) && "contents".equals(uri.getAuthority())) {
            String handleId = uri.getQuery();
            IJavaElement element = JavaCore.create((String)handleId);
            IClassFile cf = (IClassFile)element.getAncestor(6);
            return cf;
        }
        return null;
    }

    public static ITypeRoot resolveTypeRoot(String uriString) {
        URI uri = JDTUtils.toURI(uriString);
        if (uri == null) {
            return null;
        }
        if (JDT_SCHEME.equals(uri.getScheme())) {
            return JDTUtils.resolveClassFile(uri);
        }
        return JDTUtils.resolveCompilationUnit(uri);
    }

    public static Location toLocation(IJavaElement element) throws JavaModelException {
        ISourceRange nameRange;
        ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
        IClassFile cf = (IClassFile)element.getAncestor(6);
        if (unit == null && cf == null) {
            return null;
        }
        if (element instanceof ISourceReference && SourceRange.isAvailable((ISourceRange)(nameRange = JDTUtils.getNameRange(element)))) {
            if (cf == null) {
                return JDTUtils.toLocation(unit, nameRange.getOffset(), nameRange.getLength());
            }
            return JDTUtils.toLocation(cf, nameRange.getOffset(), nameRange.getLength());
        }
        return null;
    }

    private static ISourceRange getNameRange(IJavaElement element) throws JavaModelException {
        ISourceRange nameRange = null;
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            nameRange = member.getNameRange();
            if (!SourceRange.isAvailable((ISourceRange)nameRange)) {
                nameRange = member.getSourceRange();
            }
        } else if (element instanceof ITypeParameter || element instanceof ILocalVariable) {
            nameRange = ((ISourceReference)element).getNameRange();
        } else if (element instanceof ISourceReference) {
            nameRange = ((ISourceReference)element).getSourceRange();
        }
        if (!SourceRange.isAvailable((ISourceRange)nameRange) && element.getParent() != null) {
            nameRange = JDTUtils.getNameRange(element.getParent());
        }
        return nameRange;
    }

    public static Location toLocation(ICompilationUnit unit, int offset, int length) throws JavaModelException {
        return new Location(ResourceUtils.toClientUri(JDTUtils.toURI(unit)), JDTUtils.toRange((IOpenable)unit, offset, length));
    }

    public static Location toLocation(IClassFile classFile) throws JavaModelException {
        return JDTUtils.toLocation(classFile, 0, 0);
    }

    public static Location toLocation(String uri) {
        return new Location(ResourceUtils.toClientUri(uri), JDTUtils.newRange());
    }

    public static Location toLocation(IClassFile classFile, int offset, int length) throws JavaModelException {
        String uriString = JDTUtils.toUri(classFile);
        if (uriString != null) {
            Range range = JDTUtils.toRange((IOpenable)classFile, offset, length);
            return new Location(uriString, range);
        }
        return null;
    }

    public static String toUri(IClassFile classFile) {
        String packageName = classFile.getParent().getElementName();
        String jarName = classFile.getParent().getParent().getElementName();
        String uriString = null;
        try {
            uriString = new URI(JDT_SCHEME, "contents", PATH_SEPARATOR + jarName + PATH_SEPARATOR + packageName + PATH_SEPARATOR + classFile.getElementName(), classFile.getHandleIdentifier(), null).toASCIIString();
        }
        catch (URISyntaxException e) {
            JavaLanguageServerPlugin.logException("Error generating URI for class ", e);
        }
        return uriString;
    }

    public static String toUri(ITypeRoot typeRoot) {
        if (typeRoot instanceof ICompilationUnit) {
            return JDTUtils.toURI((ICompilationUnit)typeRoot);
        }
        if (typeRoot instanceof IClassFile) {
            return JDTUtils.toUri((IClassFile)typeRoot);
        }
        return null;
    }

    public static Range toRange(IOpenable openable, int offset, int length) throws JavaModelException {
        Range range = JDTUtils.newRange();
        if (offset > 0 || length > 0) {
            int[] loc = null;
            int[] endLoc = null;
            IBuffer buffer = openable.getBuffer();
            if (buffer != null) {
                loc = JsonRpcHelpers.toLine(buffer, offset);
                endLoc = JsonRpcHelpers.toLine(buffer, offset + length);
            }
            if (loc == null) {
                loc = new int[2];
            }
            if (endLoc == null) {
                endLoc = new int[2];
            }
            JDTUtils.setPosition(range.getStart(), loc);
            JDTUtils.setPosition(range.getEnd(), endLoc);
        }
        return range;
    }

    public static Range newRange() {
        return new Range(new Position(), new Position());
    }

    private static void setPosition(Position position, int[] coords) {
        assert (coords.length == 2);
        position.setLine(coords[0]);
        position.setCharacter(coords[1]);
    }

    @Deprecated
    public static String getFileURI(ICompilationUnit cu) {
        return JDTUtils.toURI(cu);
    }

    public static String toURI(ICompilationUnit cu) {
        return JDTUtils.getFileURI(cu.getResource());
    }

    public static String getFileURI(IResource resource) {
        return ResourceUtils.fixURI(resource.getRawLocationURI());
    }

    public static IJavaElement findElementAtSelection(ITypeRoot unit, int line, int column, PreferenceManager preferenceManager, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] elements = JDTUtils.findElementsAtSelection(unit, line, column, preferenceManager, monitor);
        if (elements != null && elements.length == 1) {
            return elements[0];
        }
        return null;
    }

    public static IJavaElement[] findElementsAtSelection(ITypeRoot unit, int line, int column, PreferenceManager preferenceManager, IProgressMonitor monitor) throws JavaModelException {
        block7: {
            if (unit == null) {
                return null;
            }
            int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), line, column);
            if (offset > -1) {
                return unit.codeSelect(offset, 0);
            }
            if (unit instanceof IClassFile) {
                IClassFile classFile = (IClassFile)unit;
                ContentProviderManager contentProvider = JavaLanguageServerPlugin.getContentProviderManager();
                String contents = contentProvider.getSource(classFile, monitor);
                if (contents != null) {
                    String name;
                    block8: {
                        Document document = new Document(contents);
                        offset = document.getLineOffset(line) + column;
                        if (offset <= -1) break block7;
                        name = JDTUtils.parse(contents, offset);
                        if (name != null) break block8;
                        return null;
                    }
                    try {
                        SearchPattern pattern = SearchPattern.createPattern((String)name, (int)0, (int)0, (int)64);
                        IJavaSearchScope scope = JDTUtils.createSearchScope(unit.getJavaProject());
                        final ArrayList elements = new ArrayList();
                        SearchRequestor requestor = new SearchRequestor(){

                            public void acceptSearchMatch(SearchMatch match) {
                                if (match.getElement() instanceof IJavaElement) {
                                    elements.add((IJavaElement)match.getElement());
                                }
                            }
                        };
                        SearchEngine searchEngine = new SearchEngine();
                        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
                        return elements.toArray(new IJavaElement[0]);
                    }
                    catch (CoreException | BadLocationException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                }
            }
        }
        return null;
    }

    private static String parse(String contents, int offset) {
        if (contents == null || offset < 0 || contents.length() < offset || !JDTUtils.isJavaIdentifierOrPeriod(contents.charAt(offset))) {
            return null;
        }
        int start = offset;
        while (start - 1 > -1 && JDTUtils.isJavaIdentifierOrPeriod(contents.charAt(start - 1))) {
            --start;
        }
        int end = offset;
        while (end <= contents.length() && JDTUtils.isJavaIdentifierOrPeriod(contents.charAt(end))) {
            ++end;
        }
        if (end >= start) {
            return contents.substring(start, end);
        }
        return null;
    }

    private static boolean isJavaIdentifierOrPeriod(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '.';
    }

    public static IFile findFile(String uriString) {
        return (IFile)JDTUtils.findResource(JDTUtils.toURI(uriString), arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
    }

    public static IResource findResource(URI uri, Function<URI, IResource[]> resourceFinder) {
        String uriString;
        int index;
        URI realUri;
        if (uri == null || !"file".equals(uri.getScheme())) {
            return null;
        }
        IResource[] resources = resourceFinder.apply(uri);
        if (resources.length == 0 && !uri.equals(realUri = FileUtil.realURI((URI)uri))) {
            uri = realUri;
            resources = resourceFinder.apply(uri);
        }
        if (resources.length == 0 && "win32".equals(Platform.getOS()) && uri.toString().startsWith("file:////") && (index = (uriString = uri.toString()).indexOf(PATH_SEPARATOR, "file:////".length())) > 0) {
            String server = uriString.substring("file:////".length(), index);
            uriString = uriString.replace(server, server.toUpperCase());
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            resources = resourceFinder.apply(uri);
        }
        switch (resources.length) {
            case 0: {
                return null;
            }
            case 1: {
                return resources[0];
            }
        }
        IResource resource = null;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource f = iResourceArray[n2];
            if (JavaLanguageServerPlugin.getProjectsManager().getDefaultProject().equals((Object)f.getProject())) {
                try {
                    f.delete(true, null);
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
            if (resource == null || f.getProjectRelativePath().segmentCount() < resource.getProjectRelativePath().segmentCount()) {
                resource = f;
            }
            ++n2;
        }
        return resource;
    }

    public static URI toURI(String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if ("win32".equals(Platform.getOS()) && URIUtil.isFileURI((URI)uri)) {
                uri = URIUtil.toFile((URI)uri).toURI();
            }
            return uri;
        }
        catch (URISyntaxException e) {
            JavaLanguageServerPlugin.logException("Failed to resolve " + uriString, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHiddenGeneratedElement(IJavaElement element) {
        if (!(element instanceof IAnnotatable)) return false;
        try {
            IAnnotation[] annotations = ((IAnnotatable)element).getAnnotations();
            if (annotations.length == 0) return false;
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if (JDTUtils.isSilencedGeneratedAnnotation(annotation)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isSilencedGeneratedAnnotation(IAnnotation annotation) throws JavaModelException {
        if ("javax.annotation.Generated".equals(annotation.getElementName())) {
            IMemberValuePair[] memberValuePairs;
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
            int n = memberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair m = iMemberValuePairArray[n2];
                if ("value".equals(m.getMemberName()) && 9 == m.getValueKind()) {
                    if (m.getValue() instanceof String) {
                        return SILENCED_CODEGENS.contains(m.getValue());
                    }
                    if (m.getValue() instanceof Object[]) {
                        Object[] objectArray = (Object[])m.getValue();
                        int n3 = objectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object val = objectArray[n4];
                            if (SILENCED_CODEGENS.contains(val)) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static IJavaSearchScope createSearchScope(IJavaProject project) {
        if (project == null) {
            return SearchEngine.createWorkspaceScope();
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{project}, (int)7);
    }

    public static boolean isOnClassPath(ICompilationUnit unit) {
        if (unit != null && unit.getJavaProject() != null && !unit.getJavaProject().getProject().equals((Object)JavaLanguageServerPlugin.getProjectsManager().getDefaultProject())) {
            return unit.getJavaProject().isOnClasspath((IJavaElement)unit);
        }
        return false;
    }

    public static boolean isDefaultProject(ICompilationUnit unit) {
        return unit != null && unit.getResource() != null && unit.getResource().getProject().equals((Object)JavaLanguageServerPlugin.getProjectsManager().getDefaultProject());
    }

    public static void setCompatibleVMs(String id) {
        IExecutionEnvironment[] environments;
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = environments = manager.getExecutionEnvironments();
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall[] compatibleVMs;
            IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
            IVMInstall[] iVMInstallArray = compatibleVMs = environment.getCompatibleVMs();
            int n3 = compatibleVMs.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall compatibleVM = iVMInstallArray[n4];
                if (id.equals(compatibleVM.getVMInstallType().getId()) && compatibleVM.getVMInstallType().findVMInstall(compatibleVM.getId()) != null && !compatibleVM.equals(environment.getDefaultVM()) && (environment.getDefaultVM() == null || compatibleVM.getId().compareTo(environment.getDefaultVM().getId()) < 0)) {
                    environment.setDefaultVM(compatibleVM);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

