/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.fix;

import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ls.core.internal.BindingLabelProvider;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.ls.core.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.ls.core.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.ls.core.internal.corext.utils.MethodsSourcePositionComparator;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class AddUnimplementedMethodsOperation
extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
    private ASTNode fTypeNode;

    public AddUnimplementedMethodsOperation(ASTNode typeNode) {
        this.fTypeNode = typeNode;
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
        ListRewrite listRewrite;
        AnonymousClassDeclaration decl;
        IMethodBinding[] unimplementedMethods = this.getUnimplementedMethods(this.fTypeNode);
        if (unimplementedMethods.length == 0) {
            return;
        }
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((CompilationUnit)this.fTypeNode.getRoot(), this.fTypeNode.getStartPosition(), cuRewrite.getImportRewrite());
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        ICompilationUnit unit = cuRewrite.getCu();
        CodeGenerationSettings settings = PreferenceManager.getCodeGenerationSettings((IResource)unit.getJavaProject().getProject());
        ITypeBinding currentType = null;
        if (this.fTypeNode instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fTypeNode;
            listRewrite = rewrite.getListRewrite((ASTNode)decl, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            settings.createComments = false;
            currentType = decl.resolveBinding();
        } else if (this.fTypeNode instanceof AbstractTypeDeclaration) {
            decl = (AbstractTypeDeclaration)this.fTypeNode;
            listRewrite = rewrite.getListRewrite((ASTNode)decl, decl.getBodyDeclarationsProperty());
            currentType = decl.resolveBinding();
        } else if (this.fTypeNode instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)this.fTypeNode;
            AnonymousClassDeclaration anonymousClassDeclaration = enumConstantDeclaration.getAnonymousClassDeclaration();
            if (anonymousClassDeclaration == null) {
                anonymousClassDeclaration = rewrite.getAST().newAnonymousClassDeclaration();
                rewrite.set((ASTNode)enumConstantDeclaration, (StructuralPropertyDescriptor)EnumConstantDeclaration.ANONYMOUS_CLASS_DECLARATION_PROPERTY, (Object)anonymousClassDeclaration, this.createTextEditGroup(CorrectionMessages.AddUnimplementedMethodsOperation_AddMissingMethod_group, cuRewrite));
            }
            listRewrite = rewrite.getListRewrite((ASTNode)anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            settings.createComments = false;
        } else {
            Assert.isTrue((boolean)false, (String)"Unknown type node");
            return;
        }
        ImportRewrite imports = cuRewrite.getImportRewrite();
        int i = 0;
        while (i < unimplementedMethods.length) {
            IMethodBinding curr = unimplementedMethods[i];
            MethodDeclaration newMethodDecl = StubUtility2.createImplementationStub(unit, rewrite, imports, context, curr, curr.getDeclaringClass(), settings, false, (IBinding)currentType, false);
            listRewrite.insertLast((ASTNode)newMethodDecl, this.createTextEditGroup(CorrectionMessages.AddUnimplementedMethodsOperation_AddMissingMethod_group, cuRewrite));
            ++i;
        }
    }

    @Override
    public String getAdditionalInfo() {
        if (this.fTypeNode instanceof EnumDeclaration) {
            return CorrectionMessages.UnimplementedMethodsCorrectionProposal_enum_info;
        }
        IMethodBinding[] methodsToOverride = this.getMethodsToImplement();
        StringBuffer buf = new StringBuffer();
        buf.append("<b>");
        if (methodsToOverride.length == 1) {
            buf.append(CorrectionMessages.UnimplementedMethodsCorrectionProposal_info_singular);
        } else {
            buf.append(Messages.format(CorrectionMessages.UnimplementedMethodsCorrectionProposal_info_plural, String.valueOf(methodsToOverride.length)));
        }
        buf.append("</b><ul>");
        int i = 0;
        while (i < methodsToOverride.length) {
            buf.append("<li>");
            buf.append(BindingLabelProvider.getBindingLabel((IBinding)methodsToOverride[i], JavaElementLabels.ALL_FULLY_QUALIFIED));
            buf.append("</li>");
            ++i;
        }
        buf.append("</ul>");
        return buf.toString();
    }

    public IMethodBinding[] getMethodsToImplement() {
        return this.getUnimplementedMethods(this.fTypeNode);
    }

    private IMethodBinding[] getUnimplementedMethods(ASTNode typeNode) {
        AnonymousClassDeclaration decl;
        ITypeBinding binding = null;
        boolean implementAbstractsOfInput = false;
        if (typeNode instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)typeNode;
            binding = decl.resolveBinding();
        } else if (typeNode instanceof AbstractTypeDeclaration) {
            decl = (AbstractTypeDeclaration)typeNode;
            binding = decl.resolveBinding();
        } else if (typeNode instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)typeNode;
            if (enumConstantDeclaration.getAnonymousClassDeclaration() != null) {
                binding = enumConstantDeclaration.getAnonymousClassDeclaration().resolveBinding();
            } else {
                IVariableBinding varBinding = enumConstantDeclaration.resolveVariable();
                if (varBinding != null) {
                    binding = varBinding.getDeclaringClass();
                    implementAbstractsOfInput = true;
                }
            }
        }
        if (binding == null) {
            return new IMethodBinding[0];
        }
        IMethodBinding[] unimplementedMethods = StubUtility2.getUnimplementedMethods(binding, implementAbstractsOfInput);
        Arrays.sort(unimplementedMethods, new MethodsSourcePositionComparator(binding));
        return unimplementedMethods;
    }
}

