/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.fix;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.fix.AddUnimplementedMethodsOperation;
import org.eclipse.jdt.ls.core.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.ls.core.internal.corext.fix.ICleanUpFix;
import org.eclipse.jdt.ls.core.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.ls.core.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.ls.core.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class UnimplementedCodeFix
extends CompilationUnitRewriteOperationsFix {
    public static ICleanUpFix createCleanUp(CompilationUnit root, boolean addMissingMethod, boolean makeTypeAbstract, IProblemLocation[] problems) {
        Assert.isLegal((!addMissingMethod || !makeTypeAbstract ? 1 : 0) != 0);
        if (!addMissingMethod && !makeTypeAbstract) {
            return null;
        }
        if (problems.length == 0) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation>();
        int i = 0;
        while (i < problems.length) {
            ASTNode typeNode;
            IProblemLocation problem = problems[i];
            if (addMissingMethod) {
                typeNode = UnimplementedCodeFix.getSelectedTypeNode(root, problem);
                if (typeNode != null && !UnimplementedCodeFix.isTypeBindingNull(typeNode)) {
                    operations.add(new AddUnimplementedMethodsOperation(typeNode));
                }
            } else {
                typeNode = UnimplementedCodeFix.getSelectedTypeNode(root, problem);
                if (typeNode instanceof TypeDeclaration) {
                    operations.add(new MakeTypeAbstractOperation((TypeDeclaration)typeNode));
                }
            }
            ++i;
        }
        if (operations.size() == 0) {
            return null;
        }
        String label = addMissingMethod ? CorrectionMessages.UnimplementedMethodsCorrectionProposal_description : CorrectionMessages.UnimplementedCodeFix_MakeAbstractFix_label;
        return new UnimplementedCodeFix(label, root, operations.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[operations.size()]));
    }

    public static IProposableFix createAddUnimplementedMethodsFix(CompilationUnit root, IProblemLocation problem) {
        ASTNode typeNode = UnimplementedCodeFix.getSelectedTypeNode(root, problem);
        if (typeNode == null) {
            return null;
        }
        if (UnimplementedCodeFix.isTypeBindingNull(typeNode)) {
            return null;
        }
        AddUnimplementedMethodsOperation operation = new AddUnimplementedMethodsOperation(typeNode);
        if (operation.getMethodsToImplement().length > 0) {
            return new UnimplementedCodeFix(CorrectionMessages.UnimplementedMethodsCorrectionProposal_description, root, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{operation});
        }
        return null;
    }

    public static UnimplementedCodeFix createMakeTypeAbstractFix(CompilationUnit root, IProblemLocation problem) {
        ASTNode typeNode = UnimplementedCodeFix.getSelectedTypeNode(root, problem);
        if (!(typeNode instanceof TypeDeclaration)) {
            return null;
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)typeNode;
        MakeTypeAbstractOperation operation = new MakeTypeAbstractOperation(typeDeclaration);
        String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_addabstract_description, BasicElementLabels.getJavaElementName((String)typeDeclaration.getName().getIdentifier()));
        return new UnimplementedCodeFix(label, root, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{operation});
    }

    public static ASTNode getSelectedTypeNode(CompilationUnit root, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(root);
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getNodeType() == 1) {
            selectedNode = selectedNode.getParent();
        }
        if (selectedNode.getLocationInParent() == EnumConstantDeclaration.NAME_PROPERTY) {
            selectedNode = selectedNode.getParent();
        }
        if (selectedNode.getNodeType() == 42 && selectedNode.getParent() instanceof AbstractTypeDeclaration) {
            return selectedNode.getParent();
        }
        if (selectedNode.getNodeType() == 14) {
            return ((ClassInstanceCreation)selectedNode).getAnonymousClassDeclaration();
        }
        if (selectedNode.getNodeType() == 72) {
            EnumConstantDeclaration enumConst = (EnumConstantDeclaration)selectedNode;
            if (enumConst.getAnonymousClassDeclaration() != null) {
                return enumConst.getAnonymousClassDeclaration();
            }
            return enumConst;
        }
        return null;
    }

    private static boolean isTypeBindingNull(ASTNode typeNode) {
        if (typeNode instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)typeNode;
            return abstractTypeDeclaration.resolveBinding() == null;
        }
        if (typeNode instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration anonymousClassDeclaration = (AnonymousClassDeclaration)typeNode;
            return anonymousClassDeclaration.resolveBinding() == null;
        }
        return !(typeNode instanceof EnumConstantDeclaration);
    }

    public UnimplementedCodeFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class MakeTypeAbstractOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final TypeDeclaration fTypeDeclaration;

        public MakeTypeAbstractOperation(TypeDeclaration typeDeclaration) {
            this.fTypeDeclaration = typeDeclaration;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel linkedProposalPositions) throws CoreException {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            Modifier newModifier = ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
            TextEditGroup textEditGroup = this.createTextEditGroup(CorrectionMessages.UnimplementedCodeFix_TextEditGroup_label, cuRewrite);
            rewrite.getListRewrite((ASTNode)this.fTypeDeclaration, TypeDeclaration.MODIFIERS2_PROPERTY).insertLast((ASTNode)newModifier, textEditGroup);
            LinkedProposalPositionGroup group = new LinkedProposalPositionGroup("modifier");
            group.addPosition(rewrite.track((ASTNode)newModifier), !linkedProposalPositions.hasLinkedPositions());
            linkedProposalPositions.addPositionGroup(group);
        }
    }
}

