/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalReplacementProvider;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.osgi.util.NLS;

public class CompletionResolveHandler {
    private final PreferenceManager manager;
    public static final String DATA_FIELD_URI = "uri";
    public static final String DATA_FIELD_DECLARATION_SIGNATURE = "decl_signature";
    public static final String DATA_FIELD_SIGNATURE = "signature";
    public static final String DATA_FIELD_NAME = "name";
    public static final String DATA_FIELD_REQUEST_ID = "rid";
    public static final String DATA_FIELD_PROPOSAL_ID = "pid";

    public CompletionResolveHandler(PreferenceManager manager) {
        this.manager = manager;
    }

    public CompletionItem resolve(CompletionItem param, IProgressMonitor monitor) {
        block18: {
            Map data = (Map)param.getData();
            param.setData(null);
            if (!(data.containsKey(DATA_FIELD_URI) && data.containsKey(DATA_FIELD_REQUEST_ID) && data.containsKey(DATA_FIELD_PROPOSAL_ID))) {
                return param;
            }
            int proposalId = Integer.parseInt((String)data.get(DATA_FIELD_PROPOSAL_ID));
            long requestId = Long.parseLong((String)data.get(DATA_FIELD_REQUEST_ID));
            CompletionResponse completionResponse = CompletionResponses.get(requestId);
            if (completionResponse == null || completionResponse.getProposals().size() <= proposalId) {
                throw new IllegalStateException("Invalid completion proposal");
            }
            String uri = (String)data.get(DATA_FIELD_URI);
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
            if (unit == null) {
                throw new IllegalStateException(NLS.bind((String)"Unable to match Compilation Unit from {0} ", (Object)uri));
            }
            CompletionProposalReplacementProvider proposalProvider = new CompletionProposalReplacementProvider(unit, completionResponse.getContext(), completionResponse.getOffset(), this.manager.getClientPreferences());
            proposalProvider.updateReplacement(completionResponse.getProposals().get(proposalId), param, '\u0000');
            if (monitor.isCanceled()) {
                param.setData(null);
                return param;
            }
            if (data.containsKey(DATA_FIELD_DECLARATION_SIGNATURE)) {
                String typeName = SignatureUtil.stripSignatureToFQN((String)String.valueOf(data.get(DATA_FIELD_DECLARATION_SIGNATURE)));
                try {
                    IType member = null;
                    IType type = unit.getJavaProject().findType(typeName);
                    if (type != null && data.containsKey(DATA_FIELD_NAME)) {
                        IMethod method;
                        String name = (String)data.get(DATA_FIELD_NAME);
                        String[] paramSigs = CharOperation.NO_STRINGS;
                        if (data.containsKey(DATA_FIELD_SIGNATURE)) {
                            String[] parameters = Signature.getParameterTypes((String)String.valueOf(SignatureUtil.fix83600((char[])((String)data.get(DATA_FIELD_SIGNATURE)).toCharArray())));
                            int i = 0;
                            while (i < parameters.length) {
                                parameters[i] = SignatureUtil.getLowerBound((String)parameters[i]);
                                ++i;
                            }
                            paramSigs = parameters;
                        }
                        if ((method = type.getMethod(name, paramSigs)).exists()) {
                            member = method;
                        } else {
                            IField field = type.getField(name);
                            if (field.exists()) {
                                member = field;
                            }
                        }
                    } else {
                        member = type;
                    }
                    if (member == null || !member.exists() || monitor.isCanceled()) break block18;
                    String javadoc = null;
                    try {
                        IType curMember = member;
                        javadoc = (String)new SimpleTimeLimiter().callWithTimeout(() -> CompletionResolveHandler.lambda$0((IMember)curMember), 500L, TimeUnit.MILLISECONDS, true);
                    }
                    catch (UncheckedTimeoutException tooSlow) {
                        monitor.setCanceled(true);
                    }
                    catch (Exception e) {
                        JavaLanguageServerPlugin.logException("Unable to read documentation", e);
                        monitor.setCanceled(true);
                    }
                    param.setDocumentation(javadoc);
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException("Unable to resolve compilation", e);
                    monitor.setCanceled(true);
                }
            }
        }
        if (monitor.isCanceled()) {
            param.setData(null);
        }
        return param;
    }

    private static /* synthetic */ String lambda$0(IMember iMember) throws Exception {
        Reader reader = JavadocContentAccess.getPlainTextContentReader(iMember);
        return reader == null ? null : CharStreams.toString((Readable)reader);
    }
}

