/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.DocumentAdapter;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.SharedASTProvider;
import org.eclipse.jdt.ls.core.internal.handlers.DiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;

public class DocumentLifeCycleHandler {
    public static final String DOCUMENT_LIFE_CYCLE_JOBS = "DocumentLifeCycleJobs";
    private JavaClientConnection connection;
    private PreferenceManager preferenceManager;
    private ProjectsManager projectsManager;
    private SharedASTProvider sharedASTProvider;
    private WorkspaceJob validationTimer;
    private Set<ICompilationUnit> toReconcile = new HashSet<ICompilationUnit>();

    public DocumentLifeCycleHandler(JavaClientConnection connection, PreferenceManager preferenceManager, ProjectsManager projectsManager, boolean delayValidation) {
        this.connection = connection;
        this.preferenceManager = preferenceManager;
        this.projectsManager = projectsManager;
        this.sharedASTProvider = SharedASTProvider.getInstance();
        if (delayValidation) {
            this.validationTimer = new WorkspaceJob("Validate documents"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    return DocumentLifeCycleHandler.this.performValidation(monitor);
                }

                public boolean belongsTo(Object family) {
                    return DocumentLifeCycleHandler.DOCUMENT_LIFE_CYCLE_JOBS.equals(family);
                }
            };
            this.validationTimer.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
    }

    private void triggerValidation(ICompilationUnit cu) throws JavaModelException {
        this.triggerValidation(cu, 400L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerValidation(ICompilationUnit cu, long delay) throws JavaModelException {
        Set<ICompilationUnit> set = this.toReconcile;
        synchronized (set) {
            this.toReconcile.add(cu);
        }
        if (this.validationTimer != null) {
            this.validationTimer.cancel();
            this.validationTimer.schedule(delay);
        } else {
            this.performValidation((IProgressMonitor)new NullProgressMonitor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus performValidation(IProgressMonitor monitor) throws JavaModelException {
        long start = System.currentTimeMillis();
        ArrayList<ICompilationUnit> cusToReconcile = new ArrayList<ICompilationUnit>();
        Set<ICompilationUnit> set = this.toReconcile;
        synchronized (set) {
            cusToReconcile.addAll(this.toReconcile);
            this.toReconcile.clear();
        }
        if (cusToReconcile.isEmpty()) {
            return Status.OK_STATUS;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(cusToReconcile.size() + 1));
        for (ICompilationUnit cu : cusToReconcile) {
            cu.reconcile(0, true, null, (IProgressMonitor)progress.newChild(1));
        }
        this.sharedASTProvider.invalidateAll();
        List<ICompilationUnit> toValidate = Arrays.asList(JavaCore.getWorkingCopies(null));
        List<CompilationUnit> astRoots = this.sharedASTProvider.getASTs(toValidate, monitor);
        for (CompilationUnit astRoot : astRoots) {
            ICompilationUnit unit = (ICompilationUnit)astRoot.getTypeRoot();
            final DiagnosticsHandler handler = new DiagnosticsHandler(this.connection, unit);
            WorkingCopyOwner wcOwner = new WorkingCopyOwner(){

                public IBuffer createBuffer(ICompilationUnit workingCopy) {
                    ICompilationUnit original = workingCopy.getPrimary();
                    IResource resource = original.getResource();
                    if (resource instanceof IFile) {
                        return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                    }
                    return DocumentAdapter.Null;
                }

                public IProblemRequestor getProblemRequestor(ICompilationUnit workingCopy) {
                    return handler;
                }
            };
            unit.reconcile(0, true, wcOwner, (IProgressMonitor)progress.newChild(1));
        }
        JavaLanguageServerPlugin.logInfo("Reconciled " + this.toReconcile.size() + ", validated: " + toValidate.size() + ". Took " + (System.currentTimeMillis() - start) + " ms");
        return Status.OK_STATUS;
    }

    public void didClose(final DidCloseTextDocumentParams params) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    DocumentLifeCycleHandler.this.handleClosed(params);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Handle document close ", e);
        }
    }

    public void didOpen(final DidOpenTextDocumentParams params) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    DocumentLifeCycleHandler.this.handleOpen(params);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Handle document open ", e);
        }
    }

    public void didChange(final DidChangeTextDocumentParams params) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    DocumentLifeCycleHandler.this.handleChanged(params);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Handle document change ", e);
        }
    }

    public void didSave(final DidSaveTextDocumentParams params) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    DocumentLifeCycleHandler.this.handleSaved(params);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Handle document save ", e);
        }
    }

    public void handleOpen(DidOpenTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null || unit.getResource() == null) {
            return;
        }
        try {
            IProject project;
            boolean isDefaultProject;
            if (!unit.getResource().isAccessible()) {
                try {
                    IJavaElement parent;
                    unit.getResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    if (unit.getResource().exists() && (parent = unit.getParent()) instanceof IPackageFragment) {
                        IPackageFragment pkg = (IPackageFragment)parent;
                        unit = pkg.createCompilationUnit(unit.getElementName(), unit.getSource(), true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException parent) {
                    // empty catch block
                }
            }
            if ((isDefaultProject = (project = unit.getResource().getProject()).equals((Object)JavaLanguageServerPlugin.getProjectsManager().getDefaultProject())) || !JDTUtils.isOnClassPath(unit)) {
                Preferences.Severity severity = this.preferenceManager.getPreferences((IResource)project).getIncompleteClasspathSeverity();
                String msg = isDefaultProject ? "Classpath is incomplete. Only syntax errors will be reported" : String.valueOf(unit.getElementName()) + " isn't on the classpath. Only syntax errors will be reported";
                JavaLanguageServerPlugin.logInfo(String.valueOf(msg) + " for " + uri);
                if (severity.compareTo(Preferences.Severity.ignore) > 0) {
                    ActionableNotification ignoreIncompleteClasspath = new ActionableNotification().withSeverity(severity.toMessageType()).withMessage(msg).withCommands(Arrays.asList(new Command("More Information", "java.ignoreIncompleteClasspath.help", null), new Command("Don't Show Again", "java.ignoreIncompleteClasspath", null)));
                    this.connection.sendActionableNotification(ignoreIncompleteClasspath);
                }
            }
            unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IBuffer buffer = unit.getBuffer();
            String newContent = params.getTextDocument().getText();
            if (buffer != null && !buffer.getContents().equals(newContent)) {
                buffer.setContents(newContent);
            }
            this.triggerValidation(unit);
            this.checkPackageDeclaration(uri, unit);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Error while opening document", e);
        }
    }

    public void handleChanged(DidChangeTextDocumentParams params) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null || !unit.isWorkingCopy() || params.getContentChanges().isEmpty()) {
            return;
        }
        try {
            this.sharedASTProvider.invalidate((ITypeRoot)unit);
            List contentChanges = params.getContentChanges();
            for (TextDocumentContentChangeEvent changeEvent : contentChanges) {
                int length;
                Range range = changeEvent.getRange();
                if (range != null) {
                    length = changeEvent.getRangeLength();
                } else {
                    length = unit.getSource().length();
                    range = JDTUtils.toRange((IOpenable)unit, 0, length);
                }
                int startOffset = JsonRpcHelpers.toOffset(unit.getBuffer(), range.getStart().getLine(), range.getStart().getCharacter());
                Object edit = null;
                String text = changeEvent.getText();
                edit = length == 0 ? new InsertEdit(startOffset, text) : (text.isEmpty() ? new DeleteEdit(startOffset, length) : new ReplaceEdit(startOffset, length, text));
                IDocument document = JsonRpcHelpers.toDocument(unit.getBuffer());
                edit.apply(document, 0);
            }
            this.triggerValidation(unit);
        }
        catch (JavaModelException | BadLocationException | MalformedTreeException e) {
            JavaLanguageServerPlugin.logException("Error while handling document change", e);
        }
    }

    public void handleClosed(DidCloseTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null) {
            return;
        }
        try {
            if (JDTUtils.isDefaultProject(unit) || !JDTUtils.isOnClassPath(unit)) {
                new DiagnosticsHandler(this.connection, unit).clearDiagnostics();
            }
            this.sharedASTProvider.invalidate((ITypeRoot)unit);
            unit.discardWorkingCopy();
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Error while handling document close", e);
        }
    }

    public void handleSaved(DidSaveTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null) {
            JavaLanguageServerPlugin.logError(String.valueOf(uri) + " does not resolve to a ICompilationUnit");
            return;
        }
        if ((unit = this.checkPackageDeclaration(uri, unit)).isWorkingCopy()) {
            try {
                this.projectsManager.fileChanged(uri, ProjectsManager.CHANGE_TYPE.CHANGED);
                unit.discardWorkingCopy();
                unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException("Error while handling document save", e);
            }
        }
    }

    private ICompilationUnit checkPackageDeclaration(String uri, ICompilationUnit unit) {
        if (unit.getResource() != null && unit.getJavaProject() != null && unit.getJavaProject().getProject().getName().equals("jdt.ls-java-project")) {
            try {
                IProblem[] problems;
                CompilationUnit astRoot = SharedASTProvider.getInstance().getAST((ITypeRoot)unit, (IProgressMonitor)new NullProgressMonitor());
                IProblem[] iProblemArray = problems = astRoot.getProblems();
                int n = problems.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblem problem = iProblemArray[n2];
                    if (problem.getID() == 536871240) {
                        IPath path;
                        IResource file = unit.getResource();
                        boolean toRemove = file.isLinked();
                        if (toRemove && (path = file.getParent().getProjectRelativePath()).segmentCount() > 0 && "src".equals(path.segments()[0])) {
                            String pathStr;
                            String packageNameResource = path.removeFirstSegments(1).toString().replace("/", ".");
                            path = file.getLocation();
                            if (path != null && path.segmentCount() > 0 && (pathStr = (path = path.removeLastSegments(1)).toString().replace("/", ".")).endsWith(packageNameResource)) {
                                toRemove = false;
                            }
                        }
                        if (toRemove) {
                            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                            this.sharedASTProvider.invalidate((ITypeRoot)unit);
                            unit.discardWorkingCopy();
                            unit = JDTUtils.resolveCompilationUnit(uri);
                            unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                            this.triggerValidation(unit);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return unit;
    }
}

