/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameProcessor;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.WorkspaceEdit;

public class RenameHandler {
    private PreferenceManager preferenceManager;

    public RenameHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public WorkspaceEdit rename(RenameParams params, IProgressMonitor monitor) {
        WorkspaceEdit edit = new WorkspaceEdit();
        if (!this.preferenceManager.getPreferences().isRenameEnabled()) {
            return edit;
        }
        try {
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
            IJavaElement[] elements = JDTUtils.findElementsAtSelection((ITypeRoot)unit, params.getPosition().getLine(), params.getPosition().getCharacter(), this.preferenceManager, monitor);
            if (elements == null || elements.length == 0) {
                return edit;
            }
            IJavaElement curr = null;
            if (elements.length != 1) {
                IPackageFragment packageFragment = (IPackageFragment)unit.getParent();
                IJavaElement found = Stream.of(elements).filter(e -> e.equals(packageFragment)).findFirst().orElse(null);
                curr = found == null ? elements[0] : found;
            } else {
                curr = elements[0];
            }
            RenameProcessor processor = this.createRenameProcessor(curr);
            processor.renameOccurrences(edit, params.getNewName(), monitor);
        }
        catch (CoreException ex) {
            JavaLanguageServerPlugin.logException("Problem with rename for " + params.getTextDocument().getUri(), ex);
        }
        return edit;
    }

    private RenameProcessor createRenameProcessor(IJavaElement selectedElement) throws JavaModelException {
        if (selectedElement instanceof IType) {
            return new RenameTypeProcessor(selectedElement);
        }
        if (selectedElement instanceof IMethod && ((IMethod)selectedElement).isConstructor()) {
            return new RenameTypeProcessor((IJavaElement)((IMethod)selectedElement).getDeclaringType());
        }
        return new RenameProcessor(selectedElement);
    }
}

