/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.SharedASTProvider;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.PublishDiagnosticsParams;

public class WorkspaceEventsHandler {
    private final ProjectsManager pm;
    private final JavaClientConnection connection;

    public WorkspaceEventsHandler(ProjectsManager projects, JavaClientConnection connection) {
        this.pm = projects;
        this.connection = connection;
    }

    private ProjectsManager.CHANGE_TYPE toChangeType(FileChangeType vtype) {
        switch (vtype) {
            case Created: {
                return ProjectsManager.CHANGE_TYPE.CREATED;
            }
            case Changed: {
                return ProjectsManager.CHANGE_TYPE.CHANGED;
            }
            case Deleted: {
                return ProjectsManager.CHANGE_TYPE.DELETED;
            }
        }
        throw new UnsupportedOperationException();
    }

    void didChangeWatchedFiles(DidChangeWatchedFilesParams param) {
        List changes = param.getChanges();
        for (FileEvent fileEvent : changes) {
            ICompilationUnit unit;
            ProjectsManager.CHANGE_TYPE changeType = this.toChangeType(fileEvent.getType());
            if (changeType == ProjectsManager.CHANGE_TYPE.DELETED) {
                this.cleanUpDiagnostics(fileEvent.getUri());
            }
            if ((unit = JDTUtils.resolveCompilationUnit(fileEvent.getUri())) != null && changeType == ProjectsManager.CHANGE_TYPE.CREATED && !unit.exists()) {
                final ICompilationUnit[] units = new ICompilationUnit[]{unit};
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            units[0] = WorkspaceEventsHandler.this.createCompilationUnit(units[0]);
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
                unit = units[0];
            }
            if (unit != null && unit.isWorkingCopy()) continue;
            if (changeType == ProjectsManager.CHANGE_TYPE.DELETED || changeType == ProjectsManager.CHANGE_TYPE.CHANGED) {
                SharedASTProvider.getInstance().invalidate((ITypeRoot)unit);
            }
            this.pm.fileChanged(fileEvent.getUri(), changeType);
        }
    }

    private ICompilationUnit createCompilationUnit(ICompilationUnit unit) {
        try {
            IJavaElement parent;
            unit.getResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            if (unit.getResource().exists() && (parent = unit.getParent()) instanceof IPackageFragment) {
                IPackageFragment pkg = (IPackageFragment)parent;
                unit = pkg.createCompilationUnit(unit.getElementName(), unit.getSource(), true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return unit;
    }

    private void cleanUpDiagnostics(String uri) {
        this.connection.publishDiagnostics(new PublishDiagnosticsParams(ResourceUtils.toClientUri(uri), Collections.emptyList()));
    }
}

