/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.StatusFactory;

public class BasicFileDetector {
    private static final String METADATA_FOLDER = "**/.metadata";
    private List<Path> directories;
    private Path rootDir;
    private String fileName;
    private int maxDepth = 5;
    private boolean includeNested = true;
    private Set<String> exclusions = new HashSet<String>(1);

    public BasicFileDetector(Path rootDir, String fileName) {
        this.rootDir = rootDir;
        this.fileName = fileName;
        this.directories = new ArrayList<Path>();
        this.addExclusions(METADATA_FOLDER);
        List<String> javaImportExclusions = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getJavaImportExclusions();
        if (javaImportExclusions != null) {
            for (String pattern : javaImportExclusions) {
                this.addExclusions(pattern);
            }
        }
    }

    public BasicFileDetector addExclusions(String ... excludes) {
        if (excludes != null) {
            this.exclusions.addAll(Arrays.asList(excludes));
        }
        return this;
    }

    public BasicFileDetector includeNested(boolean includeNested) {
        this.includeNested = includeNested;
        return this;
    }

    public BasicFileDetector maxDepth(int maxDepth) {
        Assert.isTrue((maxDepth > 0 ? 1 : 0) != 0, (String)"maxDepth must be > 0");
        this.maxDepth = maxDepth;
        return this;
    }

    public Collection<Path> getDirectories() {
        return Collections.unmodifiableList(this.directories);
    }

    public Collection<Path> scan(IProgressMonitor monitor) throws CoreException {
        try {
            this.scanDir(this.rootDir, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Failed to scan " + this.rootDir, e));
        }
        return this.getDirectories();
    }

    private void scanDir(Path dir, final IProgressMonitor monitor) throws IOException {
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (monitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                Objects.requireNonNull(dir);
                if (BasicFileDetector.this.isExcluded(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (BasicFileDetector.this.hasTargetFile(dir)) {
                    BasicFileDetector.this.directories.add(dir);
                    return BasicFileDetector.this.includeNested ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(dir, Collections.emptySet(), this.maxDepth, (FileVisitor<? super Path>)visitor);
    }

    private boolean isExcluded(Path dir) {
        if (dir.getFileName() == null) {
            return true;
        }
        for (String pattern : this.exclusions) {
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
            if (!matcher.matches(dir)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTargetFile(Path dir) {
        return Files.isRegularFile(dir.resolve(this.fileName), new LinkOption[0]);
    }
}

