/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IRuleHandler;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.SelectionListener2;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.services.RulesDialog;

public class RelatedRulesDialog
extends TitleAreaDialog {
    private ListViewer viewer;
    private Button addBtn;
    private Button deleteBtn;
    private Button upBtn;
    private Button downBtn;
    private final List<Rule> rules;
    private final IRuleHandler handler;

    public RelatedRulesDialog(Shell parentShell, IRuleHandler handler, Rule[] values) {
        super(parentShell);
        this.handler = handler;
        this.rules = new ArrayList<Rule>();
        Rule[] ruleArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Rule r = ruleArray[n2];
            this.rules.add(r);
            ++n2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        this.createList(contents);
        this.createButtons(contents);
        this.init();
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private void init() {
        this.viewer.setInput(this.rules);
        this.viewer.setSelection((ISelection)new StructuredSelection());
    }

    private void createButtons(Composite contents) {
        Composite bar = new Composite(contents, 0);
        bar.setLayoutData((Object)new GridData(1040));
        bar.setLayout((Layout)new GridLayout());
        this.addBtn = new Button(bar, 8);
        this.addBtn.setToolTipText(Messages.RelatedRulesDialog_add_tooltip);
        this.addBtn.setImage(Activator.getDefault().getImage("icons/add.gif"));
        this.addBtn.setLayoutData((Object)new GridData());
        this.addBtn.addSelectionListener((SelectionListener)new SelectionListener2(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                RulesDialog dialog = new RulesDialog(RelatedRulesDialog.this.getShell(), RelatedRulesDialog.this.handler.getElements());
                if (dialog.open() == 0) {
                    Rule rule = (Rule)dialog.getResult();
                    RelatedRulesDialog.this.rules.add(rule);
                    RelatedRulesDialog.this.viewer.refresh();
                }
            }
        });
        this.deleteBtn = new Button(bar, 8);
        this.deleteBtn.setToolTipText(Messages.RelatedRulesDialog_delete_tooltip);
        this.deleteBtn.setImage(Activator.getDefault().getImage("icons/delete.gif"));
        this.deleteBtn.setLayoutData((Object)new GridData());
        this.deleteBtn.addSelectionListener((SelectionListener)new SelectionListener2(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = ((IStructuredSelection)RelatedRulesDialog.this.viewer.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    RelatedRulesDialog.this.rules.remove(obj);
                    ++n2;
                }
                RelatedRulesDialog.this.viewer.refresh();
            }
        });
        this.upBtn = new Button(bar, 8);
        this.upBtn.setToolTipText(Messages.RelatedRulesDialog_up_tooltip);
        this.upBtn.setImage(Activator.getDefault().getImage("icons/up.gif"));
        this.upBtn.setLayoutData((Object)new GridData());
        this.upBtn.addSelectionListener((SelectionListener)new SelectionListener2(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                List<Object> selected = Arrays.asList(((IStructuredSelection)RelatedRulesDialog.this.viewer.getSelection()).toArray());
                int n = 1;
                while (n < RelatedRulesDialog.this.rules.size()) {
                    Rule rule = (Rule)RelatedRulesDialog.this.rules.get(n);
                    if (selected.contains(rule)) {
                        Rule previous = (Rule)RelatedRulesDialog.this.rules.get(n - 1);
                        RelatedRulesDialog.this.rules.set(n - 1, rule);
                        RelatedRulesDialog.this.rules.set(n, previous);
                    }
                    ++n;
                }
                RelatedRulesDialog.this.viewer.refresh();
                RelatedRulesDialog.this.updateButtons();
            }
        });
        this.downBtn = new Button(bar, 8);
        this.downBtn.setToolTipText(Messages.RelatedRulesDialog_down_tooltip);
        this.downBtn.setImage(Activator.getDefault().getImage("icons/down.gif"));
        this.downBtn.setLayoutData((Object)new GridData());
        this.downBtn.addSelectionListener((SelectionListener)new SelectionListener2(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                List<Object> selected = Arrays.asList(((IStructuredSelection)RelatedRulesDialog.this.viewer.getSelection()).toArray());
                int n = RelatedRulesDialog.this.rules.size() - 2;
                while (n >= 0) {
                    Rule rule = (Rule)RelatedRulesDialog.this.rules.get(n);
                    if (selected.contains(rule)) {
                        Rule previous = (Rule)RelatedRulesDialog.this.rules.get(n + 1);
                        RelatedRulesDialog.this.rules.set(n + 1, rule);
                        RelatedRulesDialog.this.rules.set(n, previous);
                    }
                    --n;
                }
                RelatedRulesDialog.this.viewer.refresh();
                RelatedRulesDialog.this.updateButtons();
            }
        });
    }

    private void createList(Composite parent) {
        this.viewer = new ListViewer(parent);
        this.viewer.getList().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Rule rule = (Rule)element;
                return String.valueOf(rule.getId()) + "  [" + rule.getImplementation() + "]";
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RelatedRulesDialog.this.updateButtons();
            }
        });
    }

    private Composite createComposite(Composite parentComposite) {
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        contents.setLayoutData((Object)new GridData(1808));
        this.setTitle(Messages.RelatedRulesDialog_title);
        this.setMessage(Messages.RelatedRulesDialog_description);
        return contents;
    }

    public Rule[] getResult() {
        return this.rules.toArray(new Rule[this.rules.size()]);
    }

    private void updateButtons() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        this.deleteBtn.setEnabled(!sel.isEmpty());
        org.eclipse.swt.widgets.List list = this.viewer.getList();
        if (sel.isEmpty()) {
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        } else {
            int[] selectionIndices = list.getSelectionIndices();
            int min = this.min(selectionIndices);
            int max = this.max(selectionIndices);
            this.upBtn.setEnabled(min > 0);
            this.downBtn.setEnabled(max < list.getItemCount() - 1);
        }
    }

    private int max(int[] selectionIndices) {
        int result = -1;
        int[] nArray = selectionIndices;
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 > result) {
                result = n3;
            }
            ++n2;
        }
        return result;
    }

    private int min(int[] selectionIndices) {
        int result = -1;
        int[] nArray = selectionIndices;
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 < result || result < 0) {
                result = n3;
            }
            ++n2;
        }
        return result;
    }
}

