/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.listeners;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.kitalpha.ad.integration.sirius.Activator;
import org.polarsys.kitalpha.ad.integration.sirius.SiriusViewpointManager;
import org.polarsys.kitalpha.ad.integration.sirius.listeners.SiriusHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public class ViewpointActivationStateListener
extends SessionManagerListener.Stub {
    public void notify(Session updated, int notification) {
        super.notify(updated, notification);
        if (updated != null && (7 == notification || 11 == notification)) {
            this.handleOpenSession(updated);
        }
    }

    protected void handleOpenSession(Session session) {
        try {
            HashSet<Viewpoint> newSelectedViewpoints = new HashSet<Viewpoint>();
            HashSet<Viewpoint> newDeselectedViewpoints = new HashSet<Viewpoint>();
            HashSet<String> toActivate = new HashSet<String>();
            HashSet<String> toDesactivate = new HashSet<String>();
            ViewpointManager mgr = SiriusHelper.getViewpointManager(session);
            SiriusViewpointManager.INSTANCE.collectSiriusViewpoint(mgr, toActivate, toDesactivate);
            Map<String, Viewpoint> allSiriusViewpoints = SiriusViewpointManager.INSTANCE.getAllSiriusViewpoints();
            for (Viewpoint vp : session.getSelectedViewpoints(false)) {
                if (toActivate.contains(vp.getName())) {
                    toActivate.remove(vp.getName());
                    continue;
                }
                if (!toDesactivate.contains(vp.getName())) continue;
                newDeselectedViewpoints.add(vp);
            }
            for (String name : toActivate) {
                newSelectedViewpoints.add(allSiriusViewpoints.get(name));
            }
            SyncCommand command = new SyncCommand(session.getTransactionalEditingDomain(), newDeselectedViewpoints, (IProgressMonitor)new NullProgressMonitor(), session, newSelectedViewpoints);
            if (!newSelectedViewpoints.isEmpty() || !newDeselectedViewpoints.isEmpty()) {
                session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
            }
        }
        catch (Exception e) {
            Activator.getDefault().logWarning(e);
        }
    }

    private final class SyncCommand
    extends RecordingCommand
    implements AbstractCommand.NonDirtying {
        private final Set<Viewpoint> newDeselectedViewpoints;
        private final IProgressMonitor monitor;
        private final Session session;
        private final Set<Viewpoint> newSelectedViewpoints;

        private SyncCommand(TransactionalEditingDomain domain, Set<Viewpoint> newDeselectedViewpoints, IProgressMonitor monitor, Session session, Set<Viewpoint> newSelectedViewpoints) {
            super(domain);
            this.newDeselectedViewpoints = newDeselectedViewpoints;
            this.monitor = monitor;
            this.session = session;
            this.newSelectedViewpoints = newSelectedViewpoints;
        }

        protected void doExecute() {
            ViewpointSelectionCallback viewpointSelectionCallback = new ViewpointSelectionCallback();
            for (Viewpoint vp : this.newDeselectedViewpoints) {
                viewpointSelectionCallback.deselectViewpoint(vp, this.session, this.monitor);
            }
            for (Viewpoint vp : this.newSelectedViewpoints) {
                viewpointSelectionCallback.selectViewpoint(vp, this.session, this.monitor);
            }
        }
    }
}

