/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.util;

import com.ibm.jusb.util.NullUsbTracer;
import java.lang.reflect.Constructor;
import javax.usb.UsbHostManager;

public abstract class UsbTracer {
    private static UsbTracer globalUsbTracer;
    private static Object globalUsbTracerLock;
    protected String defaultName;
    protected int defaultLevel;
    public static final String TRACE_IMPLEMENTATION_PROPERTY = "com.ibm.jusb.util.UsbTracer";
    public static final String GLOBAL_TRACER_NAME_PROPERTY = "com.ibm.jusb.util.UsbTracer.global.name";
    public static final String GLOBAL_TRACER_LEVEL_PROPERTY = "com.ibm.jusb.util.UsbTracer.global.level";
    public static final String TRACE_CRITICAL_PROPERTY = "TRACE_CRITICAL";
    public static final String TRACE_ERROR_PROPERTY = "TRACE_ERROR";
    public static final String TRACE_WARN_PROPERTY = "TRACE_WARN";
    public static final String TRACE_NOTICE_PROPERTY = "TRACE_NOTICE";
    public static final String TRACE_INFO_PROPERTY = "TRACE_INFO";
    public static final String TRACE_DEBUG_PROPERTY = "TRACE_DEBUG";
    public static final int TRACE_CRITICAL = 100;
    public static final int TRACE_ERROR = 200;
    public static final int TRACE_WARN = 300;
    public static final int TRACE_NOTICE = 400;
    public static final int TRACE_INFO = 500;
    public static final int TRACE_DEBUG = 600;
    private static final String GLOBAL_TRACER_DEFAULT_NAME = "Main UsbTracer";
    private static final int GLOBAL_TRACER_DEFAULT_LEVEL = 600;

    protected UsbTracer(String name, int level) {
        this.setDefaultName(name);
        this.setDefaultLevel(level);
    }

    public abstract void print(String var1, int var2, String var3);

    public void println(String name, int level, String msg) {
        this.print(name, level, msg + "\n");
    }

    public void print(String name, String msg) {
        this.print(name, this.getDefaultLevel(), msg);
    }

    public void println(String name, String msg) {
        this.println(name, this.getDefaultLevel(), msg);
    }

    public void print(int level, String msg) {
        this.print(this.getDefaultName(), level, msg);
    }

    public void println(int level, String msg) {
        this.println(this.getDefaultName(), level, msg);
    }

    public void print(String msg) {
        this.print(this.getDefaultName(), this.getDefaultLevel(), msg);
    }

    public void println(String msg) {
        this.println(this.getDefaultName(), this.getDefaultLevel(), msg);
    }

    public void setDefaultName(String name) {
        this.defaultName = name;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultLevel(int level) {
        this.defaultLevel = level;
    }

    public int getDefaultLevel() {
        return this.defaultLevel;
    }

    public static UsbTracer getUsbTracer(String name, int level) {
        try {
            Class[] constructorClasses = new Class[]{String.class, Integer.TYPE};
            String className = UsbHostManager.getProperties().getProperty(TRACE_IMPLEMENTATION_PROPERTY);
            Constructor<?> classConstructor = Class.forName(className).getConstructor(constructorClasses);
            Object[] constructorObjects = new Object[]{name, new Integer(level)};
            return (UsbTracer)classConstructor.newInstance(constructorObjects);
        }
        catch (Exception e) {
            return new NullUsbTracer(name, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsbTracer getUsbTracer() {
        Object object = globalUsbTracerLock;
        synchronized (object) {
            if (null == globalUsbTracer) {
                String name = GLOBAL_TRACER_DEFAULT_NAME;
                int level = 600;
                try {
                    name = UsbHostManager.getProperties().getProperty(GLOBAL_TRACER_NAME_PROPERTY);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    level = UsbTracer.getIntTraceLevel(UsbHostManager.getProperties().getProperty(GLOBAL_TRACER_LEVEL_PROPERTY));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                globalUsbTracer = UsbTracer.getUsbTracer(name, level);
            }
        }
        return globalUsbTracer;
    }

    protected static int getIntTraceLevel(String level) throws Exception {
        if (TRACE_CRITICAL_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 100;
        }
        if (TRACE_ERROR_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 200;
        }
        if (TRACE_WARN_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 300;
        }
        if (TRACE_NOTICE_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 400;
        }
        if (TRACE_INFO_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 500;
        }
        if (TRACE_DEBUG_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 600;
        }
        throw new Exception("Unknown trace level : " + level);
    }

    static {
        globalUsbTracerLock = new Object();
    }
}

