/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data.store;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.KuraStoreCapacityReachedException;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.core.data.DataMessage;
import org.eclipse.kura.core.data.DataStore;
import org.eclipse.kura.core.data.store.HouseKeeperTask;
import org.eclipse.kura.core.db.HsqlDbServiceImpl;
import org.eclipse.kura.db.DbService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbDataStore
implements DataStore {
    private static final Logger s_logger = LoggerFactory.getLogger(DbDataStore.class);
    private DbService m_dbService;
    private Calendar m_utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private ScheduledExecutorService m_houseKeeperExecutor;
    private ScheduledFuture<?> m_houseKeeperTask;
    int m_capacity;

    @Override
    public synchronized void start(DbService dbService, int houseKeeperInterval, int purgeAge, int capacity) throws KuraStoreException {
        this.m_dbService = dbService;
        this.m_houseKeeperExecutor = Executors.newSingleThreadScheduledExecutor();
        this.init(houseKeeperInterval, purgeAge, capacity);
    }

    private void init(int houseKeeperInterval, int purgeAge, int capacity) throws KuraStoreException {
        block3: {
            this.execute("CREATE TABLE IF NOT EXISTS ds_messages (id INTEGER GENERATED ALWAYS AS IDENTITY PRIMARY KEY, topic VARCHAR(32767 CHARACTERS), qos INTEGER, retain BOOLEAN, createdOn TIMESTAMP, publishedOn TIMESTAMP, publishedMessageId INTEGER, confirmedOn TIMESTAMP, payload VARBINARY(16777216), priority INTEGER, sessionId VARCHAR(32767 CHARACTERS), droppedOn TIMESTAMP);", new Integer[0]);
            this.execute("DROP INDEX IF EXISTS ds_messages_publishedOn;", new Integer[0]);
            try {
                this.execute("CREATE INDEX ds_messages_nextMsg ON ds_messages (priority ASC, createdOn ASC, publishedOn, qos);", new Integer[0]);
            }
            catch (KuraStoreException e) {
                SQLException sqle;
                boolean handled = false;
                if (e.getCause() != null && e.getCause() instanceof SQLException && (sqle = (SQLException)e.getCause()).getErrorCode() == -5504) {
                    handled = true;
                }
                if (handled) break block3;
                throw e;
            }
        }
        this.update(houseKeeperInterval, purgeAge, capacity);
    }

    @Override
    public synchronized void stop() {
        s_logger.info("Canceling the Housekeeper Task...");
        if (this.m_houseKeeperTask != null) {
            this.m_houseKeeperTask.cancel(true);
        }
        this.m_houseKeeperExecutor.shutdownNow();
    }

    @Override
    public synchronized void update(int houseKeeperInterval, int purgeAge, int capacity) {
        this.m_capacity = capacity;
        if (this.m_houseKeeperTask != null) {
            this.m_houseKeeperTask.cancel(true);
        }
        boolean doCheckpoint = !((HsqlDbServiceImpl)this.m_dbService).isLogDataEnabled();
        this.m_houseKeeperTask = this.m_houseKeeperExecutor.scheduleAtFixedRate(new HouseKeeperTask(this, purgeAge, doCheckpoint), 1L, houseKeeperInterval, TimeUnit.SECONDS);
    }

    private synchronized int getMessageCount() throws KuraStoreException {
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        int count = -1;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.prepareStatement("SELECT COUNT(*) FROM ds_messages;");
                rs = stmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
            catch (Exception e) {
                throw new KuraStoreException((Throwable)e, (Object)"Cannot get message count");
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(rs);
        this.close(stmt);
        this.close(conn);
        return count;
    }

    private synchronized void resetIdentityGenerator() throws KuraStoreException {
        this.execute("ALTER TABLE ds_messages ALTER COLUMN id RESTART WITH 0;", new Integer[0]);
    }

    @Override
    public synchronized DataMessage store(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraStoreException {
        if (topic == null || topic.trim().length() == 0) {
            throw new IllegalArgumentException("topic");
        }
        if (priority != 0 && priority != 1) {
            int count = this.getMessageCount();
            s_logger.debug("Store message count: {}", (Object)count);
            if (count >= this.m_capacity) {
                s_logger.error("Store capacity exceeded");
                throw new KuraStoreCapacityReachedException((Object)"Store capacity exceeded");
            }
        }
        DataMessage message = null;
        try {
            message = this.storeInternal(topic, payload, qos, retain, priority);
        }
        catch (KuraStoreException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                SQLException sqle = (SQLException)cause;
                int errorCode = sqle.getErrorCode();
                if (errorCode == -3416) {
                    s_logger.warn("Identity generator limit exceeded. Resetting it...");
                    this.resetIdentityGenerator();
                    message = this.storeInternal(topic, payload, qos, retain, priority);
                }
                throw e;
            }
            throw e;
        }
        return message;
    }

    private synchronized DataMessage storeInternal(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraStoreException {
        if (topic == null || topic.trim().length() == 0) {
            throw new IllegalArgumentException("topic");
        }
        Timestamp now = new Timestamp(new Date().getTime());
        int messageId = -1;
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement cstmt = null;
        try {
            try {
                conn = this.getConnection();
                pstmt = conn.prepareStatement("INSERT INTO ds_messages (topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, payload, priority, sessionId, droppedOn) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
                pstmt.setString(1, topic);
                pstmt.setInt(2, qos);
                pstmt.setBoolean(3, retain);
                pstmt.setTimestamp(4, now, this.m_utcCalendar);
                pstmt.setTimestamp(5, null);
                pstmt.setInt(6, -1);
                pstmt.setTimestamp(7, null);
                pstmt.setBytes(8, payload);
                pstmt.setInt(9, priority);
                pstmt.setString(10, null);
                pstmt.setTimestamp(11, null);
                pstmt.execute();
                cstmt = conn.prepareStatement("CALL IDENTITY();");
                rs = cstmt.executeQuery();
                if (rs != null && rs.next()) {
                    messageId = rs.getInt(1);
                }
                conn.commit();
            }
            catch (SQLException e) {
                this.rollback(conn);
                s_logger.error("SQL error code: {}", (Object)e.getErrorCode());
                throw new KuraStoreException((Throwable)e, (Object)"Cannot store message");
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(cstmt);
            this.close(pstmt);
            this.close(conn);
            throw throwable;
        }
        this.close(rs);
        this.close(cstmt);
        this.close(pstmt);
        this.close(conn);
        return this.get(messageId);
    }

    @Override
    public synchronized DataMessage get(int msgId) throws KuraStoreException {
        DataMessage msg = null;
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.prepareStatement("SELECT id, topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, payload, priority, sessionId, droppedOn FROM ds_messages WHERE id = ?");
                stmt.setInt(1, msgId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    msg = this.buildDataMessage(rs);
                }
            }
            catch (Exception e) {
                throw new KuraStoreException((Throwable)e, (Object)("Cannot get message by ID: " + msgId));
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(rs);
        this.close(stmt);
        this.close(conn);
        return msg;
    }

    @Override
    public synchronized DataMessage getNextMessage() throws KuraStoreException {
        DataMessage msg = null;
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.prepareStatement("SELECT d.id, d.topic, d.qos, d.retain, d.createdOn, d.publishedOn, d.publishedMessageId, d.confirmedOn, d.payload, d.priority, d.sessionId, d.droppedOn FROM (SELECT id FROM ds_messages WHERE publishedOn IS NULL ORDER BY priority ASC, createdOn ASC LIMIT 1 USING INDEX) a, ds_messages d WHERE a.id = d.id;");
                rs = stmt.executeQuery();
                if (rs != null && rs.next()) {
                    msg = this.buildDataMessage(rs);
                }
            }
            catch (Exception e) {
                throw new KuraStoreException((Throwable)e, (Object)"Cannot get message next message");
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(rs);
        this.close(stmt);
        this.close(conn);
        return msg;
    }

    @Override
    public synchronized void published(int msgId, int publishedMsgId, String sessionId) throws KuraStoreException {
        Timestamp now = new Timestamp(new Date().getTime());
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.prepareStatement("UPDATE ds_messages SET publishedOn = ?, publishedMessageId = ?, sessionId = ? WHERE id = ?;");
                stmt.setTimestamp(1, now, this.m_utcCalendar);
                stmt.setInt(2, publishedMsgId);
                stmt.setString(3, sessionId);
                stmt.setInt(4, msgId);
                stmt.execute();
                conn.commit();
            }
            catch (SQLException e) {
                this.rollback(conn);
                throw new KuraStoreException((Throwable)e, (Object)"Cannot update timestamp");
            }
        }
        catch (Throwable throwable) {
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(stmt);
        this.close(conn);
    }

    @Override
    public synchronized void published(int msgId) throws KuraStoreException {
        this.updateTimestamp("UPDATE ds_messages SET publishedOn = ? WHERE id = ?;", msgId);
    }

    @Override
    public synchronized void confirmed(int msgId) throws KuraStoreException {
        this.updateTimestamp("UPDATE ds_messages SET confirmedOn = ? WHERE id = ?;", msgId);
    }

    @Override
    public synchronized List<DataMessage> allUnpublishedMessagesNoPayload() throws KuraStoreException {
        return this.listMessages("SELECT id, topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, priority, sessionId, droppedOn FROM ds_messages WHERE publishedOn IS NULL ORDER BY priority ASC, createdOn ASC;", new Integer[0]);
    }

    @Override
    public synchronized List<DataMessage> allInFlightMessagesNoPayload() throws KuraStoreException {
        return this.listMessages("SELECT id, topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, priority, sessionId, droppedOn FROM ds_messages WHERE publishedOn IS NOT NULL AND qos > 0 AND confirmedOn IS NULL AND droppedOn IS NULL ORDER BY priority ASC, createdOn ASC;", new Integer[0]);
    }

    @Override
    public synchronized List<DataMessage> allDroppedInFlightMessagesNoPayload() throws KuraStoreException {
        return this.listMessages("SELECT id, topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, priority, sessionId, droppedOn FROM ds_messages WHERE droppedOn IS NOT NULL ORDER BY priority ASC, createdOn ASC;", new Integer[0]);
    }

    @Override
    public synchronized void unpublishAllInFlighMessages() throws KuraStoreException {
        this.execute("UPDATE ds_messages SET publishedOn = NULL WHERE publishedOn IS NOT NULL AND qos > 0 AND confirmedOn IS NULL;", new Integer[0]);
    }

    @Override
    public synchronized void dropAllInFlightMessages() throws KuraStoreException {
        this.updateTimestamp("UPDATE ds_messages SET droppedOn = ? WHERE publishedOn IS NOT NULL AND qos > 0 AND confirmedOn IS NULL;", new Integer[0]);
    }

    @Override
    public synchronized void deleteStaleMessages(int purgeAge) throws KuraStoreException {
        Throwable cause;
        Timestamp now = new Timestamp(new Date().getTime());
        try {
            this.execute("DELETE FROM ds_messages WHERE DATEDIFF('ss', droppedOn, ?) > ? AND droppedOn IS NOT NULL;", now, purgeAge);
        }
        catch (KuraStoreException e) {
            cause = e.getCause();
            if (cause != null && cause instanceof SQLDataException && ((SQLDataException)cause).getErrorCode() == -3435) {
                s_logger.info("Delete all dropped messages older than one year");
                this.execute("DELETE FROM ds_messages WHERE DATEDIFF('yy', droppedOn, ?) > ? AND droppedOn IS NOT NULL;", now, 0);
            }
            throw e;
        }
        try {
            this.execute("DELETE FROM ds_messages WHERE DATEDIFF('ss', confirmedOn, ?) > ? AND confirmedOn IS NOT NULL;", now, purgeAge);
        }
        catch (KuraStoreException e) {
            cause = e.getCause();
            if (cause != null && cause instanceof SQLDataException && ((SQLDataException)cause).getErrorCode() == -3435) {
                s_logger.info("Delete all confirmed messages older than one year");
                this.execute("DELETE FROM ds_messages WHERE DATEDIFF('yy', confirmedOn, ?) > ? AND confirmedOn IS NOT NULL;", now, 0);
            }
            throw e;
        }
        try {
            this.execute("DELETE FROM ds_messages WHERE qos = 0 AND DATEDIFF('ss', publishedOn, ?) > ? AND publishedOn IS NOT NULL;", now, purgeAge);
        }
        catch (KuraStoreException e) {
            cause = e.getCause();
            if (cause != null && cause instanceof SQLDataException && ((SQLDataException)cause).getErrorCode() == -3435) {
                s_logger.info("Delete all published messages older than one year");
                this.execute("DELETE FROM ds_messages WHERE qos = 0 AND DATEDIFF('yy', publishedOn, ?) > ? AND publishedOn IS NOT NULL;", now, 0);
            }
            throw e;
        }
    }

    @Override
    public synchronized void defrag() throws KuraStoreException {
        this.execute("CHECKPOINT DEFRAG", new Integer[0]);
    }

    @Override
    public synchronized void checkpoint() throws KuraStoreException {
        this.execute("CHECKPOINT", new Integer[0]);
    }

    @Override
    public synchronized void repair() throws KuraStoreException {
        int count;
        Statement stmt;
        PreparedStatement pstmt;
        Connection conn;
        ResultSet rs;
        block6: {
            rs = null;
            conn = null;
            pstmt = null;
            stmt = null;
            count = -1;
            conn = this.getConnection();
            pstmt = conn.prepareStatement("SELECT count(*) FROM (SELECT id, COUNT(id) FROM ds_messages GROUP BY id HAVING (COUNT(id) > 1)) dups;");
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            if (count > 0) break block6;
            this.close(rs);
            this.close(pstmt);
            this.close(stmt);
            this.close(conn);
            return;
        }
        try {
            try {
                s_logger.error("Found messages with duplicate ID. Count of IDs for which duplicates exist: {}. Attempting to repair...", (Object)count);
                stmt = conn.createStatement();
                stmt.execute("ALTER TABLE ds_messages DROP PRIMARY KEY;");
                s_logger.info("Primary key dropped");
                stmt.execute("DELETE FROM ds_messages WHERE id IN (SELECT id FROM ds_messages GROUP BY id HAVING COUNT(*) > 1);");
                s_logger.info("Duplicate messages deleted");
                stmt.execute("ALTER TABLE ds_messages ADD PRIMARY KEY (id);");
                s_logger.info("Primary key created");
                conn.commit();
                stmt.execute("CHECKPOINT DEFRAG");
                s_logger.info("Checkpoint defrag");
                conn.commit();
            }
            catch (SQLException e) {
                this.rollback(conn);
                throw new KuraStoreException((Throwable)e, (Object)"Cannot repair database");
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(pstmt);
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(rs);
        this.close(pstmt);
        this.close(stmt);
        this.close(conn);
    }

    private synchronized void updateTimestamp(String sql, Integer ... msgIds) throws KuraStoreException {
        Timestamp now = new Timestamp(new Date().getTime());
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.prepareStatement(sql);
                stmt.setTimestamp(1, now, this.m_utcCalendar);
                int i = 0;
                while (i < msgIds.length) {
                    stmt.setInt(2 + i, msgIds[i]);
                    ++i;
                }
                stmt.execute();
                conn.commit();
            }
            catch (SQLException e) {
                this.rollback(conn);
                throw new KuraStoreException((Throwable)e, (Object)"Cannot update timestamp");
            }
        }
        catch (Throwable throwable) {
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(stmt);
        this.close(conn);
    }

    private synchronized List<DataMessage> listMessages(String sql, Integer ... params) throws KuraStoreException {
        ArrayList<DataMessage> msgs = new ArrayList();
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.prepareStatement(sql);
                if (params != null) {
                    int i = 0;
                    while (i < params.length) {
                        stmt.setInt(2 + i, params[i]);
                        ++i;
                    }
                }
                rs = stmt.executeQuery();
                msgs = this.buildDataMessagesNoPayload(rs);
            }
            catch (Exception e) {
                throw new KuraStoreException((Throwable)e, (Object)"Cannot list messages");
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(rs);
        this.close(stmt);
        this.close(conn);
        return msgs;
    }

    private synchronized void execute(String sql, Integer ... params) throws KuraStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.prepareStatement(sql);
                int i = 0;
                while (i < params.length) {
                    stmt.setInt(1 + i, params[i]);
                    ++i;
                }
                stmt.execute();
                conn.commit();
            }
            catch (SQLException e) {
                this.rollback(conn);
                throw new KuraStoreException((Throwable)e, (Object)"Cannot execute query");
            }
        }
        catch (Throwable throwable) {
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(stmt);
        this.close(conn);
    }

    private synchronized void execute(String sql, Timestamp timestamp, Integer ... params) throws KuraStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.prepareStatement(sql);
                if (timestamp != null) {
                    stmt.setTimestamp(1, timestamp, this.m_utcCalendar);
                }
                int i = 0;
                while (i < params.length) {
                    stmt.setInt(2 + i, params[i]);
                    ++i;
                }
                stmt.execute();
                conn.commit();
            }
            catch (SQLException e) {
                this.rollback(conn);
                throw new KuraStoreException((Throwable)e, (Object)"Cannot execute query");
            }
        }
        catch (Throwable throwable) {
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(stmt);
        this.close(conn);
    }

    private List<DataMessage> buildDataMessagesNoPayload(ResultSet rs) throws SQLException, IOException {
        ArrayList<DataMessage> messages = new ArrayList<DataMessage>();
        while (rs.next()) {
            messages.add(this.buildDataMessageNoPayload(rs));
        }
        return messages;
    }

    private DataMessage buildDataMessageNoPayload(ResultSet rs) throws SQLException {
        DataMessage.Builder builder = this.buildDataMessageBuilder(rs);
        return builder.build();
    }

    private DataMessage buildDataMessage(ResultSet rs) throws SQLException {
        DataMessage.Builder builder = this.buildDataMessageBuilder(rs);
        builder = builder.withPayload(rs.getBytes("payload"));
        return builder.build();
    }

    private DataMessage.Builder buildDataMessageBuilder(ResultSet rs) throws SQLException {
        DataMessage.Builder builder = new DataMessage.Builder(rs.getInt("id")).withTopic(rs.getString("topic")).withQos(rs.getInt("qos")).withRetain(rs.getBoolean("retain")).withCreatedOn(rs.getTimestamp("createdOn", this.m_utcCalendar)).withPublishedOn(rs.getTimestamp("publishedOn", this.m_utcCalendar)).withPublishedMessageId(rs.getInt("publishedMessageId")).withConfirmedOn(rs.getTimestamp("confirmedOn", this.m_utcCalendar)).withPriority(rs.getInt("priority")).withSessionId(rs.getString("sessionId")).withDroppedOn(rs.getTimestamp("droppedOn"));
        return builder;
    }

    private Connection getConnection() throws SQLException {
        return this.m_dbService.getConnection();
    }

    private void rollback(Connection conn) {
        this.m_dbService.rollback(conn);
    }

    private void close(ResultSet ... rss) {
        this.m_dbService.close(rss);
    }

    private void close(Statement ... stmts) {
        this.m_dbService.close(stmts);
    }

    private void close(Connection conn) {
        this.m_dbService.close(conn);
    }
}

